/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.marshaller.stream;

import com.arm.mgd.core.target.marshaller.stream.AbstractBinaryStreamDecoder;
import com.arm.mgd.core.target.marshaller.stream.AbstractBinaryStreamEncoder;
import com.arm.mgd.core.target.marshaller.stream.ReadMessageLengthException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.eclipse.jdt.annotation.NonNull;

public class LZ4CompressedBinaryStream {

    public static class Decoder
    extends AbstractBinaryStreamDecoder {
        private static final int LENGTH_SIZE = 4;
        final LZ4FastDecompressor decompressor;

        public Decoder(@NonNull InputStream inputStream) {
            super(inputStream);
            LZ4Factory factory = LZ4Factory.fastestInstance();
            this.decompressor = factory.fastDecompressor();
        }

        @Override
        public byte[] readMessage() throws IOException {
            byte[] compressedMessageBytes;
            int uncompressedMessageLength;
            block4: {
                try {
                    int compressedMessageLength = this.getLengthFromMessage() - 4;
                    uncompressedMessageLength = this.getLengthFromMessage();
                    compressedMessageBytes = new byte[compressedMessageLength];
                    if (this.blockingRead(compressedMessageBytes)) break block4;
                    return null;
                }
                catch (ReadMessageLengthException e) {
                    return null;
                }
            }
            if (uncompressedMessageLength != 0) {
                byte[] restored = new byte[uncompressedMessageLength];
                this.decompressor.decompress(compressedMessageBytes, 0, restored, 0, uncompressedMessageLength);
                return restored;
            }
            return compressedMessageBytes;
        }

        private int getLengthFromMessage() throws IOException, ReadMessageLengthException {
            byte[] messageLengthBytes = new byte[4];
            if (!this.blockingRead(messageLengthBytes)) {
                throw new ReadMessageLengthException();
            }
            ByteBuffer bb = ByteBuffer.wrap(messageLengthBytes);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            return bb.getInt();
        }
    }

    public static class Encoder
    extends AbstractBinaryStreamEncoder {
        final LZ4Compressor compressor;

        public Encoder(@NonNull OutputStream outputStream, boolean useFast) {
            super(outputStream);
            LZ4Factory factory = LZ4Factory.safeInstance();
            this.compressor = useFast ? factory.fastCompressor() : factory.highCompressor();
        }

        @Override
        public void writeMessage(byte @NonNull [] messageData) throws IOException {
            int uncompressedSize = messageData.length;
            int compressedSize = (int)((double)uncompressedSize / 1.25);
            byte[] compressed = new byte[compressedSize];
            try {
                compressedSize = this.compressor.compress(messageData, 0, uncompressedSize, compressed, 0, compressedSize);
            }
            catch (ArrayIndexOutOfBoundsException | LZ4Exception lz4Exception) {
                compressedSize = uncompressedSize;
                uncompressedSize = 0;
            }
            byte[] messageLengthBytes = new byte[4];
            ByteBuffer bb = ByteBuffer.wrap(messageLengthBytes);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            bb.putInt(compressedSize + messageLengthBytes.length);
            this.outputStream.write(messageLengthBytes);
            messageLengthBytes = new byte[4];
            bb = ByteBuffer.wrap(messageLengthBytes);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            bb.putInt(uncompressedSize);
            this.outputStream.write(messageLengthBytes);
            if (uncompressedSize == 0) {
                this.outputStream.write(messageData, 0, compressedSize);
            } else {
                this.outputStream.write(compressed, 0, compressedSize);
            }
        }
    }
}

