/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.marshaller.stream;

import com.arm.mgd.core.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractBinaryStreamDecoder {
    protected long nBytesReadThisSession;
    private final @NonNull InputStream inputStream;

    protected AbstractBinaryStreamDecoder(@NonNull InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public final long getNumberOfBytesReadThisSession() {
        return this.nBytesReadThisSession;
    }

    public abstract byte[] readMessage() throws IOException;

    protected boolean blockingRead(byte[] data) throws IOException {
        boolean result = FileUtils.blockingRead(this.inputStream, data);
        if (result) {
            this.nBytesReadThisSession += (long)data.length;
        }
        return result;
    }
}

