/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.marshaller.bytedata;

import com.arm.mgd.core.target.marshaller.bytedata.AbstractByteDataProvider;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProviderRange;
import com.arm.mgd.utils.NullUtils;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;

class MemoryByteDataProvider
extends AbstractByteDataProvider {
    private final byte @NonNull [] data;

    MemoryByteDataProvider(byte @NonNull [] data) {
        this.data = (byte[])data.clone();
    }

    @Override
    public int getLength() {
        return this.data.length;
    }

    @Override
    public @NonNull ByteBuffer getData() {
        return NullUtils.asReadOnlyByteBuffer((byte[])this.data);
    }

    @Override
    public @NonNull ByteBuffer getDataRange(int from, int to) {
        return this.sliceData(from, to);
    }

    @Override
    public byte @NonNull [] cloneData() {
        return (byte[])this.data.clone();
    }

    @Override
    public @NonNull IByteDataProvider getRange(int from, int to) {
        this.validateRangeArgs(from, to);
        return new IByteDataProviderRange(this, from, to);
    }
}

