/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.marshaller.bytedata;

import com.arm.mgd.core.target.marshaller.bytedata.AbstractByteDataProvider;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;

class IByteDataProviderRange
extends AbstractByteDataProvider {
    private final @NonNull AbstractByteDataProvider parentProvider;
    private final int rangeFrom;
    private final int rangeTo;

    protected IByteDataProviderRange(@NonNull AbstractByteDataProvider parentProvider, int from, int to) {
        parentProvider.validateRangeArgs(from, to);
        this.parentProvider = parentProvider;
        this.rangeFrom = from;
        this.rangeTo = to;
    }

    @Override
    public int getLength() {
        return this.rangeTo - this.rangeFrom;
    }

    @Override
    public @NonNull ByteBuffer getData() {
        return this.parentProvider.getDataRange(this.rangeFrom, this.rangeTo);
    }

    @Override
    public @NonNull ByteBuffer getDataRange(int from, int to) {
        this.validateRangeArgs(from, to);
        return this.parentProvider.getDataRange(this.rangeFrom + from, this.rangeFrom + to);
    }

    @Override
    public byte @NonNull [] cloneData() {
        byte[] data = new byte[this.getLength()];
        this.getData().get(data);
        return data;
    }

    @Override
    public @NonNull IByteDataProvider getRange(int from, int to) {
        this.validateRangeArgs(from, to);
        return new IByteDataProviderRange(this.parentProvider, this.rangeFrom + from, this.rangeFrom + to);
    }
}

