/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.marshaller.bytedata;

import com.arm.mgd.core.target.marshaller.bytedata.AbstractByteSupplier;
import com.arm.mgd.core.target.marshaller.bytedata.ByteSupplierByteDataProvider;
import com.arm.mgd.core.target.marshaller.bytedata.MemoryByteDataProvider;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;

public interface IByteDataProvider {
    public static final @NonNull IByteDataProvider EMPTY = new MemoryByteDataProvider(new byte[0]);

    public int getLength();

    default public boolean isEmpty() {
        return this.getLength() == 0;
    }

    public @NonNull ByteBuffer getData();

    public @NonNull ByteBuffer getDataRange(int var1, int var2);

    public byte @NonNull [] cloneData();

    public @NonNull IByteDataProvider getRange(int var1, int var2);

    public static @NonNull IByteDataProvider createMemoryProvider(byte @NonNull [] data) {
        if (data.length == 0) {
            return EMPTY;
        }
        return new MemoryByteDataProvider(data);
    }

    public static @NonNull IByteDataProvider createByteSupplierProvider(@NonNull AbstractByteSupplier byteSupplier) {
        if (byteSupplier.getLength() == 0) {
            return EMPTY;
        }
        return new ByteSupplierByteDataProvider(byteSupplier);
    }
}

