/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.marshaller.bytedata;

import com.arm.mgd.core.target.marshaller.TraceParseException;
import com.arm.mgd.core.target.marshaller.bytedata.AbstractByteSupplier;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.target.marshaller.bytedata.IByteStore;
import com.arm.mgd.utils.NullUtils;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DynamicByteDataModel {
    private final @NonNull Map<@NonNull Integer, Integer> processIdToOffsetMapping = new HashMap<Integer, Integer>();
    private final @NonNull List<@NonNull ProcessDynamicByteData> processes = new ArrayList<ProcessDynamicByteData>();
    private final @NonNull IByteStore byteStore;
    private final @NonNull ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.lock.writeLock();
    private final Lock readLock = this.lock.readLock();

    public DynamicByteDataModel(@NonNull IByteStore byteStore) {
        this.byteStore = byteStore;
    }

    public void addToModel(int processId,  @NonNull MgdProtosV2.DynamicByteDataProto byteData) throws TraceParseException {
        DynamicByteData data = new DynamicByteData(byteData, this.byteStore);
        assert (byteData.hasId());
        int id = (int)byteData.getId();
        Integer pid = NullUtils.intValueOf((int)processId);
        try {
            ProcessDynamicByteData processData;
            this.writeLock.lock();
            @Nullable Integer processOffset = this.processIdToOffsetMapping.get(pid);
            if (processOffset == null) {
                processOffset = NullUtils.intValueOf((int)this.processes.size());
                processData = new ProcessDynamicByteData();
                this.processIdToOffsetMapping.put(pid, processOffset);
                this.processes.add(processData);
            } else {
                processData = this.processes.get(processOffset);
                if (id < processData.size()) {
                    processOffset = NullUtils.intValueOf((int)this.processes.size());
                    processData = new ProcessDynamicByteData();
                    this.processIdToOffsetMapping.put(pid, processOffset);
                    this.processes.add(processData);
                }
            }
            processData.add(id, data);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public @NonNull IByteDataProvider getProvider(int processId, long dynamicByteDataId) throws TraceParseException {
        try {
            this.readLock.lock();
            @Nullable Integer processOffset = this.processIdToOffsetMapping.get(NullUtils.intValueOf((int)processId));
            if (processOffset == null) {
                throw new TraceParseException("No dynamic byte data received for process with id " + processId);
            }
            ProcessDynamicByteData processData = this.processes.get(processOffset);
            DynamicByteData initialData = processData.get((int)dynamicByteDataId);
            if (initialData == null) {
                throw new TraceParseException("Dynamic byte data with id " + dynamicByteDataId + " was not received for process " + processId);
            }
            int expectedLength = initialData.size;
            int totalLength = initialData.data.getLength();
            int nextId = (int)dynamicByteDataId + 1;
            while (totalLength < expectedLength) {
                DynamicByteData nextData = processData.get(nextId);
                if (nextData == null) {
                    throw new TraceParseException("Dynamic byte data with id " + dynamicByteDataId + " for process " + processId + " has chained message with id " + nextId + " that was not received");
                }
                ++nextId;
                totalLength += nextData.data.getLength();
            }
            if (expectedLength != totalLength) {
                throw new TraceParseException("Dynamic byte data with id " + dynamicByteDataId + " for process " + processId + " has expected length " + expectedLength + ", but data chain was " + totalLength);
            }
            IByteDataProvider iByteDataProvider = IByteDataProvider.createByteSupplierProvider(new DynamicByteDataSupplier(this, processOffset, (int)dynamicByteDataId, expectedLength));
            return iByteDataProvider;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private byte @NonNull [] getData(int processOffset, int byteDataId) {
        try {
            byte[] nextSrcData;
            this.readLock.lock();
            ProcessDynamicByteData processData = this.processes.get(processOffset);
            DynamicByteData initialData = processData.get(byteDataId);
            assert (initialData != null);
            byte @NonNull [] initialSrcData = initialData.data.get();
            if (initialSrcData.length == initialData.size) {
                byte[] byArray = initialSrcData;
                return byArray;
            }
            byte @NonNull [] data = new byte[initialData.size];
            int offset = 0;
            System.arraycopy(initialSrcData, 0, data, offset, initialSrcData.length);
            offset += initialSrcData.length;
            int nextId = byteDataId + 1;
            do {
                DynamicByteData nextData = processData.get(nextId);
                assert (nextData != null);
                nextSrcData = nextData.data.get();
                System.arraycopy(nextSrcData, 0, data, offset, nextSrcData.length);
                ++nextId;
            } while ((offset += nextSrcData.length) < data.length);
            assert (offset == data.length);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static class DynamicByteData {
        private final @NonNull AbstractByteSupplier data;
        private final int size;

        private DynamicByteData( @NonNull MgdProtosV2.DynamicByteDataProto byteData, @NonNull IByteStore byteStore) throws TraceParseException {
            if (!byteData.hasId()) {
                throw new TraceParseException("Dynamic byte data message with no id received");
            }
            long id = byteData.getId();
            if (id > Integer.MAX_VALUE) {
                throw new TraceParseException("Dynamic byte data message with id greater than INT_MAX received");
            }
            if (!byteData.hasLength()) {
                throw new TraceParseException("Dynamic byte data message with id " + id + " has no specified length");
            }
            long length = byteData.getLength();
            if (!byteData.hasData()) {
                throw new TraceParseException("Dynamic byte data message with id " + id + " has expected length " + length + " but has no data");
            }
            ByteString bytes = byteData.getData();
            if ((long)bytes.size() > length) {
                throw new TraceParseException("Dynamic byte data message with id " + id + " expected data of length less than or equal to " + length + " but data was length " + bytes.size());
            }
            this.data = byteStore.add((ByteString)NullUtils.neverNull((Object)bytes));
            this.size = (int)length;
        }
    }

    private static class DynamicByteDataSupplier
    extends AbstractByteSupplier {
        private final @NonNull DynamicByteDataModel model;
        private final int processOffset;
        private final int dataIndex;
        private final int length;

        private DynamicByteDataSupplier(@NonNull DynamicByteDataModel model, int processOffset, int dataIndex, int length) {
            this.model = model;
            this.processOffset = processOffset;
            this.dataIndex = dataIndex;
            this.length = length;
        }

        @Override
        public byte @NonNull [] get() {
            return this.model.getData(this.processOffset, this.dataIndex);
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    private static class ProcessDynamicByteData {
        private final @NonNull ArrayList<@Nullable DynamicByteData> data = new ArrayList();

        private ProcessDynamicByteData() {
        }

        private void add(int id, @NonNull DynamicByteData byteData) {
            int curSize = this.data.size();
            assert (id >= curSize);
            int i = 0;
            while (i < id - curSize) {
                this.data.add(null);
                ++i;
            }
            this.data.add(byteData);
            assert (this.data.size() == id + 1);
        }

        private int size() {
            return this.data.size();
        }

        private @Nullable DynamicByteData get(int id) {
            if (id < 0 || id >= this.size()) {
                return null;
            }
            return this.data.get(id);
        }
    }
}

