/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.marshaller.bytedata;

import com.arm.mgd.core.target.marshaller.bytedata.AbstractByteSupplier;
import com.arm.mgd.core.target.marshaller.bytedata.ByteSupplier;
import com.arm.mgd.core.target.marshaller.bytedata.IByteStore;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.FileUtils;
import com.arm.mgd.core.util.executors.NamedExecutors;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import com.arm.mgd.utils.NullUtils;
import com.arm.mgd.utils.OSUtils;
import com.google.protobuf.ByteString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CompressedMemoryMappedByteStore
implements IByteStore {
    private static final int DEFAULT_MAXIMUM_PENDING_COMPRESSION_BYTES = 0x1000000;
    private static final int DEFAULT_WRITE_BYTES_TO_DISK_THRESHOLD = 0x2000000;
    private static final long DEFAULT_MINUMUM_REQUIRED_FREE_DISK_SPACE = Integer.MIN_VALUE;
    private static final @NonNull LZ4Compressor COMPRESSOR;
    private static final @NonNull LZ4FastDecompressor DECOMPRESSOR;
    private final @NonNull String storeName;
    private final int blockThresholdBytes;
    private final int fileWriteThresholdBytes;
    private final @NonNull IFileFactory fileFactory;
    private final @NonNull IMemoryMapper memoryMapper;
    private final boolean isDefaultExecutorThread;
    private final @NonNull ExecutorService executorThread;
    private final @NonNull ArrayList<@NonNull PendingWriteData> pendingWritableProviders = new ArrayList();
    private final AtomicInteger pendingCompressedDataLength = new AtomicInteger();
    private int pendingWritableDataLength = 0;
    private final @NonNull List<@NonNull File> byteStoreFiles = new ArrayList<File>();
    private final @NonNull AtomicBoolean isDisposed = new AtomicBoolean(false);

    static {
        LZ4Factory factory = LZ4Factory.safeInstance();
        COMPRESSOR = (LZ4Compressor)NullUtils.neverNull((Object)factory.fastCompressor());
        DECOMPRESSOR = (LZ4FastDecompressor)NullUtils.neverNull((Object)factory.fastDecompressor());
    }

    public CompressedMemoryMappedByteStore(@NonNull String storeName) {
        this(storeName, -1, -1, null, null, null);
    }

    CompressedMemoryMappedByteStore(@NonNull String storeName, int blockThresholdBytes, int fileWriteThresholdBytes, @Nullable IFileFactory fileFactory, @Nullable IMemoryMapper memoryMapper, @Nullable ExecutorService executor) {
        this.storeName = storeName = (String)NullUtils.neverNull((Object)storeName.replaceAll("\\s+", "_"));
        this.blockThresholdBytes = blockThresholdBytes > 0 ? blockThresholdBytes : 0x1000000;
        this.fileWriteThresholdBytes = fileWriteThresholdBytes > 0 ? fileWriteThresholdBytes : 0x2000000;
        this.fileFactory = fileFactory != null ? fileFactory : CompressedMemoryMappedByteStore.createDefaultFileFactory(storeName);
        this.memoryMapper = memoryMapper != null ? memoryMapper : CompressedMemoryMappedByteStore.createDefaultMemoryMapper();
        this.isDefaultExecutorThread = executor == null;
        this.executorThread = executor != null ? executor : CompressedMemoryMappedByteStore.createDefaultExecutorThread(storeName);
    }

    @Override
    public @NonNull AbstractByteSupplier add(byte @NonNull [] data) {
        return this.addShared(new ByteSupplier(data));
    }

    @Override
    public @NonNull AbstractByteSupplier add(@NonNull ByteString data) {
        return this.addShared(new ByteSupplier(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @NonNull AbstractByteSupplier addShared(@NonNull ByteSupplier byteSupplier) {
        int supplierLength = byteSupplier.getLength();
        if (supplierLength == 0) {
            return AbstractByteSupplier.EMPTY_BYTE_SUPPLIER;
        }
        PendingCompressionData pendingData = new PendingCompressionData(byteSupplier);
        CompressedMemoryMappedByteStore compressedMemoryMappedByteStore = this;
        synchronized (compressedMemoryMappedByteStore) {
            while (this.pendingCompressedDataLength.get() > this.blockThresholdBytes) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.isDisposed.get()) continue;
                return pendingData.proxyByteSupplier;
            }
            this.pendingCompressedDataLength.addAndGet(supplierLength);
        }
        this.executorThread.execute(() -> {
            try {
                if (this.isDisposed.get()) {
                    return;
                }
                PendingWriteData writableData = new PendingWriteData(pendingData);
                this.pendingWritableProviders.add(writableData);
                this.pendingWritableDataLength += writableData.data.length;
                if (this.pendingWritableDataLength > this.fileWriteThresholdBytes) {
                    this.flushPendingDataToDisk();
                }
            }
            finally {
                this.pendingCompressedDataLength.addAndGet(-supplierLength);
            }
        });
        return pendingData.proxyByteSupplier;
    }

    private void flushPendingDataToDisk() {
        File file = null;
        boolean wasFileSuccessfullyWritten = false;
        try {
            try {
                file = this.fileFactory.createFile();
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileOutputStream fos = new FileOutputStream(file);){
                    for (PendingWriteData writeData : this.pendingWritableProviders) {
                        fos.write(writeData.data);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                wasFileSuccessfullyWritten = true;
                MemoryMappedFile mappedFile = null;
                if (OSUtils.OS != OSUtils.OSType.WINDOWS) {
                    try {
                        mappedFile = new MemoryMappedFile(file, this.memoryMapper.mapFile(file));
                    }
                    catch (IOException e) {
                        CoreLogging.warning(null, e, "Unable to memory map file " + file.getName() + " of length " + this.pendingWritableDataLength + " bytes in byte store " + this.storeName + ". Falling back to RandomAccessFile mode.");
                    }
                }
                int offset = 0;
                for (PendingWriteData writeData : this.pendingWritableProviders) {
                    boolean isCompressed = writeData.isCompressed;
                    int fileBytesLength = writeData.data.length;
                    int originalLength = writeData.proxyByteSupplier.getLength();
                    @NonNull AbstractByteSupplier supplier = mappedFile != null ? (isCompressed ? new DecompressingFromMemoryMappedFileByteSupplier(originalLength, mappedFile, offset) : new MemoryMappedFileByteSupplier(originalLength, mappedFile, offset)) : (isCompressed ? new DecompressingFromFileByteSupplier(fileBytesLength, originalLength, file, offset) : new FileByteSupplier(originalLength, file, offset));
                    writeData.proxyByteSupplier.setSupplier(supplier);
                    offset += writeData.data.length;
                }
            }
            catch (Throwable t) {
                CoreLogging.warning(null, t, "Failed to cache " + this.pendingWritableDataLength + " bytes of byte data in the " + this.storeName + " byte store");
                this.pendingWritableProviders.clear();
                this.pendingWritableDataLength = 0;
                if (wasFileSuccessfullyWritten) {
                    assert (file != null);
                    this.byteStoreFiles.add(file);
                } else if (file != null) {
                    file.delete();
                }
            }
        }
        finally {
            this.pendingWritableProviders.clear();
            this.pendingWritableDataLength = 0;
            if (wasFileSuccessfullyWritten) {
                assert (file != null);
                this.byteStoreFiles.add(file);
            } else if (file != null) {
                file.delete();
            }
        }
    }

    public void dispose() {
        this.isDisposed.set(true);
        this.executorThread.execute(() -> {
            for (File file : this.byteStoreFiles) {
                file.delete();
            }
            this.byteStoreFiles.clear();
        });
        if (this.isDefaultExecutorThread) {
            this.executorThread.shutdown();
        }
    }

    private static @NonNull IFileFactory createDefaultFileFactory(@NonNull String storeName) {
        String sanitisedStoreName = storeName.replaceAll("[^a-zA-Z0-9-_\\.]", "_");
        return () -> {
            File file = FileUtils.createTempFile("ByteStore_" + sanitisedStoreName + "_", ".dat");
            long freeDiskSpace = file.getFreeSpace();
            if (freeDiskSpace < Integer.MIN_VALUE) {
                file.delete();
                throw new IOException("Not caching data to disk as free space is less than -2147483648");
            }
            return file;
        };
    }

    private static @NonNull IMemoryMapper createDefaultMemoryMapper() {
        return file -> {
            Throwable throwable = null;
            Object var2_3 = null;
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
                MappedByteBuffer mappedByteBuffer;
                FileChannel fc;
                Throwable throwable2;
                block19: {
                    throwable2 = null;
                    Object var5_8 = null;
                    fc = randomAccessFile.getChannel();
                    mappedByteBuffer = (MappedByteBuffer)NullUtils.neverNull((Object)fc.map(FileChannel.MapMode.READ_ONLY, 0L, randomAccessFile.length()));
                    if (fc == null) break block19;
                    fc.close();
                }
                return mappedByteBuffer;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (fc != null) {
                                fc.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        };
    }

    private static @NonNull ExecutorService createDefaultExecutorThread(@NonNull String storeName) {
        return NamedExecutors.cachedFiniteThreadPool(1, 60L, TimeUnit.SECONDS, new NamedThreadFactory("ByteStore_" + storeName + " Executor", 1));
    }

    private static class DecompressingByteSupplier
    extends AbstractByteSupplier {
        private final int uncompressedLength;
        private final byte @NonNull [] compressedBytes;

        private DecompressingByteSupplier(int uncompressedLength, byte @NonNull [] compressedBytes) {
            this.uncompressedLength = uncompressedLength;
            this.compressedBytes = compressedBytes;
        }

        @Override
        public byte @NonNull [] get() {
            return NullUtils.neverNull((byte[])DECOMPRESSOR.decompress(this.compressedBytes, this.uncompressedLength));
        }

        @Override
        public int getLength() {
            return this.uncompressedLength;
        }
    }

    private static class DecompressingFromFileByteSupplier
    extends AbstractByteSupplier {
        private final int compressedLength;
        private final int uncompressedLength;
        private final @NonNull File file;
        private final int offset;

        private DecompressingFromFileByteSupplier(int compressedLength, int uncompressedLength, @NonNull File file, int offset) {
            this.compressedLength = compressedLength;
            this.uncompressedLength = uncompressedLength;
            this.file = file;
            this.offset = offset;
        }

        @Override
        public byte @NonNull [] get() {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "r");){
                    randomAccessFile.seek(this.offset);
                    byte[] source = new byte[this.compressedLength];
                    randomAccessFile.readFully(source);
                    return NullUtils.neverNull((byte[])DECOMPRESSOR.decompress(source, this.uncompressedLength));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                CoreLogging.severe(null, e, "Unable to read compressed byte data from file " + this.file.getName());
                throw new RuntimeException(e);
            }
        }

        @Override
        public int getLength() {
            return this.uncompressedLength;
        }
    }

    private static class DecompressingFromMemoryMappedFileByteSupplier
    extends AbstractByteSupplier {
        private final int uncompressedLength;
        private final @NonNull MemoryMappedFile mappedFile;
        private final int offset;

        private DecompressingFromMemoryMappedFileByteSupplier(int uncompressedLength, @NonNull MemoryMappedFile mappedFile, int offset) {
            this.uncompressedLength = uncompressedLength;
            this.mappedFile = mappedFile;
            this.offset = offset;
        }

        @Override
        public byte @NonNull [] get() {
            try {
                ByteBuffer decompressed = ByteBuffer.allocate(this.uncompressedLength);
                DECOMPRESSOR.decompress((ByteBuffer)this.mappedFile.buffer, this.offset, decompressed, 0, this.uncompressedLength);
                return NullUtils.neverNull((byte[])decompressed.array());
            }
            catch (Throwable t) {
                CoreLogging.severe(null, t, "Unable to read compressed byte data from memory mapped file " + this.mappedFile.file.getName());
                throw t;
            }
        }

        @Override
        public int getLength() {
            return this.uncompressedLength;
        }
    }

    private static class FileByteSupplier
    extends AbstractByteSupplier {
        private final int length;
        private final @NonNull File file;
        private final int offset;

        private FileByteSupplier(int length, @NonNull File file, int offset) {
            this.length = length;
            this.file = file;
            this.offset = offset;
        }

        @Override
        public byte @NonNull [] get() {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "r");){
                    randomAccessFile.seek(this.offset);
                    byte[] source = new byte[this.length];
                    randomAccessFile.readFully(source);
                    return source;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                CoreLogging.severe(null, e, "Unable to read byte data from file " + this.file.getName());
                throw new RuntimeException(e);
            }
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    static interface IFileFactory {
        public @NonNull File createFile() throws IOException;
    }

    static interface IMemoryMapper {
        public @NonNull MappedByteBuffer mapFile(@NonNull File var1) throws IOException;
    }

    private static class MemoryMappedFile {
        private final @NonNull File file;
        private final @NonNull MappedByteBuffer buffer;

        private MemoryMappedFile(@NonNull File file, @NonNull MappedByteBuffer buffer) {
            this.file = file;
            this.buffer = buffer;
        }
    }

    private static class MemoryMappedFileByteSupplier
    extends AbstractByteSupplier {
        private final int length;
        private final @NonNull MemoryMappedFile mappedFile;
        private final int offset;

        private MemoryMappedFileByteSupplier(int length, @NonNull MemoryMappedFile mappedFile, int offset) {
            this.length = length;
            this.mappedFile = mappedFile;
            this.offset = offset;
        }

        @Override
        public byte @NonNull [] get() {
            try {
                ByteBuffer newBuffer = this.mappedFile.buffer.asReadOnlyBuffer();
                newBuffer.position(this.offset);
                byte @NonNull [] bytes = new byte[this.length];
                newBuffer.get(bytes);
                return bytes;
            }
            catch (Throwable t) {
                CoreLogging.severe(null, t, "Unable to read byte data from memory mapped file " + this.mappedFile.file.getName());
                throw t;
            }
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    private static class PendingCompressionData {
        private final @NonNull ByteSupplier uncompressedByteSupplier;
        private final @NonNull ProxyByteSupplier proxyByteSupplier;

        private PendingCompressionData(@NonNull ByteSupplier byteSupplier) {
            this.uncompressedByteSupplier = byteSupplier;
            this.proxyByteSupplier = new ProxyByteSupplier(byteSupplier);
        }
    }

    private static class PendingWriteData {
        private final boolean isCompressed;
        private final byte @NonNull [] data;
        private final @NonNull ProxyByteSupplier proxyByteSupplier;

        private PendingWriteData(@NonNull PendingCompressionData pendingData) {
            this.proxyByteSupplier = pendingData.proxyByteSupplier;
            byte @NonNull [] uncompressedData = pendingData.uncompressedByteSupplier.get();
            byte @Nullable [] compressedData = COMPRESSOR.compress(uncompressedData);
            if (compressedData == null || compressedData.length > uncompressedData.length) {
                this.isCompressed = false;
                this.data = uncompressedData;
            } else {
                this.isCompressed = true;
                this.data = compressedData;
                this.proxyByteSupplier.setSupplier(new DecompressingByteSupplier(uncompressedData.length, compressedData));
            }
        }
    }

    private static class ProxyByteSupplier
    extends AbstractByteSupplier {
        private final @NonNull AtomicReference<@NonNull AbstractByteSupplier> supplier;

        private ProxyByteSupplier(@NonNull AbstractByteSupplier supplier) {
            this.supplier = new AtomicReference<AbstractByteSupplier>(supplier);
        }

        @Override
        public byte @NonNull [] get() {
            return this.supplier.get().get();
        }

        @Override
        public int getLength() {
            return this.supplier.get().getLength();
        }

        private void setSupplier(@NonNull AbstractByteSupplier supplier) {
            assert (this.getLength() == supplier.getLength());
            this.supplier.set(supplier);
        }
    }
}

