/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.marshaller.bytedata;

import com.arm.mgd.core.target.marshaller.bytedata.AbstractByteDataProvider;
import com.arm.mgd.core.target.marshaller.bytedata.AbstractByteSupplier;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProviderRange;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

class ByteSupplierByteDataProvider
extends AbstractByteDataProvider {
    private final @NonNull AbstractByteSupplier byteSupplier;
    private @NonNull WeakReference<byte @Nullable []> weakData;

    ByteSupplierByteDataProvider(@NonNull AbstractByteSupplier byteSupplier) {
        this.byteSupplier = byteSupplier;
        this.weakData = NullUtils.emptyWeakReference();
    }

    @Override
    public int getLength() {
        return this.byteSupplier.getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte @NonNull [] getBytes() {
        byte @Nullable [] data = (byte[])this.weakData.get();
        if (data == null) {
            ByteSupplierByteDataProvider byteSupplierByteDataProvider = this;
            synchronized (byteSupplierByteDataProvider) {
                data = (byte[])this.weakData.get();
                if (data == null) {
                    data = this.byteSupplier.get();
                    this.weakData = new WeakReference<byte[]>(data);
                }
            }
        }
        return data;
    }

    @Override
    public @NonNull ByteBuffer getData() {
        return NullUtils.asReadOnlyByteBuffer((byte[])this.getBytes());
    }

    @Override
    public @NonNull ByteBuffer getDataRange(int from, int to) {
        return this.sliceData(from, to);
    }

    @Override
    public byte @NonNull [] cloneData() {
        return (byte[])this.getBytes().clone();
    }

    @Override
    public @NonNull IByteDataProvider getRange(int from, int to) {
        return new IByteDataProviderRange(this, from, to);
    }
}

