/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.marshaller.bytedata;

import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.utils.NullUtils;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;

abstract class AbstractByteDataProvider
implements IByteDataProvider {
    private int cachedHash = 0;

    AbstractByteDataProvider() {
    }

    protected void validateRangeArgs(int from, int to) throws IllegalArgumentException {
        int length = this.getLength();
        if (from < 0) {
            throw new IllegalArgumentException("from arg was " + from + " which is negative");
        }
        if (from > length) {
            throw new IllegalArgumentException("IByteDataProvider length is " + length + ", but from arg was " + from);
        }
        if (to > length) {
            throw new IllegalArgumentException("IByteDataProvider length is " + length + ", but to arg was " + to);
        }
        if (to < from) {
            throw new IllegalArgumentException("to arg was " + to + ", which was less than from arg which was " + from);
        }
    }

    protected @NonNull ByteBuffer sliceData(int from, int to) {
        this.validateRangeArgs(from, to);
        ByteBuffer data = this.getData();
        data.position(from);
        data.limit(to);
        @NonNull ByteBuffer slice = (ByteBuffer)NullUtils.neverNull((Object)data.slice());
        assert (slice.remaining() == to - from);
        return slice;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IByteDataProvider) {
            IByteDataProvider that = (IByteDataProvider)obj;
            if (this.getLength() == that.getLength() && this.getData().equals(that.getData())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHash == 0) {
            this.cachedHash = this.getData().hashCode();
        }
        return this.cachedHash;
    }
}

