/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.marshaller.binary_v2;

import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.midstream.AbstractMidstreamAssetItemPropertyValue;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.MidstreamAssetItemProperty;
import com.arm.mgd.core.midstream.MidstreamAssetItemPropertyMapEntryValue;
import com.arm.mgd.core.midstream.MidstreamAssetItemPropertyMapValue;
import com.arm.mgd.core.midstream.MidstreamAssetItemPropertySingleValue;
import com.arm.mgd.core.midstream.MidstreamDataAttachment;
import com.arm.mgd.core.midstream.MidstreamStateItem;
import com.arm.mgd.core.pb.v2.MgdProtosV2;
import com.arm.mgd.core.replay.shader.PrecisionModeModifier;
import com.arm.mgd.core.target.data.AbstractFreeAttachment;
import com.arm.mgd.core.target.data.AbstractOverrideAttachment;
import com.arm.mgd.core.target.data.ArgumentContainerArrayAttachment;
import com.arm.mgd.core.target.data.ArgumentContainerAttachment;
import com.arm.mgd.core.target.data.AsynchronousFunctionAttachment;
import com.arm.mgd.core.target.data.AsynchronousFunctionData;
import com.arm.mgd.core.target.data.AuthorisationFeatureEventAttachment;
import com.arm.mgd.core.target.data.ClKernelAttachment;
import com.arm.mgd.core.target.data.CommandAttachment;
import com.arm.mgd.core.target.data.CommandObject;
import com.arm.mgd.core.target.data.DeferredCommandAttachment;
import com.arm.mgd.core.target.data.DeviceConnectionRequestEventAttachment;
import com.arm.mgd.core.target.data.DeviceInfoEventAttachment;
import com.arm.mgd.core.target.data.EGLAttributeAttachment;
import com.arm.mgd.core.target.data.EGLConfigAttributeArrayAttachment;
import com.arm.mgd.core.target.data.EGLSurfaceAttributeArrayAttachment;
import com.arm.mgd.core.target.data.ExecutionStateTargetEventAttachment;
import com.arm.mgd.core.target.data.FeatureAuthorisationCommandAttachment;
import com.arm.mgd.core.target.data.FeatureAuthorisationRequestEventAttachment;
import com.arm.mgd.core.target.data.FloatsArgAttachment;
import com.arm.mgd.core.target.data.ForcePrecisionModeOverrideAttachment;
import com.arm.mgd.core.target.data.FrameCaptureStateTargetEventAttachment;
import com.arm.mgd.core.target.data.FrameFeaturesFlagsEnum;
import com.arm.mgd.core.target.data.FramebufferAttachment;
import com.arm.mgd.core.target.data.FramebufferDiffAttachment;
import com.arm.mgd.core.target.data.InterceptorExecutionState;
import com.arm.mgd.core.target.data.InterceptorTarget;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.MappingAttachment;
import com.arm.mgd.core.target.data.MidstreamDataTargetEventAttachment;
import com.arm.mgd.core.target.data.PollGLESBufferContentsAttachment;
import com.arm.mgd.core.target.data.ProcessEndedTargetEventAttachment;
import com.arm.mgd.core.target.data.ProcessStartedTargetEventAttachment;
import com.arm.mgd.core.target.data.ProgramGeometryShaderProperties;
import com.arm.mgd.core.target.data.ProgramOverrideAttachment;
import com.arm.mgd.core.target.data.ProgramResourceDescriptor;
import com.arm.mgd.core.target.data.ProgramResourceDescriptorMap;
import com.arm.mgd.core.target.data.ProgramTessellationShaderProperties;
import com.arm.mgd.core.target.data.ScreenshotAttachment;
import com.arm.mgd.core.target.data.ShaderAttributeAttachment;
import com.arm.mgd.core.target.data.ShaderProgramAttachment;
import com.arm.mgd.core.target.data.SoftwareCounterAttachment;
import com.arm.mgd.core.target.data.StringsArgAttachment;
import com.arm.mgd.core.target.data.TargetEvent;
import com.arm.mgd.core.target.data.TargetEventAttachment;
import com.arm.mgd.core.target.data.TargetEventDescriptor;
import com.arm.mgd.core.target.data.TextureOverrideAttachment;
import com.arm.mgd.core.target.data.VersionInfoEventAttachment;
import com.arm.mgd.core.target.data.VertexBufferAttachment;
import com.arm.mgd.core.target.data.VulkanCommandIndex;
import com.arm.mgd.core.target.data.VulkanDeviceMemoryContentsAttachment;
import com.arm.mgd.core.target.data.VulkanFramebufferAttachment;
import com.arm.mgd.core.target.data.VulkanImageDiffAttachment;
import com.arm.mgd.core.target.data.VulkanImageMemoryRequirementsAttachment;
import com.arm.mgd.core.target.data.VulkanImageSubresourceLayoutAttachment;
import com.arm.mgd.core.target.data.VulkanSubmitAttachment;
import com.arm.mgd.core.target.data.VulkanSubmitData;
import com.arm.mgd.core.target.data.interceptorconfig.InterceptorConfig;
import com.arm.mgd.core.target.data.interceptorconfig.InterceptorConfigCommandAttachment;
import com.arm.mgd.core.target.data.interceptorconfig.InterceptorConfigEventAttachment;
import com.arm.mgd.core.target.data.interceptorconfig.cl.ClConfig;
import com.arm.mgd.core.target.data.interceptorconfig.cl.ClResource;
import com.arm.mgd.core.target.data.interceptorconfig.gles.GlesConfig;
import com.arm.mgd.core.target.data.interceptorconfig.gles.GlesResource;
import com.arm.mgd.core.target.data.interceptorconfig.vulkan.VulkanConfig;
import com.arm.mgd.core.target.data.interceptorconfig.vulkan.VulkanResource;
import com.arm.mgd.core.target.data.memoryreport.MemoryReportDataAttachment;
import com.arm.mgd.core.target.io.live.DaemonCommand;
import com.arm.mgd.core.target.io.live.GlobalInterceptorCommand;
import com.arm.mgd.core.target.io.live.IGlobalInterceptorCommand;
import com.arm.mgd.core.target.io.live.IInterceptorCommand;
import com.arm.mgd.core.target.io.live.IPerProcessInterceptorCommand;
import com.arm.mgd.core.target.io.live.ModifyStateInterceptorCommand;
import com.arm.mgd.core.target.io.live.PerProcessInterceptorCommand;
import com.arm.mgd.core.target.marshaller.AbstractFunctionCallMarshaller;
import com.arm.mgd.core.target.marshaller.TraceParseException;
import com.arm.mgd.core.target.marshaller.binary_v2.gen.IUnmarshallerValueFactory;
import com.arm.mgd.core.target.marshaller.bytedata.AbstractByteSupplier;
import com.arm.mgd.core.target.marshaller.bytedata.DynamicByteDataModel;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.target.marshaller.bytedata.IByteStore;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallArgumentDescriptor;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallDescriptor;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallList;
import com.arm.mgd.core.target.marshaller.utils.Timestamp;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.core.util.NumberUtils;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class UnmarshallerValueFactory
implements IUnmarshallerValueFactory {
    private final @NonNull DynamicByteDataModel dynamicByteDataModel;
    private final @NonNull IByteStore byteStore;

    public UnmarshallerValueFactory(@NonNull DynamicByteDataModel dynamicByteDataModel, @NonNull IByteStore byteStore) {
        this.dynamicByteDataModel = dynamicByteDataModel;
        this.byteStore = byteStore;
    }

    private static @NonNull IInterceptorCommand convertCommandEnumAndParameter( @NonNull MgdProtosV2.CommandEnumProto commandEnumProto, @Nullable Integer commandParameter) throws TraceParseException {
        switch (commandEnumProto) {
            case CMD_CAPTURE_FRAME: {
                return PerProcessInterceptorCommand.FRAME_CAPTURE;
            }
            case CMD_END_FRAME_REPLAY: {
                return PerProcessInterceptorCommand.END_FRAME_REPLAY;
            }
            case CMD_ENTER_FRAME_REPLAY: {
                if ((Integer)NullUtils.neverNull((Object)commandParameter) != 0) {
                    return PerProcessInterceptorCommand.FRAME_REPLAY_CAPTURE;
                }
                return PerProcessInterceptorCommand.FRAME_REPLAY;
            }
            case CMD_PAUSE_ON_FRAME_END: {
                return GlobalInterceptorCommand.PAUSE_ALL_ON_FRAME_END;
            }
            case CMD_PAUSE_ON_NEXT_CALL: {
                return GlobalInterceptorCommand.PAUSE_ALL_NOW;
            }
            case CMD_RESUME: {
                return PerProcessInterceptorCommand.RESUME_APPLICATION;
            }
            case CMD_SET_CAPTURE_MODE: {
                MgdProtosV2.CommandEnumCaptureModeProto captureModeProto = MgdProtosV2.CommandEnumCaptureModeProto.valueOf((Integer)NullUtils.neverNull((Object)commandParameter));
                switch (captureModeProto) {
                    case SET_CAPTURE_MODE_ALL_ATTACHMENTS: {
                        return ModifyStateInterceptorCommand.ALLATTACHMENTSMODE_ENABLED;
                    }
                    case SET_CAPTURE_MODE_FRAGMENT_COUNT: {
                        return ModifyStateInterceptorCommand.FRAGMENTCOUNT_ENABLED;
                    }
                    case SET_CAPTURE_MODE_NONE: {
                        return ModifyStateInterceptorCommand.ALL_DISABLED;
                    }
                    case SET_CAPTURE_MODE_OVERDRAW: {
                        return ModifyStateInterceptorCommand.OVERDRAW_ENABLED;
                    }
                    case SET_CAPTURE_MODE_SHADERMAP: {
                        return ModifyStateInterceptorCommand.SHADERMAP_ENABLED;
                    }
                }
                throw new TraceParseException("Unexpected CommandEnumCaptureModeProto " + (Object)((Object)captureModeProto));
            }
            case CMD_SET_FILMSTRIP_ENABLED: {
                if ((Integer)NullUtils.neverNull((Object)commandParameter) != 0) {
                    return PerProcessInterceptorCommand.ENABLE_FILMSTRIP;
                }
                return PerProcessInterceptorCommand.DISABLE_FILMSTRIP;
            }
            case CMD_SET_OUTPUT_BUFFER_SENDING_ENABLED: {
                if ((Integer)NullUtils.neverNull((Object)commandParameter) != 0) {
                    return PerProcessInterceptorCommand.ENABLE_SEND_OUTPUT_BUFFERS;
                }
                return PerProcessInterceptorCommand.DISABLE_SEND_OUTPUT_BUFFERS;
            }
            case CMD_STEP_TO_NEXT_FRAME_END: {
                return PerProcessInterceptorCommand.FRAME_STEP;
            }
            case CMD_DEFERRED_COMMAND: {
                if ((Integer)NullUtils.neverNull((Object)commandParameter) != 0) {
                    return PerProcessInterceptorCommand.ADD_DEFERRED_COMMAND;
                }
                return PerProcessInterceptorCommand.REMOVE_DEFERRED_COMMAND;
            }
            case CMD_DISCONNECT: {
                return PerProcessInterceptorCommand.DISCONNECT;
            }
            case CMD_HOST_ATTACH_STATE_CHANGED: {
                if ((Integer)NullUtils.neverNull((Object)commandParameter) == 0) {
                    return PerProcessInterceptorCommand.HOST_ATTACHED;
                }
                return PerProcessInterceptorCommand.HOST_DETACHED;
            }
            case CMD_AUTHORISE_FEATURE: {
                return DaemonCommand.AUTHORISE_FEATURE;
            }
            case CMD_SET_HEADLESS_MODE_ENABLED: {
                return PerProcessInterceptorCommand.ENABLE_HEADLESS_MODE;
            }
            case CMD_KILL_DAEMON: {
                return GlobalInterceptorCommand.KILL_DAEMON;
            }
        }
        throw new TraceParseException("Unexpected CommandEnumProto " + (Object)((Object)commandEnumProto));
    }

    private static @NonNull TargetEvent.TargetEventType convertFrameCaptureStateEventAttachmentNewStateEnumProto(FrameCaptureStateTargetEventAttachment.FrameCaptureStateEvent newState) throws TraceParseException {
        switch (newState) {
            case FRAME_CAPTURE_FINISHED: {
                return TargetEvent.TargetEventType.FRAME_CAPTURE_FINISHED;
            }
            case FRAME_CAPTURE_NEW_FRAME_CAPTURED: {
                return TargetEvent.TargetEventType.FRAME_CAPTURE_STARTED;
            }
            case FRAME_CAPTURE_PENDING_NEXT_FRAME: {
                return TargetEvent.TargetEventType.FRAME_CAPTURE_WAITING;
            }
            case FRAME_CAPTURE_STARTED: {
                return TargetEvent.TargetEventType.FRAME_CAPTURE_STARTED;
            }
        }
        throw new TraceParseException("Unexpected frame capture state enum " + (Object)((Object)newState));
    }

    private static @NonNull AbstractConstantOrAliasSpecExtended getFramebufferAttachmentOrDefault(int attachment) {
        return KapiSpec.GLES.constantGroups.FRAMEBUFFERATTACHMENT.getConstantSpecByValue((Long)NullUtils.neverNull((Object)attachment));
    }

    private static <T extends TargetEventAttachment> @NonNull T getRequiredTargetEventAttachmentByClass(@NonNull Class<T> clazz, @NonNull List<@NonNull TargetEventAttachment> attachmentContainer) throws TraceParseException {
        @Nullable T attachment = UnmarshallerValueFactory.getTargetEventAttachmentByClass(clazz, attachmentContainer);
        if (attachment == null) {
            throw new TraceParseException("Missing attachment " + clazz.getSimpleName());
        }
        if (attachmentContainer.size() != 1) {
            throw new TraceParseException("Unexpected additional attachments for target event " + clazz.getSimpleName());
        }
        return attachment;
    }

    private static <T extends TargetEventAttachment> @Nullable T getTargetEventAttachmentByClass(@NonNull Class<T> clazz, @NonNull List<@NonNull TargetEventAttachment> attachmentContainer) {
        for (TargetEventAttachment attachment : attachmentContainer) {
            if (!clazz.isAssignableFrom(attachment.getClass())) continue;
            return (T)attachment;
        }
        return null;
    }

    @Override
    public @NonNull AbstractConstantOrAliasSpecExtended convertProgramResourcePropertyProtoMapKey(int value) throws TraceParseException {
        return KapiSpec.GLES.constantGroups.PROGRAMRESOURCEPROPERTIES.getConstantSpecByValue((Long)NullUtils.neverNull((Object)value));
    }

    @Override
    public @NonNull Integer convertProgramResourcePropertyProtoMapValue(int value) throws TraceParseException {
        return (Integer)NullUtils.neverNull((Object)value);
    }

    @Override
    public @NonNull ArgumentContainerAttachment createArgumentContainerArrayElementProto(int requiredParentMessageProtoProcessId, @Nullable Pointer ptrValue, @NonNull ArgumentContainerAttachment container) throws TraceParseException {
        container.setOriginalPointerValue(ptrValue);
        return container;
    }

    @Override
    public @NonNull ArgumentContainerArrayAttachment createArgumentContainerArrayProto(int requiredParentMessageProtoProcessId, @NonNull List<@NonNull ArgumentContainerAttachment> elements) throws TraceParseException {
        return new ArgumentContainerArrayAttachment(elements);
    }

    @Override
    public @NonNull ArgumentContainerAttachment createArgumentContainerProto(int requiredParentMessageProtoProcessId, @NonNull List<@NonNull FunctionCallArgumentDescriptor> members) throws TraceParseException {
        return new ArgumentContainerAttachment(members);
    }

    @Override
    public @NonNull PollGLESBufferContentsAttachment createBufferDataAttachmentProto(int requiredParentMessageProtoProcessId, long bufferId, int usage, byte[] data, @Nullable Long dynamicByteDataId) throws TraceParseException {
        AbstractConstantOrAliasSpecExtended usageConst = KapiSpec.GLES.getConstantSpecByValue((Long)NullUtils.neverNull((Object)usage));
        return new PollGLESBufferContentsAttachment(bufferId, this.createByteDataProvider(requiredParentMessageProtoProcessId, data, dynamicByteDataId), (AbstractConstantOrAliasSpecExtended)NullUtils.neverNull((Object)usageConst));
    }

    @Override
    public @NonNull CommandObject createCommandProto(int requiredParentMessageProtoProcessId,  @NonNull MgdProtosV2.CommandEnumProto commandId, @Nullable Integer commandParameter, @Nullable CommandAttachment commandAttachment) throws TraceParseException {
        IInterceptorCommand commandObject = UnmarshallerValueFactory.convertCommandEnumAndParameter(commandId, commandParameter);
        if (commandObject instanceof IPerProcessInterceptorCommand) {
            return new CommandObject(requiredParentMessageProtoProcessId, (IPerProcessInterceptorCommand)commandObject);
        }
        return new CommandObject((IGlobalInterceptorCommand)commandObject);
    }

    @Override
    public @NonNull DeferredCommandAttachment createDeferredCommandAttachmentProto(int requiredParentMessageProtoProcessId, @NonNull CommandObject command, int commandFrameNumber) throws TraceParseException {
        return new DeferredCommandAttachment(command, commandFrameNumber);
    }

    @Override
    public @NonNull TargetEventDescriptor createEventProto(int processId,  @NonNull MgdProtosV2.EventTypeProto eventType, @Nullable Boolean valueBool, @Nullable Integer valueInt, @Nullable Float valueFloat, @Nullable String valueString, @NonNull List<@NonNull TargetEventAttachment> attachmentContainer) throws TraceParseException {
        switch (eventType) {
            case EVENT_CODE_CAPTURE_STATE_UPDATE: {
                FrameCaptureStateTargetEventAttachment attachment = UnmarshallerValueFactory.getRequiredTargetEventAttachmentByClass(FrameCaptureStateTargetEventAttachment.class, attachmentContainer);
                TargetEvent.TargetEventType eventTypeEnum = UnmarshallerValueFactory.convertFrameCaptureStateEventAttachmentNewStateEnumProto(attachment.getNewState());
                return new TargetEventDescriptor(NullUtils.intValueOf((int)processId), eventTypeEnum, attachmentContainer);
            }
            case EVENT_CODE_EXECUTION_STATE_UPDATE: {
                ExecutionStateTargetEventAttachment attachment = UnmarshallerValueFactory.getRequiredTargetEventAttachmentByClass(ExecutionStateTargetEventAttachment.class, attachmentContainer);
                assert (attachment != null);
                return new TargetEventDescriptor(NullUtils.intValueOf((int)processId), TargetEvent.TargetEventType.INTERCEPTOR_EXECUTION_STATE_UPDATE, attachmentContainer);
            }
            case EVENT_CODE_FILMSTRIP_MODE_CHANGED: {
                if (valueBool == null) {
                    throw new TraceParseException("Expected value_bool to be set for event EVENT_CODE_FILMSTRIP_MODE_CHANGED");
                }
                TargetEvent.TargetEventType eventTypeEnum = valueBool != false ? TargetEvent.TargetEventType.FILMSTRIP_MODE_ENABLED : TargetEvent.TargetEventType.FILMSTRIP_MODE_DISABLED;
                return new TargetEventDescriptor(NullUtils.intValueOf((int)processId), eventTypeEnum, attachmentContainer);
            }
            case EVENT_CODE_PROCESS_FINISHED: {
                ProcessEndedTargetEventAttachment attachment = UnmarshallerValueFactory.getRequiredTargetEventAttachmentByClass(ProcessEndedTargetEventAttachment.class, attachmentContainer);
                assert (attachment != null);
                return new TargetEventDescriptor(NullUtils.intValueOf((int)processId), TargetEvent.TargetEventType.PROCESS_FINISHED, attachmentContainer);
            }
            case EVENT_CODE_PROCESS_STARTED: {
                ProcessStartedTargetEventAttachment attachment = UnmarshallerValueFactory.getRequiredTargetEventAttachmentByClass(ProcessStartedTargetEventAttachment.class, attachmentContainer);
                assert (attachment != null);
                return new TargetEventDescriptor(NullUtils.intValueOf((int)processId), TargetEvent.TargetEventType.PROCESS_STARTED, attachmentContainer);
            }
            case EVENT_CODE_SEND_INPUT_BUFFERS_CHANGED: {
                return new TargetEventDescriptor(NullUtils.intValueOf((int)processId), TargetEvent.TargetEventType.SEND_INPUT_BUFFERS_CHANGED_DEPRECATED, attachmentContainer);
            }
            case EVENT_CODE_SEND_OUTPUT_BUFFERS_CHANGED: {
                if (valueBool == null) {
                    throw new TraceParseException("Expected value_bool to be set for event EVENT_CODE_SEND_OUTPUT_BUFFERS_CHANGED");
                }
                TargetEvent.TargetEventType eventTypeEnum = valueBool != false ? TargetEvent.TargetEventType.SEND_OUTPUT_BUFFERS_ENABLED : TargetEvent.TargetEventType.SEND_OUTPUT_BUFFERS_DISABLED;
                return new TargetEventDescriptor(NullUtils.intValueOf((int)processId), eventTypeEnum, attachmentContainer);
            }
            case EVENT_CODE_MIDSTREAM_DATA_STREAM: {
                return new TargetEventDescriptor(NullUtils.intValueOf((int)processId), TargetEvent.TargetEventType.MIDSTREAM_DATA, attachmentContainer);
            }
            case EVENT_CODE_ASYNCHRONOUS_FUNCTION_CALL_DATA: {
                return new TargetEventDescriptor(NullUtils.intValueOf((int)processId), TargetEvent.TargetEventType.ASYNCHRONOUS_FUNCTION_CALL_DATA, attachmentContainer);
            }
            case EVENT_CODE_AUTHORISATION_REQUEST: {
                return new TargetEventDescriptor(NullUtils.intValueOf((int)processId), TargetEvent.TargetEventType.AUTHORISATION_REQUEST, attachmentContainer);
            }
            case EVENT_CODE_CONNECTION_REQUEST: {
                return new TargetEventDescriptor(NullUtils.intValueOf((int)processId), TargetEvent.TargetEventType.CONNECTION_REQUEST, attachmentContainer);
            }
            case EVENT_CODE_DEVICE_INFO: {
                return new TargetEventDescriptor(NullUtils.intValueOf((int)processId), TargetEvent.TargetEventType.DEVICE_INFO, attachmentContainer);
            }
            case EVENT_CODE_VERSION_ERROR: {
                return new TargetEventDescriptor(NullUtils.intValueOf((int)processId), TargetEvent.TargetEventType.DAEMON_INTERCEPTOR_VERSION_ERROR, attachmentContainer);
            }
            case EVENT_CODE_INTERCEPTOR_CONFIGURATION: {
                return new TargetEventDescriptor(NullUtils.intValueOf((int)processId), TargetEvent.TargetEventType.INTERCEPTOR_CONFIGURATION, attachmentContainer);
            }
            case EVENT_CODE_AUTHORISATION_FEATURE_USED: {
                AuthorisationFeatureEventAttachment attachment = UnmarshallerValueFactory.getRequiredTargetEventAttachmentByClass(AuthorisationFeatureEventAttachment.class, attachmentContainer);
                assert (attachment != null);
                return new TargetEventDescriptor(NullUtils.intValueOf((int)processId), TargetEvent.TargetEventType.AUTHORISATION_FEATURE_USED, attachmentContainer);
            }
        }
        throw new TraceParseException("Unexpected EventTypeProto " + (Object)((Object)eventType));
    }

    @Override
    public @NonNull InterceptorExecutionState createExecutionStateEventAttachmentNewStateEnumProto( @NonNull MgdProtosV2.ExecutionStateEventAttachmentNewStateEnumProto executionStateEventAttachmentNewStateEnumProto) throws TraceParseException {
        switch (executionStateEventAttachmentNewStateEnumProto) {
            case EXEC_STATE_PAUSED_ON_CALL: {
                return InterceptorExecutionState.PAUSED;
            }
            case EXEC_STATE_PAUSED_ON_FRAME_END: {
                return InterceptorExecutionState.PAUSED_ON_FRAME;
            }
            case EXEC_STATE_PAUSE_ON_FRAME_END_PENDING: {
                return InterceptorExecutionState.PAUSE_ON_FRAME_PENDING;
            }
            case EXEC_STATE_PAUSE_ON_NEXT_CALL_PENDING: {
                return InterceptorExecutionState.PAUSE_PENDING;
            }
            case EXEC_STATE_REPLAYING: {
                return InterceptorExecutionState.REPLAYING;
            }
            case EXEC_STATE_RUNNING: {
                return InterceptorExecutionState.RUNNING;
            }
            case EXEC_STATE_STEP_TO_NEXT_FRAME_END: {
                return InterceptorExecutionState.STEPPING;
            }
            case EXEC_STATE_DETACHED: {
                return InterceptorExecutionState.DETACHED;
            }
        }
        throw new TraceParseException("Unexpected enum in ExecutionStateEventAttachmentNewStateEnumProto " + (Object)((Object)executionStateEventAttachmentNewStateEnumProto));
    }

    @Override
    public @NonNull ExecutionStateTargetEventAttachment createExecutionStateEventAttachmentProto(@NonNull InterceptorExecutionState newState) throws TraceParseException {
        return new ExecutionStateTargetEventAttachment(newState);
    }

    @Override
    public @NonNull ForcePrecisionModeOverrideAttachment createForcePrecisionModeOverrideProto(long programId,  @NonNull PrecisionModeModifier.PrecisionModes precisionMode) throws TraceParseException {
        return new ForcePrecisionModeOverrideAttachment(programId, precisionMode);
    }

    @Override
    public @NonNull FramebufferDiffAttachment createFramebufferDiffProto(int requiredParentMessageProtoProcessId, int attachment, byte[] data, @Nullable Long dynamicByteDataId, @Nullable Integer multiviewViewId) throws TraceParseException {
        return new FramebufferDiffAttachment(UnmarshallerValueFactory.getFramebufferAttachmentOrDefault(attachment), this.createByteDataProvider(requiredParentMessageProtoProcessId, data, dynamicByteDataId), multiviewViewId);
    }

    @Override
    public @NonNull FramebufferAttachment createFramebufferProto(int requiredParentMessageProtoProcessId, int attachment, int format, int type, int width, int height, byte[] data, @Nullable Integer multiviewViewId, @Nullable Long dynamicByteDataId) throws TraceParseException {
        AbstractConstantOrAliasSpecExtended formatConst = KapiSpec.GLES.constantGroups.PIXELFORMAT.getConstantSpecByValue((Long)NullUtils.neverNull((Object)format));
        AbstractConstantOrAliasSpecExtended typeConst = KapiSpec.GLES.constantGroups.TEXTUREDATATYPE.getConstantSpecByValue((Long)NullUtils.neverNull((Object)type));
        Dimension size = new Dimension(width, height);
        return new FramebufferAttachment(UnmarshallerValueFactory.getFramebufferAttachmentOrDefault(attachment), formatConst, typeConst, size, this.createByteDataProvider(requiredParentMessageProtoProcessId, data, dynamicByteDataId), multiviewViewId);
    }

    @Override
    public @NonNull FrameCaptureStateTargetEventAttachment createFrameCaptureStateEventAttachmentProto( @NonNull MgdProtosV2.FrameCaptureStateEventAttachmentNewStateEnumProto newState, @Nullable Integer frameNumber) throws TraceParseException {
        FrameCaptureStateTargetEventAttachment.FrameCaptureStateEvent event = null;
        switch (newState) {
            case FRAME_CAPTURE_FINISHED: {
                event = FrameCaptureStateTargetEventAttachment.FrameCaptureStateEvent.FRAME_CAPTURE_FINISHED;
                break;
            }
            case FRAME_CAPTURE_NEW_FRAME_CAPTURED: {
                event = FrameCaptureStateTargetEventAttachment.FrameCaptureStateEvent.FRAME_CAPTURE_NEW_FRAME_CAPTURED;
                break;
            }
            case FRAME_CAPTURE_PENDING_NEXT_FRAME: {
                event = FrameCaptureStateTargetEventAttachment.FrameCaptureStateEvent.FRAME_CAPTURE_PENDING_NEXT_FRAME;
                break;
            }
            case FRAME_CAPTURE_STARTED: {
                event = FrameCaptureStateTargetEventAttachment.FrameCaptureStateEvent.FRAME_CAPTURE_STARTED;
                break;
            }
            default: {
                assert (false) : "Unknown frame capture state event: " + (Object)((Object)newState);
                break;
            }
        }
        assert (event != null);
        return new FrameCaptureStateTargetEventAttachment(event, frameNumber);
    }

    @Override
    public @NonNull FrameFeaturesFlagsEnum createFrameFeaturesProto( @NonNull MgdProtosV2.FrameFeaturesProto frameFeaturesProto) throws TraceParseException {
        switch (frameFeaturesProto) {
            case FRAME_FEATURE_FRAGMENT_COUNT: {
                return FrameFeaturesFlagsEnum.FRAGMENT_COUNT_ENABLED;
            }
            case FRAME_FEATURE_FRAME_CAPTURE: {
                return FrameFeaturesFlagsEnum.FRAME_CAPTURE_ENABLED;
            }
            case FRAME_FEATURE_FRAME_REPLAY: {
                return FrameFeaturesFlagsEnum.FRAME_REPLAY_ENABLED;
            }
            case FRAME_FEATURE_OVERDRAW: {
                return FrameFeaturesFlagsEnum.OVERDRAW_ENABLED;
            }
            case FRAME_FEATURE_SHADER_MAP: {
                return FrameFeaturesFlagsEnum.SHADER_MAP_ENABLED;
            }
            case FRAME_FEATURE_CAPTURE_ALL_ATTACHMENTS: {
                return FrameFeaturesFlagsEnum.CAPTURE_ALL_ATTACHMENTS;
            }
        }
        throw new TraceParseException("Unexpected FrameFeaturesProto " + (Object)((Object)frameFeaturesProto));
    }

    @Override
    public @NonNull FunctionCallList createFunctionCallListProto(int processId, @NonNull List<@NonNull FunctionCallDescriptor> functionCalls) throws TraceParseException {
        return new FunctionCallList(processId, functionCalls);
    }

    @Override
    public @NonNull FunctionCallDescriptor createFunctionCallProto(int processId, long threadId, @NonNull IFunctionOrAliasSpecExtended functionSpec, int errorCode, @Nullable FunctionCallArgumentDescriptor returnValue, @NonNull List<@NonNull FunctionCallArgumentDescriptor> arg, @NonNull List<@NonNull AbstractFreeAttachment> freeAttachmentContainer, @NonNull Timestamp timestampStart, @NonNull Timestamp timestampStop, boolean frameEnd, @NonNull List< @NonNull MgdProtosV2.FunctionCallFlagsEnumProto> flags, @Nullable String notes, @NonNull Set<@NonNull FrameFeaturesFlagsEnum> featuresEnabled, @NonNull List<@NonNull AbstractOverrideAttachment> frameOverrides, @Nullable ArgumentContainerAttachment arguments, @Nullable Integer asynchronousFunctionCallUid) throws TraceParseException {
        assert (arguments == null || arg.size() == 0) : "This function calls contains arguments in two forms.";
        List<FunctionCallArgumentDescriptor> argumentSource = arguments != null ? arguments.getMembers() : arg;
        assert (functionSpec.isUnrecognisedFunction() || functionSpec.getArg().size() == argumentSource.size());
        List<@NonNull T> listOfArgValues = IntStream.range(0, argumentSource.size()).mapToObj(i -> ((FunctionCallArgumentDescriptor)argumentSource.get(i)).getObjectValue(functionSpec, i)).collect(Collectors.toList());
        List<@NonNull T> rewrittenArgValues = IntStream.range(0, argumentSource.size()).mapToObj(i -> AbstractFunctionCallMarshaller.rewriteArgumentAttachment(functionSpec, i, listOfArgValues)).collect(Collectors.toList());
        Serializable returnValueValue = returnValue != null ? returnValue.getReturnObjectValue(functionSpec) : null;
        return new FunctionCallDescriptor(processId, threadId, timestampStart, timestampStop, functionSpec, errorCode, returnValueValue, (List)NullUtils.neverNull(rewrittenArgValues), frameEnd, flags, notes, freeAttachmentContainer, featuresEnabled, frameOverrides, asynchronousFunctionCallUid);
    }

    @Override
    public @NonNull IFunctionOrAliasSpecExtended createFunctionCallTypeEnumProto( @NonNull MgdProtosCommon.FunctionCallTypeEnumProto functionCallTypeEnumProto) throws TraceParseException {
        IFunctionOrAliasSpecExtended result = KapiSpec.GLES.functions.lookupFunctionCallSpecByFunctionCallProto(functionCallTypeEnumProto);
        if (result != null) {
            return result;
        }
        result = KapiSpec.EGL.functions.lookupFunctionCallSpecByFunctionCallProto(functionCallTypeEnumProto);
        if (result != null) {
            return result;
        }
        result = KapiSpec.CL.functions.lookupFunctionCallSpecByFunctionCallProto(functionCallTypeEnumProto);
        if (result != null) {
            return result;
        }
        result = KapiSpec.VULKAN.functions.lookupFunctionCallSpecByFunctionCallProto(functionCallTypeEnumProto);
        if (result != null) {
            return result;
        }
        throw new TraceParseException("Unexpected FunctionCallTypeEnumProto " + (Object)((Object)functionCallTypeEnumProto));
    }

    @Override
    public @NonNull InterceptorTarget createInterceptorTargetProto( @NonNull MgdProtosV2.InterceptorTargetProto interceptorTargetProto) throws TraceParseException {
        switch (interceptorTargetProto) {
            case INTERCEPTOR_TARGET_ARM_ANDROID_32: {
                return InterceptorTarget.INTERCEPTOR_TARGET_ARM_ANDROID_32;
            }
            case INTERCEPTOR_TARGET_ARM_ANDROID_64: {
                return InterceptorTarget.INTERCEPTOR_TARGET_ARM_ANDROID_64;
            }
            case INTERCEPTOR_TARGET_ARM_LINUX_64: {
                return InterceptorTarget.INTERCEPTOR_TARGET_ARM_LINUX_64;
            }
            case INTERCEPTOR_TARGET_ARM_LINUX_HARD_32: {
                return InterceptorTarget.INTERCEPTOR_TARGET_ARM_LINUX_HARD_32;
            }
            case INTERCEPTOR_TARGET_ARM_LINUX_SOFT_32: {
                return InterceptorTarget.INTERCEPTOR_TARGET_ARM_LINUX_SOFT_32;
            }
            case INTERCEPTOR_TARGET_EMULATOR: {
                return InterceptorTarget.INTERCEPTOR_TARGET_EMULATOR;
            }
            case INTERCEPTOR_TARGET_INTEL_LINUX_32: {
                return InterceptorTarget.INTERCEPTOR_TARGET_INTEL_LINUX_32;
            }
            case INTERCEPTOR_TARGET_INTEL_LINUX_64: {
                return InterceptorTarget.INTERCEPTOR_TARGET_INTEL_LINUX_64;
            }
            case INTERCEPTOR_TARGET_INTEL_ANDROID_32: {
                return InterceptorTarget.INTERCEPTOR_TARGET_INTEL_ANDROID_32;
            }
            case INTERCEPTOR_TARGET_INTEL_ANDROID_64: {
                return InterceptorTarget.INTERCEPTOR_TARGET_INTEL_ANDROID_64;
            }
            case INTERCEPTOR_TARGET_UNKNOWN: {
                return InterceptorTarget.INTERCEPTOR_TARGET_UNKNOWN;
            }
        }
        throw new TraceParseException("Unexpected interceptor target enum " + (Object)((Object)interceptorTargetProto));
    }

    @Override
    public @NonNull ClKernelAttachment createKernelNameProto(long kernelId, @NonNull String kernelName) throws TraceParseException {
        return new ClKernelAttachment(kernelId, kernelName);
    }

    @Override
    public @NonNull MemoryReportDataAttachment createMemoryReportDataProto(int id, @NonNull String data) throws TraceParseException {
        return new MemoryReportDataAttachment(id, data);
    }

    @Override
    public @NonNull MidstreamAssetItem createMidstreamAssetDataProto(int requiredParentMessageProtoProcessId, @NonNull String assetClass, long id, long instanceCounter, @NonNull List<@NonNull MidstreamAssetItemProperty> properties, @NonNull List<@NonNull MidstreamAssetItem> children, @NonNull List<@NonNull AbstractFreeAttachment> freeAttachments) throws TraceParseException {
        return new MidstreamAssetItem(assetClass, id, instanceCounter, properties, children, freeAttachments);
    }

    @Override
    public @NonNull MidstreamAssetItemProperty createMidstreamAssetPropertyDataProto(int requiredParentMessageProtoProcessId, @NonNull String name, @Nullable AbstractMidstreamAssetItemPropertyValue value) throws TraceParseException {
        return new MidstreamAssetItemProperty(name, value);
    }

    @Override
    public @NonNull MidstreamAssetItemPropertyMapEntryValue createMidstreamAssetPropertyMapEntryValueProto(int requiredParentMessageProtoProcessId, @NonNull FunctionCallArgumentDescriptor key, @Nullable FunctionCallArgumentDescriptor value) throws TraceParseException {
        return new MidstreamAssetItemPropertyMapEntryValue(key, value);
    }

    @Override
    public @NonNull MidstreamAssetItemPropertyMapValue createMidstreamAssetPropertyMapValueProto(int requiredParentMessageProtoProcessId, @NonNull List<@NonNull MidstreamAssetItemPropertyMapEntryValue> entries) throws TraceParseException {
        return new MidstreamAssetItemPropertyMapValue(entries);
    }

    @Override
    public @NonNull MidstreamAssetItemPropertySingleValue createMidstreamAssetPropertySingleValueProto(int requiredParentMessageProtoProcessId, @NonNull FunctionCallArgumentDescriptor value) throws TraceParseException {
        return new MidstreamAssetItemPropertySingleValue(value);
    }

    @Override
    public MidstreamDataAttachment.Flags createMidstreamDataAttachmentDataFlagsProto( @NonNull MgdProtosV2.MidstreamDataAttachmentDataFlagsProto midstreamDataAttachmentDataFlagsProto) throws TraceParseException {
        switch (midstreamDataAttachmentDataFlagsProto) {
            case MST_FLAG_CONTEXT: {
                return MidstreamDataAttachment.Flags.CONTEXT;
            }
            case MST_FLAG_CONTEXT_AND_GROUP: {
                return MidstreamDataAttachment.Flags.CONTEXT_AND_GROUP;
            }
            case MST_FLAG_GLOBAL: {
                return MidstreamDataAttachment.Flags.GLOBAL;
            }
            case MST_FLAG_THREAD_AND_CONTEXT: {
                return MidstreamDataAttachment.Flags.THREAD_AND_CONTEXT;
            }
            case MST_FLAG_THREAD_AND_GROUP: {
                return MidstreamDataAttachment.Flags.THREAD_CONTEXT_AND_GROUP;
            }
            case MST_FLAG_INCOMPLETE: {
                return MidstreamDataAttachment.Flags.INCOMPLETE;
            }
        }
        throw new TraceParseException("Unexpected MidstreamDataAttachmentDataFlagsProto : " + (Object)((Object)midstreamDataAttachmentDataFlagsProto));
    }

    @Override
    public @NonNull MidstreamDataAttachment createMidstreamDataAttachmentProto(int requiredParentMessageProtoProcessId, @NonNull MidstreamDataAttachment.Flags flags, @NonNull List<@NonNull MidstreamStateItem> stateItems, @NonNull List<@NonNull MidstreamAssetItem> assetObjects, @Nullable Integer sequenceNumber) throws TraceParseException {
        return new MidstreamDataAttachment(flags, stateItems, assetObjects, sequenceNumber);
    }

    @Override
    public @NonNull MidstreamDataTargetEventAttachment createMidstreamDataEventAttachmentProto(int requiredParentMessageProtoProcessId, long threadId, @NonNull MidstreamDataAttachment attachment) throws TraceParseException {
        return new MidstreamDataTargetEventAttachment(threadId, attachment);
    }

    @Override
    public @NonNull MidstreamStateItem createMidstreamStateDataProto(int requiredParentMessageProtoProcessId, @NonNull String stateId, @Nullable Integer index, @Nullable FunctionCallArgumentDescriptor value) throws TraceParseException {
        return new MidstreamStateItem(stateId, index, value);
    }

    @Override
    public  @NonNull PrecisionModeModifier.PrecisionModes createPrecisionModeProto( @NonNull MgdProtosV2.PrecisionModeProto precisionModeProto) throws TraceParseException {
        switch (precisionModeProto) {
            case PREC_MODE_HIGHP: {
                return PrecisionModeModifier.PrecisionModes.HIGHP;
            }
            case PREC_MODE_LOWP: {
                return PrecisionModeModifier.PrecisionModes.LOWP;
            }
            case PREC_MODE_MEDIUMP: {
                return PrecisionModeModifier.PrecisionModes.MEDIUMP;
            }
        }
        throw new TraceParseException("Unexpected PrecisionModeProto : " + (Object)((Object)precisionModeProto));
    }

    @Override
    public @NonNull ProcessEndedTargetEventAttachment createProcessEndedEventAttachmentProto(@NonNull Timestamp timestamp, boolean daemonNotification) throws TraceParseException {
        return new ProcessEndedTargetEventAttachment(timestamp, daemonNotification);
    }

    @Override
    public @NonNull ProcessStartedTargetEventAttachment createProcessStartedEventAttachmentProto(@NonNull String processName, @NonNull Timestamp timestamp, @NonNull InterceptorTarget interceptorTarget, @Nullable Boolean processStartedBeforeTracing) throws TraceParseException {
        return new ProcessStartedTargetEventAttachment(ProcessStartedTargetEventAttachment.stripFilename(processName), timestamp, interceptorTarget, processStartedBeforeTracing);
    }

    @Override
    public @NonNull ProgramGeometryShaderProperties createProgramGeometryShaderPropertiesProto(int inputType, int outputType, int verticesOut, int shaderInvocations) throws TraceParseException {
        return new ProgramGeometryShaderProperties(KapiSpec.GLES.constantGroups.GEOMETRY_SHADER_PRIMITIVE_TYPES.getConstantSpecByValue(NumberUtils.intToBoxedUnsignedLong(inputType)), KapiSpec.GLES.constantGroups.GEOMETRY_SHADER_PRIMITIVE_TYPES.getConstantSpecByValue(NumberUtils.intToBoxedUnsignedLong(outputType)), verticesOut, shaderInvocations);
    }

    @Override
    public @NonNull ProgramOverrideAttachment createProgramOverrideProto(long programId, @NonNull String vertexShader, @NonNull String fragmentShader) throws TraceParseException {
        return new ProgramOverrideAttachment(programId, vertexShader, fragmentShader);
    }

    @Override
    public @NonNull Long createProgramResourceActiveVariableProto(long index) throws TraceParseException {
        return (Long)NullUtils.neverNull((Object)index);
    }

    @Override
    public @NonNull ProgramResourceDescriptor.ProgramResourceAdditionalLocation createProgramResourceAdditionalLocationProto(@NonNull String name, int location) throws TraceParseException {
        return new ProgramResourceDescriptor.ProgramResourceAdditionalLocation(name, location);
    }

    @Override
    public @NonNull ProgramResourceDescriptor createProgramResourceProto(int resourceType, long programId, long index, @NonNull String name, @NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Integer> properties, @NonNull List<@NonNull ProgramResourceDescriptor.ProgramResourceAdditionalLocation> additionalLocations, @NonNull Set<@NonNull Long> activeVariables) throws TraceParseException {
        AbstractConstantOrAliasSpecExtended resourceTypeConst = KapiSpec.GLES.constantGroups.PROGRAMRESOURCETYPES.getConstantSpecByValue((Long)NullUtils.neverNull((Object)resourceType));
        return new ProgramResourceDescriptor(resourceTypeConst, programId, index, name, properties, activeVariables, additionalLocations);
    }

    @Override
    public @NonNull ProgramTessellationShaderProperties createProgramTessellationShaderPropertiesProto(int controlOutputVertices, int genMode, boolean genPointMode, int genSpacing, int genVertexOrder) throws TraceParseException {
        return new ProgramTessellationShaderProperties(controlOutputVertices, KapiSpec.GLES.constantGroups.TESS_GEN_MODE.getConstantSpecByValue(NumberUtils.intToBoxedUnsignedLong(genMode)), genPointMode, KapiSpec.GLES.constantGroups.TESS_GEN_SPACING.getConstantSpecByValue(NumberUtils.intToBoxedUnsignedLong(genSpacing)), KapiSpec.GLES.constantGroups.FRONTFACEDIRECTION.getConstantSpecByValue(NumberUtils.intToBoxedUnsignedLong(genVertexOrder)));
    }

    @Override
    public @NonNull MappingAttachment createReplayMappingAttachmentProto(long mappingId) throws TraceParseException {
        return new MappingAttachment(mappingId);
    }

    @Override
    public @NonNull ScreenshotAttachment createScreenshotProto(int requiredParentMessageProtoProcessId, int format, int type, int width, int height, byte[] data, @Nullable Long dynamicByteDataId) throws TraceParseException {
        AbstractConstantOrAliasSpecExtended formatConst = KapiSpec.GLES.constantGroups.PIXELFORMAT.getConstantSpecByValue((Long)NullUtils.neverNull((Object)format));
        AbstractConstantOrAliasSpecExtended typeConst = KapiSpec.GLES.constantGroups.TEXTUREDATATYPE.getConstantSpecByValue((Long)NullUtils.neverNull((Object)type));
        Dimension size = new Dimension(width, height);
        return new ScreenshotAttachment(formatConst, typeConst, size, this.createByteDataProvider(requiredParentMessageProtoProcessId, data, dynamicByteDataId));
    }

    @Override
    public @NonNull ShaderAttributeAttachment createShaderParameterProto(int programId, int attribIndex, int size, int type, @NonNull String name) throws TraceParseException {
        AbstractConstantOrAliasSpecExtended typeConst = KapiSpec.GLES.constantGroups.GLGETACTIVEATTRIB_TYPE.getConstantSpecByValue((Long)NullUtils.neverNull((Object)type));
        return new ShaderAttributeAttachment(programId, attribIndex, size, typeConst, name);
    }

    @Override
    public @NonNull ShaderProgramAttachment createShaderProgramProto(long programId, float r, float g, float b, @NonNull List<@NonNull ProgramResourceDescriptor> resources, @Nullable ProgramGeometryShaderProperties geometryShaderProperties, ProgramTessellationShaderProperties tessellationShaderProperties) throws TraceParseException {
        return new ShaderProgramAttachment(programId, r, g, b, ProgramResourceDescriptorMap.createFromList(resources), geometryShaderProperties, tessellationShaderProperties);
    }

    @Override
    public @NonNull SoftwareCounterAttachment createSoftwareCounterProto(int counterType, long counterValue, @Nullable Long programId) throws TraceParseException {
        SoftwareCounterAttachment.CounterType counterTypeEnum = SoftwareCounterAttachment.CounterType.getCounterType(counterType);
        if (counterTypeEnum == null) {
            throw new TraceParseException("Unexpected counter type for software counter attachment " + counterType);
        }
        return new SoftwareCounterAttachment(counterTypeEnum, programId != null ? Long.valueOf(programId) : null, counterValue);
    }

    @Override
    public @NonNull TextureOverrideAttachment createTextureOverrideProto(int requiredParentMessageProtoProcessId, long textureId, byte[] data, @Nullable Long dynamicByteDataId) throws TraceParseException {
        return new TextureOverrideAttachment(textureId, this.createByteDataProvider(requiredParentMessageProtoProcessId, data, dynamicByteDataId));
    }

    @Override
    public @NonNull Timestamp createTimeValueProto(long timestamp) throws TraceParseException {
        return new Timestamp(timestamp);
    }

    @Override
    public @NonNull VertexBufferAttachment createVertexBufferProto(int requiredParentMessageProtoProcessId, long attribIndex, int arraySize, int arrayType, int minIndex, byte[] data, @Nullable Long dynamicByteDataId) throws TraceParseException {
        AbstractConstantOrAliasSpecExtended typeConst = KapiSpec.GLES.constantGroups.VERTEXATTRIBPOINTERTYPE.getConstantSpecByValue((Long)NullUtils.neverNull((Object)arrayType));
        return new VertexBufferAttachment((Long)NullUtils.neverNull((Object)attribIndex), typeConst, arraySize, this.createByteDataProvider(requiredParentMessageProtoProcessId, data, dynamicByteDataId), minIndex);
    }

    @Override
    public @NonNull AsynchronousFunctionData createAsynchronousFunctionDataProto(int requiredParentMessageProtoProcessId, int functionCallUid, @Nullable AsynchronousFunctionAttachment attachment) throws TraceParseException {
        return new AsynchronousFunctionData(functionCallUid, attachment);
    }

    @Override
    public @NonNull VulkanCommandIndex createVulkanCommandIndexProto(int commandBufferIndex, int commandIndex, @Nullable VulkanCommandIndex secondaryCommandIndex) throws TraceParseException {
        return new VulkanCommandIndex(commandBufferIndex, commandIndex, secondaryCommandIndex);
    }

    @Override
    public @NonNull VulkanFramebufferAttachment createVulkanFramebufferAttachmentProto(int requiredParentMessageProtoProcessId, int attachmentIndex, @NonNull VulkanImageDiffAttachment imageDiff) throws TraceParseException {
        return new VulkanFramebufferAttachment(attachmentIndex, imageDiff);
    }

    @Override
    public @NonNull VulkanSubmitData createVulkanSubmitDataProto(int requiredParentMessageProtoProcessId, int submitInfosIndex, @NonNull VulkanCommandIndex command, @Nullable VulkanSubmitAttachment attachment) throws TraceParseException {
        return new VulkanSubmitData(submitInfosIndex, command, attachment);
    }

    @Override
    public @NonNull VulkanDeviceMemoryContentsAttachment createVulkanDeviceMemoryContentsAttachmentProto(int requiredParentMessageProtoProcessId, long device, long memory, long offset, byte[] data, @Nullable Long dynamicByteDataId) throws TraceParseException {
        return new VulkanDeviceMemoryContentsAttachment(device, memory, offset, this.createByteDataProvider(requiredParentMessageProtoProcessId, data, dynamicByteDataId));
    }

    @Override
    public @NonNull VulkanImageMemoryRequirementsAttachment createVulkanImageMemoryRequirementsProto(long device, long image, long size, long alignment, long memoryTypeBits, @NonNull List<@NonNull VulkanImageSubresourceLayoutAttachment> subresourceLayouts) throws TraceParseException {
        return new VulkanImageMemoryRequirementsAttachment(device, image, size, alignment, memoryTypeBits, subresourceLayouts);
    }

    @Override
    public @NonNull VulkanImageSubresourceLayoutAttachment createVulkanImageSubresourceLayoutProto(long aspectMask, int mipLevel, int arrayLayer, long offset, long size, long rowPitch, long arrayPitch, long depthPitch) throws TraceParseException {
        return new VulkanImageSubresourceLayoutAttachment(aspectMask, mipLevel, arrayLayer, offset, size, rowPitch, arrayPitch, depthPitch);
    }

    @Override
    public @NonNull VulkanImageDiffAttachment.PriorImageInfo createVulkanImageDiffPriorImageInfoProto( @NonNull MgdProtosV2.VulkanImageDiffPriorImageInfoProto vulkanImageDiffPriorImageInfoProto) throws TraceParseException {
        switch (vulkanImageDiffPriorImageInfoProto) {
            case IMAGE_DIFF_HAS_NO_PRIOR_IMAGE: {
                return VulkanImageDiffAttachment.PriorImageInfo.HAS_NO_PRIOR_IMAGE;
            }
            case IMAGE_DIFF_HAS_PRIOR_IMAGE: {
                return VulkanImageDiffAttachment.PriorImageInfo.HAS_PRIOR_IMAGE;
            }
            case IMAGE_DIFF_IS_UNCHANGED_FROM_PRIOR_IMAGE: {
                return VulkanImageDiffAttachment.PriorImageInfo.IS_UNCHANGED_FROM_PRIOR_IMAGE;
            }
        }
        throw new TraceParseException("Unexpected VulkanImageDiffPriorImageInfoProto : " + (Object)((Object)vulkanImageDiffPriorImageInfoProto));
    }

    @Override
    public @NonNull VulkanImageDiffAttachment createVulkanImageDiffProto(int requiredParentMessageProtoProcessId, long imageId, int width, int height, int layers, int format, int bytesPerPixel, @NonNull VulkanImageDiffAttachment.PriorImageInfo priorImageInfo, @Nullable Long priorImageId, @Nullable Integer blockSize, byte[] data, @Nullable Long dynamicByteDataId) throws TraceParseException {
        return new VulkanImageDiffAttachment(imageId, width, height, layers, format, bytesPerPixel, priorImageInfo, priorImageId, blockSize, this.createByteDataProvider(requiredParentMessageProtoProcessId, data, dynamicByteDataId));
    }

    @Override
    public @NonNull FunctionCallArgumentDescriptor createArgumentProto(int requiredParentMessageProtoProcessId, @Nullable Integer intValue, @Nullable Long longValue, @Nullable Float floatValue, @Nullable Pointer ptrValue, byte[] data, @Nullable StringsArgAttachment strings, @Nullable LongsArgAttachment longs, @Nullable FloatsArgAttachment floats, @Nullable ArgumentContainerAttachment container, @Nullable ArgumentContainerArrayAttachment containers, @Nullable Long dynamicByteDataId, @Nullable Double doubleValue) throws TraceParseException {
        return FunctionCallArgumentDescriptor.create(intValue, longValue, floatValue, doubleValue, this.createByteDataProvider(requiredParentMessageProtoProcessId, data, dynamicByteDataId), strings, longs, floats, ptrValue, container, containers);
    }

    @Override
    public @NonNull FeatureAuthorisationRequestEventAttachment createFeatureAuthorisationRequestEventAttachmentProto(@NonNull Timestamp timestamp, long uniqueValue,  @NonNull MgdProtosV2.ProductFeatures feature) throws TraceParseException {
        return new FeatureAuthorisationRequestEventAttachment(timestamp, uniqueValue, feature);
    }

    @Override
    public @NonNull FeatureAuthorisationCommandAttachment createFeatureAuthorisationCommandAttachmentProto(@NonNull FeatureAuthorisationRequestEventAttachment featureRequest, boolean authorised, @Nullable String reason) throws TraceParseException {
        return new FeatureAuthorisationCommandAttachment(featureRequest, authorised, reason);
    }

    @Override
    public @NonNull DeviceInfoEventAttachment createDeviceInfoEventAttachmentProto(@NonNull String glVendor, @NonNull String glRenderer, @NonNull String glVersion, @Nullable String osVersion) {
        return new DeviceInfoEventAttachment(glVendor, glRenderer, glVersion, osVersion);
    }

    @Override
    public VersionInfoEventAttachment createVersionInfoEventAttachmentProto(@NonNull String daemonVersion, @NonNull String interceptorVersion) throws TraceParseException {
        return new VersionInfoEventAttachment(daemonVersion, interceptorVersion);
    }

    @Override
    public @NonNull ClConfig createClConfigProto(@NonNull List<@NonNull ClResource> resources) throws TraceParseException {
        return new ClConfig(resources, true);
    }

    @Override
    public @NonNull ClResource createClResourceProto( @NonNull MgdProtosV2.ClResourceEnumProto type, boolean selected) throws TraceParseException {
        return new ClResource(type, selected);
    }

    @Override
    public @NonNull GlesConfig createGlesConfigProto(@NonNull List<@NonNull GlesResource> resources) throws TraceParseException {
        return new GlesConfig(resources, true);
    }

    @Override
    public @NonNull GlesResource createGlesResourceProto( @NonNull MgdProtosV2.GlesResourceEnumProto type, boolean selected) throws TraceParseException {
        return new GlesResource(type, selected);
    }

    @Override
    public @NonNull VulkanConfig createVulkanConfigProto(@NonNull List<@NonNull VulkanResource> resources) throws TraceParseException {
        return new VulkanConfig(resources, true);
    }

    @Override
    public @NonNull VulkanResource createVulkanResourceProto( @NonNull MgdProtosV2.VulkanResourceEnumProto type, boolean selected) throws TraceParseException {
        return new VulkanResource(type, selected);
    }

    @Override
    public @NonNull InterceptorConfigCommandAttachment createInterceptorConfigCommandAttachmentProto(@NonNull InterceptorConfig config) throws TraceParseException {
        return new InterceptorConfigCommandAttachment(config);
    }

    @Override
    public @NonNull InterceptorConfigEventAttachment createInterceptorConfigEventAttachmentProto(@NonNull InterceptorConfig config) throws TraceParseException {
        return new InterceptorConfigEventAttachment(config);
    }

    @Override
    public @NonNull InterceptorConfig createInterceptorConfigProto(@Nullable ClConfig cl, @Nullable GlesConfig gles, @Nullable VulkanConfig vulkan) throws TraceParseException {
        return new InterceptorConfig((ClConfig)NullUtils.nonNullOrDefault((Object)cl, (Object)ClConfig.EVERYTHING_SELECTED), (GlesConfig)NullUtils.nonNullOrDefault((Object)gles, (Object)GlesConfig.EVERYTHING_SELECTED), (VulkanConfig)NullUtils.nonNullOrDefault((Object)vulkan, (Object)VulkanConfig.EVERYTHING_SELECTED));
    }

    private @Nullable IByteDataProvider createByteDataProvider(int processId, byte @Nullable [] data, @Nullable Long dynamicByteDataId) throws TraceParseException {
        if (data != null && dynamicByteDataId != null) {
            throw new TraceParseException("Message has both data and dynamic byte data.");
        }
        if (data != null) {
            @NonNull AbstractByteSupplier byteSupplier = this.byteStore.add(data);
            return IByteDataProvider.createByteSupplierProvider(byteSupplier);
        }
        if (dynamicByteDataId != null) {
            return this.dynamicByteDataModel.getProvider(processId, dynamicByteDataId);
        }
        return null;
    }

    @Override
    public @NonNull EGLConfigAttributeArrayAttachment createEglcOnfigAttributeArrayProto(int requiredParentMessageProtoProcessId, long configId, @NonNull List<@NonNull EGLAttributeAttachment> attributes) throws TraceParseException {
        return new EGLConfigAttributeArrayAttachment(configId, attributes);
    }

    @Override
    public @NonNull EGLAttributeAttachment createEglaTtributeProto(long key, long value) throws TraceParseException {
        return new EGLAttributeAttachment(key, value);
    }

    @Override
    public @NonNull EGLSurfaceAttributeArrayAttachment createEglsUrfaceAttributeArrayProto(int requiredParentMessageProtoProcessId, @NonNull List<@NonNull EGLAttributeAttachment> attributes) throws TraceParseException {
        return new EGLSurfaceAttributeArrayAttachment(attributes);
    }

    @Override
    public @NonNull AuthorisationFeatureEventAttachment createAuthorisationFeatureEventAttachmentProto( @NonNull MgdProtosV2.ProductFeatures feature) throws TraceParseException {
        return new AuthorisationFeatureEventAttachment(feature);
    }

    @Override
    public @NonNull DeviceConnectionRequestEventAttachment createDeviceConnectionRequestEventAttachmentProto( @NonNull MgdProtosV2.ProductFeatures feature) throws TraceParseException {
        return new DeviceConnectionRequestEventAttachment(feature);
    }
}

