/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.marshaller.binary_v2;

import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.pb.common.MgdProtosCommon;
import com.arm.mgd.core.pb.v2.MgdProtosV2;
import com.arm.mgd.core.target.data.ArgumentContainerAttachment;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FloatsArgAttachment;
import com.arm.mgd.core.target.data.FrameCaptureStateTargetEventAttachment;
import com.arm.mgd.core.target.data.FramebufferAttachment;
import com.arm.mgd.core.target.data.FramebufferDiffAttachment;
import com.arm.mgd.core.target.data.IArgumentAttachment;
import com.arm.mgd.core.target.data.InterceptorTarget;
import com.arm.mgd.core.target.data.LongPtrArgAttachment;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.PollGLESBufferContentsAttachment;
import com.arm.mgd.core.target.data.ProgramResourceDescriptor;
import com.arm.mgd.core.target.data.ScreenshotAttachment;
import com.arm.mgd.core.target.data.ShaderProgramAttachment;
import com.arm.mgd.core.target.data.StringsArgAttachment;
import com.arm.mgd.core.target.data.TextureOverrideAttachment;
import com.arm.mgd.core.target.data.VertexBufferAttachment;
import com.arm.mgd.core.target.data.VulkanDeviceMemoryContentsAttachment;
import com.arm.mgd.core.target.data.VulkanImageDiffAttachment;
import com.arm.mgd.core.target.marshaller.IMarshallerDynamicByteDataSink;
import com.arm.mgd.core.target.marshaller.TraceParseException;
import com.arm.mgd.core.target.marshaller.binary_v2.gen.IMarshallerPropertyGetter;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallArgumentDescriptor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class MarshallerPropertyGetter
extends IMarshallerPropertyGetter {
    private final IMarshallerDynamicByteDataSink dynamicByteDataSink;

    public MarshallerPropertyGetter(@NonNull IMarshallerDynamicByteDataSink dataSink) {
        this.dynamicByteDataSink = dataSink;
    }

    public static  @NonNull MgdProtosCommon.FunctionCallTypeEnumProto getFunctionCallEnum(@NonNull IFunctionOrAliasSpecExtended functionSpec) throws TraceParseException {
        MgdProtosCommon.FunctionCallTypeEnumProto result = KapiSpec.GLES.functions.lookupFunctionCallProtoByFunctionCallSpec(functionSpec);
        if (result != null) {
            return result;
        }
        result = KapiSpec.EGL.functions.lookupFunctionCallProtoByFunctionCallSpec(functionSpec);
        if (result != null) {
            return result;
        }
        result = KapiSpec.CL.functions.lookupFunctionCallProtoByFunctionCallSpec(functionSpec);
        if (result != null) {
            return result;
        }
        result = KapiSpec.VULKAN.functions.lookupFunctionCallProtoByFunctionCallSpec(functionSpec);
        if (result != null) {
            return result;
        }
        throw new TraceParseException("Cannot map function call spec to proto " + functionSpec.getName());
    }

    @Override
    public @NonNull Long convertArgumentContainerArrayElementProtoPtrValue(@NonNull Pointer ptrValue) {
        return NullUtils.longValueOf((long)ptrValue.address());
    }

    @Override
    public @NonNull List<@NonNull Float> convertArgumentProtoFloats(@Nullable FloatsArgAttachment floats) {
        return floats != null ? floats.asList() : NullUtils.EMPTY_LIST;
    }

    @Override
    public @NonNull List<@NonNull Long> convertArgumentProtoLongs(@Nullable LongsArgAttachment longs) {
        return longs != null ? longs.asList() : NullUtils.EMPTY_LIST;
    }

    @Override
    public @NonNull Long convertArgumentProtoPtrValue(@NonNull Pointer ptrValue) {
        return NullUtils.longValueOf((long)ptrValue.address());
    }

    @Override
    public @NonNull List<@NonNull String> convertArgumentProtoStrings(@Nullable StringsArgAttachment strings) {
        return strings != null ? strings.asList() : NullUtils.EMPTY_LIST;
    }

    @Override
    public  @NonNull MgdProtosV2.MidstreamDataAttachmentDataFlagsProto convertFlagsToMidstreamDataAttachmentDataFlagsProto( @NonNull MidstreamDataAttachment.Flags enumValue) {
        switch (enumValue) {
            case CONTEXT: {
                return MgdProtosV2.MidstreamDataAttachmentDataFlagsProto.MST_FLAG_CONTEXT;
            }
            case CONTEXT_AND_GROUP: {
                return MgdProtosV2.MidstreamDataAttachmentDataFlagsProto.MST_FLAG_CONTEXT_AND_GROUP;
            }
            case GLOBAL: {
                return MgdProtosV2.MidstreamDataAttachmentDataFlagsProto.MST_FLAG_GLOBAL;
            }
            case THREAD_AND_CONTEXT: {
                return MgdProtosV2.MidstreamDataAttachmentDataFlagsProto.MST_FLAG_THREAD_AND_CONTEXT;
            }
            case THREAD_CONTEXT_AND_GROUP: {
                return MgdProtosV2.MidstreamDataAttachmentDataFlagsProto.MST_FLAG_THREAD_AND_GROUP;
            }
            case INCOMPLETE: {
                throw new AssertionError((Object)enumValue);
            }
        }
        throw new AssertionError((Object)enumValue);
    }

    @Override
    public  @NonNull MgdProtosV2.InterceptorTargetProto convertInterceptorTargetToInterceptorTargetProto(@NonNull InterceptorTarget enumValue) {
        switch (enumValue) {
            case INTERCEPTOR_TARGET_ARM_ANDROID_32: {
                return MgdProtosV2.InterceptorTargetProto.INTERCEPTOR_TARGET_ARM_ANDROID_32;
            }
            case INTERCEPTOR_TARGET_ARM_ANDROID_64: {
                return MgdProtosV2.InterceptorTargetProto.INTERCEPTOR_TARGET_ARM_ANDROID_64;
            }
            case INTERCEPTOR_TARGET_ARM_LINUX_64: {
                return MgdProtosV2.InterceptorTargetProto.INTERCEPTOR_TARGET_ARM_LINUX_64;
            }
            case INTERCEPTOR_TARGET_ARM_LINUX_HARD_32: {
                return MgdProtosV2.InterceptorTargetProto.INTERCEPTOR_TARGET_ARM_LINUX_HARD_32;
            }
            case INTERCEPTOR_TARGET_ARM_LINUX_SOFT_32: {
                return MgdProtosV2.InterceptorTargetProto.INTERCEPTOR_TARGET_ARM_LINUX_SOFT_32;
            }
            case INTERCEPTOR_TARGET_EMULATOR: {
                return MgdProtosV2.InterceptorTargetProto.INTERCEPTOR_TARGET_EMULATOR;
            }
            case INTERCEPTOR_TARGET_INTEL_LINUX_32: {
                return MgdProtosV2.InterceptorTargetProto.INTERCEPTOR_TARGET_INTEL_LINUX_32;
            }
            case INTERCEPTOR_TARGET_INTEL_LINUX_64: {
                return MgdProtosV2.InterceptorTargetProto.INTERCEPTOR_TARGET_INTEL_LINUX_64;
            }
            case INTERCEPTOR_TARGET_INTEL_ANDROID_32: {
                return MgdProtosV2.InterceptorTargetProto.INTERCEPTOR_TARGET_INTEL_ANDROID_32;
            }
            case INTERCEPTOR_TARGET_INTEL_ANDROID_64: {
                return MgdProtosV2.InterceptorTargetProto.INTERCEPTOR_TARGET_INTEL_ANDROID_64;
            }
            case INTERCEPTOR_TARGET_UNKNOWN: {
                return MgdProtosV2.InterceptorTargetProto.INTERCEPTOR_TARGET_UNKNOWN;
            }
        }
        throw new AssertionError((Object)enumValue);
    }

    @Override
    public  @NonNull MgdProtosV2.PrecisionModeProto convertPrecisionModesToPrecisionModeProto( @NonNull PrecisionModeModifier.PrecisionModes enumValue) {
        switch (enumValue) {
            case HIGHP: {
                return MgdProtosV2.PrecisionModeProto.PREC_MODE_HIGHP;
            }
            case LOWP: {
                return MgdProtosV2.PrecisionModeProto.PREC_MODE_LOWP;
            }
            case MEDIUMP: {
                return MgdProtosV2.PrecisionModeProto.PREC_MODE_MEDIUMP;
            }
        }
        throw new AssertionError((Object)enumValue);
    }

    @Override
    public int convertProgramResourcePropertyProtoKey(@NonNull AbstractConstantOrAliasSpecExtended key) {
        return key.getResolvedValue().intValue();
    }

    @Override
    public @Nullable Pointer getArgumentContainerArrayElementProtoPtrValue(@NonNull ArgumentContainerAttachment argumentContainerArrayElementProto) {
        return argumentContainerArrayElementProto.getOriginalValue();
    }

    @Override
    public @Nullable FloatsArgAttachment getArgumentProtoFloats(@NonNull FunctionCallArgumentDescriptor argumentProto) {
        IArgumentAttachment attachment = argumentProto.getRawAttachmentValue();
        if (attachment instanceof FloatsArgAttachment) {
            return (FloatsArgAttachment)attachment;
        }
        return null;
    }

    @Override
    public @Nullable Float getArgumentProtoFloatValue(@NonNull FunctionCallArgumentDescriptor argumentProto) {
        Serializable object = argumentProto.getRawObjectValue();
        return object instanceof Float ? (Float)object : null;
    }

    @Override
    public @Nullable Double getArgumentProtoDoubleValue(@NonNull FunctionCallArgumentDescriptor argumentProto) {
        Serializable object = argumentProto.getRawObjectValue();
        return object instanceof Double ? (Double)object : null;
    }

    @Override
    public @Nullable Integer getArgumentProtoIntValue(@NonNull FunctionCallArgumentDescriptor argumentProto) {
        Serializable object = argumentProto.getRawObjectValue();
        return object instanceof Integer ? (Integer)object : null;
    }

    @Override
    public @Nullable LongsArgAttachment getArgumentProtoLongs(@NonNull FunctionCallArgumentDescriptor argumentProto) {
        IArgumentAttachment attachment = argumentProto.getRawAttachmentValue();
        if (attachment instanceof LongsArgAttachment) {
            return (LongsArgAttachment)attachment;
        }
        return null;
    }

    @Override
    public @Nullable Long getArgumentProtoLongValue(@NonNull FunctionCallArgumentDescriptor argumentProto) {
        Serializable object = argumentProto.getRawObjectValue();
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Bitfield) {
            Bitfield bitfield = (Bitfield)object;
            return bitfield.getAsLong();
        }
        IArgumentAttachment attachment = argumentProto.getRawAttachmentValue();
        if (attachment instanceof LongPtrArgAttachment) {
            return ((LongPtrArgAttachment)attachment).value;
        }
        return null;
    }

    @Override
    public @Nullable Pointer getArgumentProtoPtrValue(@NonNull FunctionCallArgumentDescriptor argumentProto) {
        Serializable object = argumentProto.getRawObjectValue();
        if (object instanceof Pointer) {
            return (Pointer)object;
        }
        IArgumentAttachment attachment = argumentProto.getRawAttachmentValue();
        if (attachment != null) {
            return attachment.getOriginalValue();
        }
        return null;
    }

    @Override
    public @Nullable StringsArgAttachment getArgumentProtoStrings(@NonNull FunctionCallArgumentDescriptor argumentProto) {
        IArgumentAttachment attachment = argumentProto.getRawAttachmentValue();
        if (attachment instanceof StringsArgAttachment) {
            return (StringsArgAttachment)attachment;
        }
        return null;
    }

    @Override
    public int getFramebufferDiffProtoAttachment(@NonNull FramebufferDiffAttachment framebufferDiffProto) {
        AbstractConstantOrAliasSpecExtended attachment = framebufferDiffProto.getAttachment();
        return attachment.getResolvedValue().intValue();
    }

    @Override
    public int getFramebufferProtoAttachment(@NonNull FramebufferAttachment framebufferProto) {
        AbstractConstantOrAliasSpecExtended attachment = framebufferProto.getAttachment();
        return attachment.getResolvedValue().intValue();
    }

    @Override
    public @NonNull List<@NonNull ProgramResourceDescriptor> getShaderProgramProtoResources(@NonNull ShaderProgramAttachment shaderProgramProto) {
        return shaderProgramProto.getProgramResources().getProgramResourcesList();
    }

    @Override
    public  @NonNull MgdProtosV2.VulkanImageDiffPriorImageInfoProto convertPriorImageInfoToVulkanImageDiffPriorImageInfoProto(@NonNull VulkanImageDiffAttachment.PriorImageInfo enumValue) {
        switch (enumValue) {
            case HAS_NO_PRIOR_IMAGE: {
                return MgdProtosV2.VulkanImageDiffPriorImageInfoProto.IMAGE_DIFF_HAS_NO_PRIOR_IMAGE;
            }
            case HAS_PRIOR_IMAGE: {
                return MgdProtosV2.VulkanImageDiffPriorImageInfoProto.IMAGE_DIFF_HAS_PRIOR_IMAGE;
            }
            case IS_UNCHANGED_FROM_PRIOR_IMAGE: {
                return MgdProtosV2.VulkanImageDiffPriorImageInfoProto.IMAGE_DIFF_IS_UNCHANGED_FROM_PRIOR_IMAGE;
            }
        }
        throw new AssertionError((Object)enumValue);
    }

    @Override
    public  @NonNull MgdProtosV2.FrameCaptureStateEventAttachmentNewStateEnumProto getFrameCaptureStateEventAttachmentProtoNewState(@NonNull FrameCaptureStateTargetEventAttachment frameCaptureStateEventAttachmentProto) {
        switch (frameCaptureStateEventAttachmentProto.getNewState()) {
            case FRAME_CAPTURE_FINISHED: {
                return MgdProtosV2.FrameCaptureStateEventAttachmentNewStateEnumProto.FRAME_CAPTURE_FINISHED;
            }
            case FRAME_CAPTURE_NEW_FRAME_CAPTURED: {
                return MgdProtosV2.FrameCaptureStateEventAttachmentNewStateEnumProto.FRAME_CAPTURE_NEW_FRAME_CAPTURED;
            }
            case FRAME_CAPTURE_PENDING_NEXT_FRAME: {
                return MgdProtosV2.FrameCaptureStateEventAttachmentNewStateEnumProto.FRAME_CAPTURE_PENDING_NEXT_FRAME;
            }
            case FRAME_CAPTURE_STARTED: {
                return MgdProtosV2.FrameCaptureStateEventAttachmentNewStateEnumProto.FRAME_CAPTURE_STARTED;
            }
        }
        throw new AssertionError((Object)frameCaptureStateEventAttachmentProto.getNewState());
    }

    @Override
    public byte[] getArgumentProtoData(@NonNull FunctionCallArgumentDescriptor argumentProto) {
        return null;
    }

    @Override
    public byte[] getBufferDataAttachmentProtoData(@NonNull PollGLESBufferContentsAttachment bufferDataAttachmentProto) {
        return null;
    }

    @Override
    public byte[] getFramebufferDiffProtoData(@NonNull FramebufferDiffAttachment framebufferDiffProto) {
        return null;
    }

    @Override
    public byte[] getFramebufferProtoData(@NonNull FramebufferAttachment framebufferProto) {
        return null;
    }

    @Override
    public byte[] getScreenshotProtoData(@NonNull ScreenshotAttachment screenshotProto) {
        return null;
    }

    @Override
    public byte[] getTextureOverrideProtoData(@NonNull TextureOverrideAttachment textureOverrideProto) {
        return null;
    }

    @Override
    public byte[] getVertexBufferProtoData(@NonNull VertexBufferAttachment vertexBufferProto) {
        return null;
    }

    @Override
    public byte[] getVulkanDeviceMemoryContentsAttachmentProtoData(@NonNull VulkanDeviceMemoryContentsAttachment vulkanDeviceMemoryContentsAttachmentProto) {
        return null;
    }

    @Override
    public byte[] getVulkanImageDiffProtoData(@NonNull VulkanImageDiffAttachment vulkanImageDiffProto) {
        return null;
    }

    @Override
    public @Nullable Long getArgumentProtoDynamicByteDataId(@NonNull FunctionCallArgumentDescriptor argumentProto) {
        return this.dynamicByteDataSink.addDynamicByteData(argumentProto.getData());
    }

    @Override
    public @Nullable Long getBufferDataAttachmentProtoDynamicByteDataId(@NonNull PollGLESBufferContentsAttachment bufferDataAttachmentProto) {
        return this.dynamicByteDataSink.addDynamicByteData(bufferDataAttachmentProto.getData());
    }

    @Override
    public @Nullable Long getFramebufferDiffProtoDynamicByteDataId(@NonNull FramebufferDiffAttachment framebufferDiffProto) {
        return this.dynamicByteDataSink.addDynamicByteData(framebufferDiffProto.getData());
    }

    @Override
    public @Nullable Long getFramebufferProtoDynamicByteDataId(@NonNull FramebufferAttachment framebufferProto) {
        return this.dynamicByteDataSink.addDynamicByteData(framebufferProto.getData());
    }

    @Override
    public @Nullable Long getScreenshotProtoDynamicByteDataId(@NonNull ScreenshotAttachment screenshotProto) {
        return this.dynamicByteDataSink.addDynamicByteData(screenshotProto.getData());
    }

    @Override
    public @Nullable Long getTextureOverrideProtoDynamicByteDataId(@NonNull TextureOverrideAttachment textureOverrideProto) {
        return this.dynamicByteDataSink.addDynamicByteData(textureOverrideProto.getData());
    }

    @Override
    public @Nullable Long getVertexBufferProtoDynamicByteDataId(@NonNull VertexBufferAttachment vertexBufferProto) {
        return this.dynamicByteDataSink.addDynamicByteData(vertexBufferProto.getData());
    }

    @Override
    public @Nullable Long getVulkanDeviceMemoryContentsAttachmentProtoDynamicByteDataId(@NonNull VulkanDeviceMemoryContentsAttachment vulkanDeviceMemoryContentsAttachmentProto) {
        return this.dynamicByteDataSink.addDynamicByteData(vulkanDeviceMemoryContentsAttachmentProto.getData());
    }

    @Override
    public @Nullable Long getVulkanImageDiffProtoDynamicByteDataId(@NonNull VulkanImageDiffAttachment vulkanImageDiffProto) {
        return this.dynamicByteDataSink.addDynamicByteData(vulkanImageDiffProto.getData());
    }
}

