/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.marshaller.binary_v2;

import com.arm.mgd.core.authorisation.Feature;
import com.arm.mgd.core.authorisation.FeatureAuthorisation;
import com.arm.mgd.core.midstream.MidstreamDataAttachment;
import com.arm.mgd.core.pb.v2.MgdProtosV2;
import com.arm.mgd.core.target.data.AbstractFreeAttachment;
import com.arm.mgd.core.target.data.DeviceInfoEventAttachment;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.ITargetDeviceInfo;
import com.arm.mgd.core.target.data.MidstreamDataTargetEventAttachment;
import com.arm.mgd.core.target.data.TargetEvent;
import com.arm.mgd.core.target.data.TargetEventDescriptor;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.target.marshaller.AbstractFunctionCallMarshaller;
import com.arm.mgd.core.target.marshaller.IMarshallerDynamicByteDataSink;
import com.arm.mgd.core.target.marshaller.binary_v2.FunctionCallMarshallerD001;
import com.arm.mgd.core.target.marshaller.binary_v2.MarshallerPropertyGetter;
import com.arm.mgd.core.target.marshaller.binary_v2.gen.Marshaller;
import com.arm.mgd.core.target.marshaller.binary_v2.gen.ProtoBuilderHelper;
import com.arm.mgd.core.target.marshaller.stream.AbstractBinaryStreamEncoder;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallDescriptor;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.Pair;
import com.arm.mgd.utils.NullUtils;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FunctionCallMarshallerD005
extends FunctionCallMarshallerD001 {
    private final @NonNull Map<Pair<Integer, Long>, MidstreamDataAttachment> currentMidstreamDataStreamItemByPidTid = new HashMap<Pair<Integer, Long>, MidstreamDataAttachment>();

    public FunctionCallMarshallerD005(@NonNull String traceVersion) {
        super(traceVersion);
    }

    private static @Nullable MidstreamDataAttachment findMidstreamAttachment(@NonNull List<@NonNull AbstractFreeAttachment> freeAttachments) {
        for (AbstractFreeAttachment attachment : freeAttachments) {
            if (!(attachment instanceof MidstreamDataAttachment)) continue;
            return (MidstreamDataAttachment)attachment;
        }
        return null;
    }

    @Override
    protected boolean consumeTargetEventInUnmarshaller(@NonNull TargetEventDescriptor targetEventDescriptor) {
        if (targetEventDescriptor.getEventType() == TargetEvent.TargetEventType.MIDSTREAM_DATA) {
            MidstreamDataTargetEventAttachment eventAttachment;
            Long tid;
            assert (targetEventDescriptor.getAttachments().size() == 1);
            assert (targetEventDescriptor.getAttachments().get(0) instanceof MidstreamDataTargetEventAttachment);
            Integer pid = targetEventDescriptor.getProcessId();
            Pair<Integer, Long> pidTid = new Pair<Integer, Long>(pid, tid = (Long)NullUtils.neverNull((Object)(eventAttachment = (MidstreamDataTargetEventAttachment)targetEventDescriptor.getAttachments().get(0)).getThreadId()));
            MidstreamDataAttachment localMidstreamDataStreamItem = this.getCurrentMidstreamDataStreamItem(pidTid);
            if (localMidstreamDataStreamItem == null) {
                this.setCurrentMidstreamDataStreamItem(pidTid, eventAttachment.getAttachment());
            } else {
                this.setCurrentMidstreamDataStreamItem(pidTid, eventAttachment.getAttachment().mergeIncomplete(localMidstreamDataStreamItem));
            }
            return true;
        }
        return super.consumeTargetEventInUnmarshaller(targetEventDescriptor);
    }

    @Override
    protected void postProcessFunctionCallDescriptor(@NonNull FunctionCallDescriptor functionCallDescriptor) {
        Long tid;
        Integer pid = (Integer)NullUtils.neverNull((Object)functionCallDescriptor.getProcessId());
        Pair<Integer, Long> pidTid = new Pair<Integer, Long>(pid, tid = (Long)NullUtils.neverNull((Object)functionCallDescriptor.getThreadId()));
        MidstreamDataAttachment localMidstreamDataStreamItem = this.getCurrentMidstreamDataStreamItem(pidTid);
        if (localMidstreamDataStreamItem != null) {
            this.setCurrentMidstreamDataStreamItem(pidTid, null);
            MidstreamDataAttachment functionAttachment = FunctionCallMarshallerD005.findMidstreamAttachment(functionCallDescriptor.getFreeAttachments());
            if (functionAttachment == null) {
                CoreLogging.warning(null, "Missing midstream data attachment when received streamed data");
                assert (false) : "Missing midstream data attachment when received streamed data";
            } else {
                if (functionAttachment.getFlags() == MidstreamDataAttachment.Flags.INCOMPLETE) {
                    return;
                }
                functionAttachment.mergeIncomplete(localMidstreamDataStreamItem);
            }
        }
    }

    @Override
    protected boolean shouldAddFrameProperties(@NonNull FunctionCall fc) {
        FrameRenderPass renderPass;
        Frame parentFrame = fc.getParentFrame();
        FrameRenderPass frameRenderPass = renderPass = parentFrame == null ? null : parentFrame.getRenderPassFor(fc);
        return renderPass != null && (fc.getFunctionSpec().isDrawCall() || fc.getAsynchronousFunctionCallUid() != null);
    }

    private @Nullable MidstreamDataAttachment getCurrentMidstreamDataStreamItem(@NonNull Pair<Integer, Long> pidTid) {
        return this.currentMidstreamDataStreamItemByPidTid.get(pidTid);
    }

    private void setCurrentMidstreamDataStreamItem(@NonNull Pair<Integer, Long> pidTid, @Nullable MidstreamDataAttachment attachment) {
        if (attachment != null) {
            this.currentMidstreamDataStreamItemByPidTid.put(pidTid, attachment);
        } else {
            this.currentMidstreamDataStreamItemByPidTid.remove(pidTid);
        }
    }

    public void marshallDeviceInfo(@NonNull PrintStream printStream, AbstractTarget target) throws IOException {
        @NonNull CompletableFuture<@NonNull ITargetDeviceInfo> deviceInfoFuture = target.getDeviceInfo();
        @NonNull ITargetDeviceInfo deviceInfo = deviceInfoFuture.getNow(DeviceInfoEventAttachment.deviceInfoNotAvailable());
        @NonNull Marshaller marshaller = new Marshaller(new MarshallerPropertyGetter(IMarshallerDynamicByteDataSink.NULL_SINK));
        @NonNull DeviceInfoEventAttachment deviceInfoEventAttachment = new DeviceInfoEventAttachment(deviceInfo.getGlVendor(), deviceInfo.getGlRenderer(), deviceInfo.getGlVersion(), deviceInfo.getOsArchitecture());
         @NonNull MgdProtosV2.DeviceInfoEventAttachmentProto deviceInfoEventAttachmentProto = marshaller.marshallDeviceInfoEventAttachmentProto(deviceInfoEventAttachment);
        MgdProtosV2.EventAttachmentProto eventAttachmentProto = ProtoBuilderHelper.buildEventAttachmentProtoFromDeviceInfoAttachment(deviceInfoEventAttachmentProto);
        MgdProtosV2.EventProto eventProto = ProtoBuilderHelper.buildEventProto(MgdProtosV2.EventTypeProto.EVENT_CODE_DEVICE_INFO, null, null, null, null, (List)NullUtils.neverNull(Arrays.asList(eventAttachmentProto)));
        @NonNull AbstractBinaryStreamEncoder encoder = this.getEncoder(AbstractFunctionCallMarshaller.DataSource.FILE_STREAM, printStream);
        encoder.writeMessage((MessageLite)ProtoBuilderHelper.buildParentMessageProto(0, null, null, eventProto));
    }

    public void marshallAuthorisedFeatures(@NonNull PrintStream printStream, AbstractTarget target) throws IOException {
        @NonNull Map<Feature, CompletableFuture<@NonNull FeatureAuthorisation>> authorisationFeatures = target.getAuthorisationFeatures();
        @NonNull AbstractBinaryStreamEncoder encoder = this.getEncoder(AbstractFunctionCallMarshaller.DataSource.FILE_STREAM, printStream);
        for (Map.Entry<Feature, CompletableFuture<FeatureAuthorisation>> authorisationFeature : authorisationFeatures.entrySet()) {
            FunctionCallMarshallerD005.addAuthorisationFeatureEvent(encoder, (MgdProtosV2.ProductFeatures)((Object)NullUtils.neverNull((Object)((Object)authorisationFeature.getKey().getAsProductFeatures()))), 0);
        }
    }

    private static void addAuthorisationFeatureEvent(@NonNull AbstractBinaryStreamEncoder encoder,  @NonNull MgdProtosV2.ProductFeatures feature, int processID) throws IOException {
        MgdProtosV2.AuthorisationFeatureEventAttachmentProto featureAttachmentProto = ProtoBuilderHelper.buildAuthorisationFeatureEventAttachmentProto(feature);
        MgdProtosV2.EventAttachmentProto eventAttachmentProto = ProtoBuilderHelper.buildEventAttachmentProtoFromAuthorisationFeature(featureAttachmentProto);
        MgdProtosV2.EventProto eventProto = ProtoBuilderHelper.buildEventProto(MgdProtosV2.EventTypeProto.EVENT_CODE_AUTHORISATION_FEATURE_USED, null, null, null, null, (List)NullUtils.neverNull(Arrays.asList(eventAttachmentProto)));
        encoder.writeMessage((MessageLite)ProtoBuilderHelper.buildParentMessageProto(processID, null, null, eventProto));
    }
}

