/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.marshaller.binary_v2;

import com.arm.mgd.core.pb.v2.MgdProtosV2;
import com.arm.mgd.core.replay.AbstractFrameOverride;
import com.arm.mgd.core.replay.FrameOverrides;
import com.arm.mgd.core.target.data.AsynchronousFunctionAttachment;
import com.arm.mgd.core.target.data.AsynchronousFunctionData;
import com.arm.mgd.core.target.data.FeatureAuthorisationRequestEventAttachment;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.ProcessEndedTargetEventAttachment;
import com.arm.mgd.core.target.data.ProcessStartedTargetEventAttachment;
import com.arm.mgd.core.target.data.TargetEvent;
import com.arm.mgd.core.target.data.TargetEventDescriptor;
import com.arm.mgd.core.target.data.interceptorconfig.InterceptorConfig;
import com.arm.mgd.core.target.data.interceptorconfig.cl.ClConfig;
import com.arm.mgd.core.target.data.interceptorconfig.gles.GlesConfig;
import com.arm.mgd.core.target.data.interceptorconfig.vulkan.VulkanConfig;
import com.arm.mgd.core.target.io.ProcessConfigHistory;
import com.arm.mgd.core.target.io.live.DaemonCommand;
import com.arm.mgd.core.target.io.live.IInterceptorCommand;
import com.arm.mgd.core.target.io.live.ModifyStateInterceptorCommand;
import com.arm.mgd.core.target.io.live.PerProcessInterceptorCommand;
import com.arm.mgd.core.target.marshaller.AbstractFunctionCallMarshaller;
import com.arm.mgd.core.target.marshaller.AbstractLiveTraceMarshaller;
import com.arm.mgd.core.target.marshaller.IMarshallerDataSource;
import com.arm.mgd.core.target.marshaller.IUnmarshallerDataSink;
import com.arm.mgd.core.target.marshaller.TraceParseException;
import com.arm.mgd.core.target.marshaller.binary_v2.FunctionCallListAccumulator;
import com.arm.mgd.core.target.marshaller.binary_v2.MarshallerPropertyGetter;
import com.arm.mgd.core.target.marshaller.binary_v2.UnmarshallerValueFactory;
import com.arm.mgd.core.target.marshaller.binary_v2.gen.Marshaller;
import com.arm.mgd.core.target.marshaller.binary_v2.gen.ProtoBuilderHelper;
import com.arm.mgd.core.target.marshaller.binary_v2.gen.Unmarshaller;
import com.arm.mgd.core.target.marshaller.bytedata.DynamicByteDataModel;
import com.arm.mgd.core.target.marshaller.bytedata.IByteStore;
import com.arm.mgd.core.target.marshaller.stream.AbstractBinaryStreamDecoder;
import com.arm.mgd.core.target.marshaller.stream.AbstractBinaryStreamEncoder;
import com.arm.mgd.core.target.marshaller.stream.LZ4CompressedBinaryStream;
import com.arm.mgd.core.target.marshaller.stream.ProtocolBufferLogger;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallArgumentDescriptor;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallDescriptor;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallList;
import com.arm.mgd.core.target.marshaller.utils.Timestamp;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.core.util.UnsupportedTypeException;
import com.arm.mgd.utils.NullUtils;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FunctionCallMarshallerD001
extends AbstractLiveTraceMarshaller {
    private static final int MAX_DYNAMIC_BYTE_DATA_BYTES = 0x800000;
    private static final int FUNCTION_LIST_BLOCK_SIZE_FILE_SAVE = 0x100000;
    private static final int FUNCTION_LIST_BLOCK_SIZE_REPLAY = 65536;
    private static final int MIN_QUEUED_MESSAGES = 4;
    private static final int MAX_QUEUED_MESSAGE_BYTES = 0x100000;

    public FunctionCallMarshallerD001(@NonNull String traceVersion) {
        super(traceVersion);
    }

    protected static  @NonNull MgdProtosV2.ArgumentContainerProto marshallArguments(@NonNull FunctionCall fc, @NonNull Marshaller marshaller) {
        ArrayList< @NonNull MgdProtosV2.ArgumentProto> result = new ArrayList<MgdProtosV2.ArgumentProto>();
        for (Serializable argObj : fc.getArgValues()) {
            result.add(marshaller.marshallArgumentProto(FunctionCallArgumentDescriptor.fromValue((Serializable)NullUtils.neverNull((Object)argObj))));
        }
        return ProtoBuilderHelper.buildArgumentContainerProto(result);
    }

    protected static  @Nullable MgdProtosV2.ArgumentProto marshallReturnValue(@NonNull FunctionCall fc, @NonNull Marshaller marshaller) {
        if (fc.getReturnValue() != null) {
            return marshaller.marshallArgumentProto(FunctionCallArgumentDescriptor.fromValue((Serializable)NullUtils.neverNull((Object)fc.getReturnValue())));
        }
        return null;
    }

    @Override
    public void marshallFunctionCalls(ICoreProgressMonitor monitor, int processID, FunctionCall[] functionCallList, OutputStream sOut) throws IOException, UnsupportedTypeException {
        AbstractBinaryStreamEncoder encoder = this.getEncoder(AbstractFunctionCallMarshaller.DataSource.LIVE_STREAM, sOut);
        FunctionCallListAccumulator accumulator = new FunctionCallListAccumulator(65536, 0x800000, processID, encoder);
        Marshaller marshaller = new Marshaller(new MarshallerPropertyGetter(byteData -> accumulator.addDynamicByteData(byteData)));
        FunctionCall[] functionCallArray = functionCallList;
        int n = functionCallList.length;
        int n2 = 0;
        while (n2 < n) {
            MgdProtosV2.FunctionCallProto functionCallProto;
            FunctionCall fc = functionCallArray[n2];
            assert (fc != null);
             @NonNull MgdProtosV2.ArgumentContainerProto arguments = FunctionCallMarshallerD001.marshallArguments(fc, marshaller);
            MgdProtosV2.ArgumentProto returnValue = FunctionCallMarshallerD001.marshallReturnValue(fc, marshaller);
            List< @NonNull MgdProtosV2.FreeAttachmentProto> freeAttachments = marshaller.marshallFreeAttachmentProto(fc.getFreeAttachments());
            Frame parentFrame = fc.getParentFrame();
            boolean missingFrameOrRenderPass = parentFrame == null || parentFrame.getRenderPassFor(fc) == null;
            List< @NonNull MgdProtosV2.FrameFeaturesProto> featuresEnabled = missingFrameOrRenderPass ? NullUtils.EMPTY_LIST : FunctionCallMarshallerD001.createFrameFeaturesProtoHelper((FrameRenderPass)NullUtils.neverNull((Object)((Frame)NullUtils.neverNull((Object)parentFrame)).getRenderPassFor(fc)));
            ArrayList< @NonNull MgdProtosV2.FrameOverrideProto> frameOverrides = new ArrayList<MgdProtosV2.FrameOverrideProto>();
            ArrayList< @NonNull MgdProtosV2.FunctionCallFlagsEnumProto> flags = new ArrayList<MgdProtosV2.FunctionCallFlagsEnumProto>();
            try {
                functionCallProto = ProtoBuilderHelper.buildFunctionCallProto(fc.getTid(), MarshallerPropertyGetter.getFunctionCallEnum(fc.getFunctionSpec()), fc.getErrorCode(), returnValue, NullUtils.EMPTY_LIST, freeAttachments, marshaller.marshallTimeValueProto(new Timestamp(fc.getTimestampStart())), marshaller.marshallTimeValueProto(new Timestamp(fc.getTimestampStop())), fc.isFrameEnd(), flags, null, featuresEnabled, frameOverrides, arguments, fc.getAsynchronousFunctionCallUid());
            }
            catch (TraceParseException e) {
                throw new IOException(e);
            }
            accumulator.add(functionCallProto);
            monitor.incProgress(1);
            ++n2;
        }
        accumulator.flush();
    }

    private static void addAsynchronousAssetData(@NonNull AbstractBinaryStreamEncoder encoder, @NonNull IMarshallerDataSource dataSource, @NonNull Marshaller marshaller, @NonNull FunctionCallListAccumulator accumulator) throws IOException {
        if (dataSource.hasAsynchronousAssetData()) {
            @NonNull Map<Integer, List<@NonNull AsynchronousFunctionAttachment>> assetItems = dataSource.getAsynchronousAssetData();
            for (Map.Entry<Integer, List<AsynchronousFunctionAttachment>> assetItemList : assetItems.entrySet()) {
                for (AsynchronousFunctionAttachment assetItem : assetItemList.getValue()) {
                    AsynchronousFunctionData functionData = new AsynchronousFunctionData(assetItemList.getKey(), assetItem);
                     @NonNull MgdProtosV2.AsynchronousFunctionDataProto functionDataProto = marshaller.marshallAsynchronousFunctionDataProto(functionData);
                    MgdProtosV2.EventAttachmentProto eventAttachment = ProtoBuilderHelper.buildEventAttachmentProtoFromAsynchronousFunctionCallDataAttachment(functionDataProto);
                    MgdProtosV2.EventProto asyncEventProto = ProtoBuilderHelper.buildEventProto(MgdProtosV2.EventTypeProto.EVENT_CODE_ASYNCHRONOUS_FUNCTION_CALL_DATA, null, null, null, null, (List)NullUtils.neverNull(Arrays.asList(eventAttachment)));
                    accumulator.flush();
                    encoder.writeMessage((MessageLite)ProtoBuilderHelper.buildParentMessageProto(dataSource.getProcessID(), null, null, asyncEventProto));
                }
            }
        }
    }

    private static void addProcessStartedHeader(@NonNull AbstractBinaryStreamEncoder encoder, @NonNull IMarshallerDataSource dataSource, @NonNull Marshaller marshaller) throws IOException {
        if (dataSource.requiresProcessHeaderForMarshalling()) {
            ProcessStartedTargetEventAttachment attachment = dataSource.getProcessStartedAttachment();
            MgdProtosV2.ProcessStartedEventAttachmentProto psaEventProto = marshaller.marshallProcessStartedEventAttachmentProto(attachment);
            MgdProtosV2.EventAttachmentProto eventAttachment = ProtoBuilderHelper.buildEventAttachmentProtoFromProcessStartedEventAttachment(psaEventProto);
            MgdProtosV2.EventProto eventProto = ProtoBuilderHelper.buildEventProto(MgdProtosV2.EventTypeProto.EVENT_CODE_PROCESS_STARTED, null, null, null, null, (List)NullUtils.neverNull(Arrays.asList(eventAttachment)));
            encoder.writeMessage((MessageLite)ProtoBuilderHelper.buildParentMessageProto(dataSource.getProcessID(), null, null, eventProto));
        }
    }

    private static void addProcessFinishedHeader(@NonNull AbstractBinaryStreamEncoder encoder, @NonNull IMarshallerDataSource dataSource, @NonNull Marshaller marshaller) throws IOException {
        ProcessEndedTargetEventAttachment attachment = dataSource.getProcessEndedAttachment();
        MgdProtosV2.ProcessEndedEventAttachmentProto peaEventProto = marshaller.marshallProcessEndedEventAttachmentProto(attachment);
        MgdProtosV2.EventAttachmentProto eventAttachment = ProtoBuilderHelper.buildEventAttachmentProtoFromProcessEndedEventAttachment(peaEventProto);
        MgdProtosV2.EventProto eventProto = ProtoBuilderHelper.buildEventProto(MgdProtosV2.EventTypeProto.EVENT_CODE_PROCESS_FINISHED, null, null, null, null, (List)NullUtils.neverNull(Arrays.asList(eventAttachment)));
        encoder.writeMessage((MessageLite)ProtoBuilderHelper.buildParentMessageProto(dataSource.getProcessID(), null, null, eventProto));
    }

    private static void addProcessConfigurationEvent(@NonNull AbstractBinaryStreamEncoder encoder, @NonNull InterceptorConfig config, int processID, @NonNull Marshaller marshaller) throws IOException {
        MgdProtosV2.InterceptorConfigProto interceptorConfigProto = marshaller.marshallInterceptorConfigProto(config);
        MgdProtosV2.InterceptorConfigEventAttachmentProto configEventAttachmentProto = ProtoBuilderHelper.buildInterceptorConfigEventAttachmentProto(interceptorConfigProto);
        MgdProtosV2.EventAttachmentProto eventAttachmentProto = ProtoBuilderHelper.buildEventAttachmentProtoFromInterceptorConfiguration(configEventAttachmentProto);
        MgdProtosV2.EventProto eventProto = ProtoBuilderHelper.buildEventProto(MgdProtosV2.EventTypeProto.EVENT_CODE_INTERCEPTOR_CONFIGURATION, null, null, null, null, (List)NullUtils.neverNull(Arrays.asList(eventAttachmentProto)));
        encoder.writeMessage((MessageLite)ProtoBuilderHelper.buildParentMessageProto(processID, null, null, eventProto));
    }

    protected boolean shouldAddFrameProperties(@NonNull FunctionCall fc) {
        Frame parentFrame = fc.getParentFrame();
        return parentFrame != null && parentFrame.getFirstFunctionIndex() == fc.getIndex();
    }

    private static @NonNull Integer getFCIndexFromHistory(@NonNull ProcessConfigHistory pch) {
        return NullUtils.intValueOf((int)pch.functionCallIndexFromInclusive);
    }

    @Override
    public void marshallTrace(@NonNull OutputStream outputStream, IMarshallerDataSource dataSource, ICoreProgressMonitor monitor) throws IOException, UnsupportedTypeException {
        assert (monitor != null);
        monitor.setTask("Marshalling Trace", dataSource.getFunctionCallCount());
        @NonNull AbstractBinaryStreamEncoder encoder = this.getEncoder(AbstractFunctionCallMarshaller.DataSource.FILE_STREAM, outputStream);
        FunctionCallListAccumulator accumulator = new FunctionCallListAccumulator(0x100000, 0x800000, dataSource.getProcessID(), encoder);
        @NonNull Marshaller marshaller = new Marshaller(new MarshallerPropertyGetter(byteData -> accumulator.addDynamicByteData(byteData)));
        FunctionCallMarshallerD001.addProcessStartedHeader(encoder, dataSource, marshaller);
        Map<Integer, InterceptorConfig> configEventMap = dataSource.getInterceptorConfigHistory().stream().collect(Collectors.toMap(pch -> FunctionCallMarshallerD001.getFCIndexFromHistory(pch), pch -> pch.processConfig.interceptorConfig));
        int i = 0;
        while (i < dataSource.getFunctionCallCount()) {
            if (configEventMap.containsKey(i)) {
                accumulator.flush();
                FunctionCallMarshallerD001.addProcessConfigurationEvent(encoder, (InterceptorConfig)NullUtils.neverNull((Object)configEventMap.get(i)), dataSource.getProcessID(), marshaller);
            }
            @NonNull FunctionCall fc = dataSource.getCallItem(i);
            @Nullable String note = dataSource.getNoteForCallItem(i);
             @NonNull MgdProtosV2.ArgumentContainerProto arguments = FunctionCallMarshallerD001.marshallArguments(fc, marshaller);
            MgdProtosV2.ArgumentProto returnValue = FunctionCallMarshallerD001.marshallReturnValue(fc, marshaller);
            @NonNull List< @NonNull MgdProtosV2.FreeAttachmentProto> freeAttachments = marshaller.marshallFreeAttachmentProto(fc.getFreeAttachments());
            List< @NonNull MgdProtosV2.FrameFeaturesProto> frameFeaturesProto = NullUtils.EMPTY_LIST;
            List< @NonNull MgdProtosV2.FrameOverrideProto> frameOverrideProto = NullUtils.EMPTY_LIST;
            if (this.shouldAddFrameProperties(fc)) {
                Frame parentFrame = (Frame)NullUtils.neverNull((Object)fc.getParentFrame());
                FrameRenderPass renderPass = parentFrame.getRenderPassFor(fc);
                if (renderPass != null) {
                    frameFeaturesProto = FunctionCallMarshallerD001.createFrameFeaturesProtoHelper(renderPass);
                }
                FrameOverrides frameOverride = parentFrame.getFrameOverrides();
                frameOverrideProto = FunctionCallMarshallerD001.createFrameOverrideProtoHelper(marshaller, (FrameOverrides)NullUtils.neverNull((Object)frameOverride));
            }
            List< @NonNull MgdProtosV2.FunctionCallFlagsEnumProto> flags = FunctionCallMarshallerD001.createFunctionCallFlagsEnumProtoHelper(fc);
            try {
                 @NonNull MgdProtosV2.FunctionCallProto functionCallProto = ProtoBuilderHelper.buildFunctionCallProto(fc.getTid(), MarshallerPropertyGetter.getFunctionCallEnum(fc.getFunctionSpec()), fc.getErrorCode(), returnValue, NullUtils.EMPTY_LIST, freeAttachments, marshaller.marshallTimeValueProto(new Timestamp(fc.getTimestampStart())), marshaller.marshallTimeValueProto(new Timestamp(fc.getTimestampStop())), fc.isFrameEnd(), flags, note, frameFeaturesProto, frameOverrideProto, arguments, fc.getAsynchronousFunctionCallUid());
                accumulator.add(functionCallProto);
            }
            catch (TraceParseException e) {
                throw new IOException(e);
            }
            monitor.incProgress(1);
            if (i % 10000 == 0 && monitor.isCancelled()) {
                return;
            }
            ++i;
        }
        accumulator.flush();
        FunctionCallMarshallerD001.addAsynchronousAssetData(encoder, dataSource, marshaller, accumulator);
        if (dataSource.requiresProcessHeaderForMarshalling()) {
            FunctionCallMarshallerD001.addProcessFinishedHeader(encoder, dataSource, marshaller);
        }
    }

    private static @NonNull List< @NonNull MgdProtosV2.FrameOverrideProto> createFrameOverrideProtoHelper(@NonNull Marshaller marshaller, @NonNull FrameOverrides frameOverride) throws UnsupportedTypeException {
        @NonNull ArrayList< @NonNull MgdProtosV2.FrameOverrideProto> frameOverrideProto = new ArrayList<MgdProtosV2.FrameOverrideProto>();
        for (AbstractFrameOverride afo : frameOverride) {
            MgdProtosV2.FrameOverrideProto protoObject = marshaller.marshallFrameOverrideProto(afo.asMarshallerObject());
            if (protoObject == null) {
                throw new UnsupportedTypeException("Unexpected object for marshaller : " + afo);
            }
            frameOverrideProto.add(protoObject);
        }
        return frameOverrideProto;
    }

    private static @NonNull List< @NonNull MgdProtosV2.FunctionCallFlagsEnumProto> createFunctionCallFlagsEnumProtoHelper(@NonNull FunctionCall fc) {
        ArrayList< @NonNull MgdProtosV2.FunctionCallFlagsEnumProto> flags = new ArrayList<MgdProtosV2.FunctionCallFlagsEnumProto>();
        if (fc.getHidden()) {
            flags.add(MgdProtosV2.FunctionCallFlagsEnumProto.FC_FLAG_HIDDEN_FUNCTION);
        }
        if (fc.isMissingFunctionCalled()) {
            flags.add(MgdProtosV2.FunctionCallFlagsEnumProto.FC_FLAG_MISSING_FUNCTION_CALLED);
        }
        return flags;
    }

    private static @NonNull List< @NonNull MgdProtosV2.FrameFeaturesProto> createFrameFeaturesProtoHelper(@NonNull FrameRenderPass frameRenderPass) {
        ArrayList< @NonNull MgdProtosV2.FrameFeaturesProto> frameFeaturesProto = new ArrayList<MgdProtosV2.FrameFeaturesProto>();
        switch (frameRenderPass.getCaptureMode()) {
            case FRAGMENT_COUNT: {
                frameFeaturesProto.add(MgdProtosV2.FrameFeaturesProto.FRAME_FEATURE_FRAGMENT_COUNT);
                break;
            }
            case OVERDRAW: {
                frameFeaturesProto.add(MgdProtosV2.FrameFeaturesProto.FRAME_FEATURE_OVERDRAW);
                break;
            }
            case SHADER_MAP: {
                frameFeaturesProto.add(MgdProtosV2.FrameFeaturesProto.FRAME_FEATURE_SHADER_MAP);
                break;
            }
            case CAPTURE_ALL_ATTACHMENTS: {
                frameFeaturesProto.add(MgdProtosV2.FrameFeaturesProto.FRAME_FEATURE_CAPTURE_ALL_ATTACHMENTS);
                break;
            }
        }
        if (frameRenderPass.isCaptured()) {
            frameFeaturesProto.add(MgdProtosV2.FrameFeaturesProto.FRAME_FEATURE_FRAME_CAPTURE);
        }
        if (frameRenderPass.isReplayed()) {
            frameFeaturesProto.add(MgdProtosV2.FrameFeaturesProto.FRAME_FEATURE_FRAME_REPLAY);
        }
        return frameFeaturesProto;
    }

    @Override
    public boolean unmarshall( @NonNull AbstractFunctionCallMarshaller.DataSource dataSource, @NonNull InputStream inputStream, @NonNull IUnmarshallerDataSink dataSink, @NonNull IByteStore byteStore) {
        block18: {
            AbstractBinaryStreamDecoder decoder = this.getDecoder(dataSource, inputStream);
            DynamicByteDataModel model = new DynamicByteDataModel(byteStore);
            Unmarshaller unmarshaller = new Unmarshaller(new UnmarshallerValueFactory(model, byteStore));
            ConcurrentLinkedQueue<Message> queue = new ConcurrentLinkedQueue<Message>();
            AtomicInteger queuedProtobufCount = new AtomicInteger(0);
            AtomicInteger queuedProtobufBytes = new AtomicInteger(0);
            AtomicBoolean joinProcessThread = new AtomicBoolean(false);
            Thread processThread = new Thread(() -> {
                while (!this.stopRequested.get()) {
                    try {
                        boolean doJoin = joinProcessThread.get();
                        @Nullable Message message = (Message)queue.poll();
                        if (message != null) {
                            queuedProtobufCount.decrementAndGet();
                            queuedProtobufBytes.addAndGet(-message.sizeBytes);
                            this.processParentMessageProto(message.proto, unmarshaller, dataSink, model);
                            continue;
                        }
                        if (doJoin) break;
                        Thread.sleep(10L);
                    }
                    catch (TraceParseException e) {
                        CoreLogging.severe(dataSink, "Unable to parse protocol buffer message: " + e.getMessage());
                        e.printStackTrace();
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }, "ParentMessageProto processing thread");
            try {
                try {
                    processThread.start();
                    while (!this.stopRequested.get()) {
                        try {
                            byte[] data = decoder.readMessage();
                            if (data == null) {
                                break;
                            }
                            Message message = new Message(data);
                            this.nBytesReadThisSession.set(decoder.getNumberOfBytesReadThisSession());
                            while (queuedProtobufCount.get() > 4 && queuedProtobufBytes.get() > 0x100000) {
                                if (!processThread.isAlive()) {
                                    break block18;
                                }
                                Thread.sleep(10L);
                            }
                            queuedProtobufCount.incrementAndGet();
                            queuedProtobufBytes.addAndGet(message.sizeBytes);
                            queue.offer(message);
                        }
                        catch (SocketException e) {
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            break;
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    joinProcessThread.set(true);
                    try {
                        processThread.join();
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                    return false;
                }
            }
            finally {
                joinProcessThread.set(true);
                try {
                    processThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.stopRequested.get();
    }

    private void processParentMessageProto( @NonNull MgdProtosV2.ParentMessageProto parentMessageProto, @NonNull Unmarshaller unmarshaller, @NonNull IUnmarshallerDataSink dataSink, @NonNull DynamicByteDataModel model) throws TraceParseException {
        if (parentMessageProto.hasFunctionCalls()) {
            FunctionCallList functionCallList = unmarshaller.unmarshall((MgdProtosV2.FunctionCallListProto)NullUtils.neverNull((Object)parentMessageProto.getFunctionCalls()), parentMessageProto.getProcessId());
            for (FunctionCallDescriptor functionCallDescriptor : functionCallList.getFunctionCalls()) {
                this.postProcessFunctionCallDescriptor(functionCallDescriptor);
                dataSink.appendNewFunctionCall(functionCallDescriptor);
            }
        } else if (parentMessageProto.hasEvent()) {
            TargetEventDescriptor targetEventDescriptor = unmarshaller.unmarshall((MgdProtosV2.EventProto)NullUtils.neverNull((Object)parentMessageProto.getEvent()), parentMessageProto.getProcessId());
            if (!this.consumeTargetEventInUnmarshaller(targetEventDescriptor)) {
                dataSink.addTargetEvent(targetEventDescriptor);
            }
        } else if (parentMessageProto.hasDynamicByteData()) {
            model.addToModel(parentMessageProto.getProcessId(), (MgdProtosV2.DynamicByteDataProto)NullUtils.neverNull((Object)parentMessageProto.getDynamicByteData()));
        } else {
            throw new TraceParseException("Unexpected unmarshalled object: " + parentMessageProto + ".");
        }
    }

    private static  @NonNull MgdProtosV2.CommandEnumProto convertCommandEnumToProto(IInterceptorCommand.Command command) {
        switch (command) {
            case CAPTURE_FRAME: {
                return MgdProtosV2.CommandEnumProto.CMD_CAPTURE_FRAME;
            }
            case DEFERRED_COMMAND: {
                return MgdProtosV2.CommandEnumProto.CMD_DEFERRED_COMMAND;
            }
            case DISCONNECT: {
                return MgdProtosV2.CommandEnumProto.CMD_DISCONNECT;
            }
            case END_FRAME_REPLAY: {
                return MgdProtosV2.CommandEnumProto.CMD_END_FRAME_REPLAY;
            }
            case ENTER_FRAME_REPLAY: {
                return MgdProtosV2.CommandEnumProto.CMD_ENTER_FRAME_REPLAY;
            }
            case HOST_ATTACH_STATE_CHANGED: {
                return MgdProtosV2.CommandEnumProto.CMD_HOST_ATTACH_STATE_CHANGED;
            }
            case PAUSE_ON_FRAME_END: {
                return MgdProtosV2.CommandEnumProto.CMD_PAUSE_ON_FRAME_END;
            }
            case PAUSE_ON_NEXT_CALL: {
                return MgdProtosV2.CommandEnumProto.CMD_PAUSE_ON_NEXT_CALL;
            }
            case RESUME: {
                return MgdProtosV2.CommandEnumProto.CMD_RESUME;
            }
            case SET_CAPTURE_MODE: {
                return MgdProtosV2.CommandEnumProto.CMD_SET_CAPTURE_MODE;
            }
            case SET_FILMSTRIP: {
                return MgdProtosV2.CommandEnumProto.CMD_SET_FILMSTRIP_ENABLED;
            }
            case SET_OUTPUT_BUFFER_SENDING: {
                return MgdProtosV2.CommandEnumProto.CMD_SET_OUTPUT_BUFFER_SENDING_ENABLED;
            }
            case STEP_TO_NEXT_FRAME_END: {
                return MgdProtosV2.CommandEnumProto.CMD_STEP_TO_NEXT_FRAME_END;
            }
            case AUTHORISE_FEATURE: {
                return MgdProtosV2.CommandEnumProto.CMD_AUTHORISE_FEATURE;
            }
            case CONFIGURE_INTERCEPTOR: {
                return MgdProtosV2.CommandEnumProto.CMD_CONFIGURE_INTERCEPTOR;
            }
            case SET_HEADLESS_MODE: {
                return MgdProtosV2.CommandEnumProto.CMD_SET_HEADLESS_MODE_ENABLED;
            }
            case KILL_DAEMON: {
                return MgdProtosV2.CommandEnumProto.CMD_KILL_DAEMON;
            }
        }
        assert (false) : "Unrecognised command: " + (Object)((Object)command);
        throw new AssertionError((Object)command);
    }

    private static @Nullable Integer convertCommandParameterEnumToProto(IInterceptorCommand.ICommandParameter parameter) {
        if (parameter instanceof PerProcessInterceptorCommand.PerProcessCommandParameter) {
            PerProcessInterceptorCommand.PerProcessCommandParameter commandParameter = (PerProcessInterceptorCommand.PerProcessCommandParameter)parameter;
            switch (commandParameter) {
                case ADD: {
                    return 1;
                }
                case ATTACHED: {
                    return 0;
                }
                case DETACHED: {
                    return 1;
                }
                case DISABLE: {
                    return 0;
                }
                case ENABLE: {
                    return 1;
                }
                case REMOVE: {
                    return 0;
                }
                case REPLAY_CAPTURE: {
                    return 1;
                }
                case REPLAY_NO_CAPTURE: {
                    return 0;
                }
            }
            assert (false) : "Unknown PerProcessCommandParameter: " + commandParameter;
        } else if (parameter instanceof ModifyStateInterceptorCommand.ModifyStateParameter) {
            ModifyStateInterceptorCommand.ModifyStateParameter commandParameter = (ModifyStateInterceptorCommand.ModifyStateParameter)parameter;
            switch (commandParameter) {
                case ALL_ATTACHMENTS: {
                    return 2;
                }
                case FRAGMENT_COUNT: {
                    return 3;
                }
                case NONE: {
                    return 1;
                }
                case OVERDRAW: {
                    return 4;
                }
                case SHADERMAP: {
                    return 5;
                }
            }
            assert (false) : "Unknown ModifyStateParameter: " + commandParameter;
        } else if (parameter == null) {
            return null;
        }
        throw new AssertionError(parameter);
    }

    @Override
    public void writeCommandToStream(@NonNull OutputStream sOut, int processID, IInterceptorCommand command) throws IOException {
        AbstractBinaryStreamEncoder encoder = this.getEncoder(AbstractFunctionCallMarshaller.DataSource.LIVE_STREAM, sOut);
        MgdProtosV2.CommandEnumProto commandEnumProto = FunctionCallMarshallerD001.convertCommandEnumToProto(command.getCommand());
        Integer commandParameterValue = FunctionCallMarshallerD001.convertCommandParameterEnumToProto(command.getParameter());
        MgdProtosV2.CommandProto commandProto = ProtoBuilderHelper.buildCommandProto(commandEnumProto, commandParameterValue, null);
        encoder.writeMessage((MessageLite)ProtoBuilderHelper.buildParentMessageProto(processID, null, commandProto, null));
        sOut.flush();
    }

    @Override
    public void writeDeferredCommandToStream(@NonNull OutputStream outputStream, int processID, @NonNull IInterceptorCommand command, @NonNull IInterceptorCommand attachmentCommand, int frameNumber) throws IOException {
        AbstractBinaryStreamEncoder encoder = this.getEncoder(AbstractFunctionCallMarshaller.DataSource.LIVE_STREAM, outputStream);
        MgdProtosV2.CommandEnumProto attachmentCommandType = FunctionCallMarshallerD001.convertCommandEnumToProto(attachmentCommand.getCommand());
        Integer attachmentCommandParameterValue = FunctionCallMarshallerD001.convertCommandParameterEnumToProto(attachmentCommand.getParameter());
        MgdProtosV2.DeferredCommandAttachmentProto deferredCommandAttachmentProto = ProtoBuilderHelper.buildDeferredCommandAttachmentProto(ProtoBuilderHelper.buildCommandProto(attachmentCommandType, attachmentCommandParameterValue, null), frameNumber);
        MgdProtosV2.CommandEnumProto commandType = FunctionCallMarshallerD001.convertCommandEnumToProto(command.getCommand());
        Integer commandParameterValue = FunctionCallMarshallerD001.convertCommandParameterEnumToProto(command.getParameter());
        MgdProtosV2.CommandProto commandProto = ProtoBuilderHelper.buildCommandProto(commandType, commandParameterValue, ProtoBuilderHelper.buildCommandAttachmentProtoFromDeferredCommandAttachment(deferredCommandAttachmentProto));
        encoder.writeMessage((MessageLite)ProtoBuilderHelper.buildParentMessageProto(processID, null, commandProto, null));
        outputStream.flush();
    }

    @Override
    public void writeFeatureAuthorisationCommandToStream(@NonNull OutputStream outputStream, int processID, @NonNull FeatureAuthorisationRequestEventAttachment attachment, boolean allow, @Nullable String reason) throws IOException {
        AbstractBinaryStreamEncoder encoder = this.getEncoder(AbstractFunctionCallMarshaller.DataSource.LIVE_STREAM, outputStream);
        MgdProtosV2.FeatureAuthorisationCommandAttachmentProto buildFeatureAuthorisationCommandAttachmentProto = ProtoBuilderHelper.buildFeatureAuthorisationCommandAttachmentProto(ProtoBuilderHelper.buildFeatureAuthorisationRequestEventAttachmentProto(ProtoBuilderHelper.buildTimeValueProto(attachment.getTimestamp().asLong()), attachment.getUniqueValue(), attachment.getFeature()), allow, reason);
        MgdProtosV2.CommandProto commandProto = ProtoBuilderHelper.buildCommandProto(FunctionCallMarshallerD001.convertCommandEnumToProto(DaemonCommand.AUTHORISE_FEATURE.getCommand()), FunctionCallMarshallerD001.convertCommandParameterEnumToProto(DaemonCommand.AUTHORISE_FEATURE.getParameter()), ProtoBuilderHelper.buildCommandAttachmentProtoFromAuthorisationAttachment(buildFeatureAuthorisationCommandAttachmentProto));
        encoder.writeMessage((MessageLite)ProtoBuilderHelper.buildParentMessageProto(processID, null, commandProto, null));
        outputStream.flush();
    }

    @Override
    public void writeInterceptorConfigurationToStream(@NonNull OutputStream outputStream, int processID, @NonNull InterceptorConfig interceptorConfig) throws IOException {
        AbstractBinaryStreamEncoder encoder = this.getEncoder(AbstractFunctionCallMarshaller.DataSource.LIVE_STREAM, outputStream);
        MgdProtosV2.InterceptorConfigProto interceptorConfigProto = interceptorConfig.getProtoBuf();
        MgdProtosV2.InterceptorConfigCommandAttachmentProto attachment = ProtoBuilderHelper.buildInterceptorConfigCommandAttachmentProto(interceptorConfigProto);
        MgdProtosV2.CommandProto commandProto = ProtoBuilderHelper.buildCommandProto(MgdProtosV2.CommandEnumProto.CMD_CONFIGURE_INTERCEPTOR, null, ProtoBuilderHelper.buildCommandAttachmentProtoFromConfiguration(attachment));
        encoder.writeMessage((MessageLite)ProtoBuilderHelper.buildParentMessageProto(processID, null, commandProto, null));
        outputStream.flush();
    }

    @Override
    public void writeInterceptorConfigurationToStream(@NonNull OutputStream outputStream, int processID, @Nullable ClConfig clConfig, @Nullable GlesConfig glesConfig, @Nullable VulkanConfig vulkanConfig) throws IOException {
        AbstractBinaryStreamEncoder encoder = this.getEncoder(AbstractFunctionCallMarshaller.DataSource.LIVE_STREAM, outputStream);
        MgdProtosV2.ClConfigProto clConfigProto = clConfig != null ? clConfig.getProtoBuf() : null;
        MgdProtosV2.GlesConfigProto glesConfigProto = glesConfig != null ? glesConfig.getProtoBuf() : null;
        MgdProtosV2.VulkanConfigProto vulkanConfigProto = vulkanConfig != null ? vulkanConfig.getProtoBuf() : null;
        MgdProtosV2.InterceptorConfigProto interceptorConfigProto = ProtoBuilderHelper.buildInterceptorConfigProto(clConfigProto, glesConfigProto, vulkanConfigProto);
        MgdProtosV2.InterceptorConfigCommandAttachmentProto attachment = ProtoBuilderHelper.buildInterceptorConfigCommandAttachmentProto(interceptorConfigProto);
        MgdProtosV2.CommandProto commandProto = ProtoBuilderHelper.buildCommandProto(MgdProtosV2.CommandEnumProto.CMD_CONFIGURE_INTERCEPTOR, null, ProtoBuilderHelper.buildCommandAttachmentProtoFromConfiguration(attachment));
        encoder.writeMessage((MessageLite)ProtoBuilderHelper.buildParentMessageProto(processID, null, commandProto, null));
        outputStream.flush();
    }

    @Override
    public @NonNull AbstractBinaryStreamDecoder getDecoder( @NonNull AbstractFunctionCallMarshaller.DataSource dataSource, @NonNull InputStream inputStream) {
        return new LZ4CompressedBinaryStream.Decoder(inputStream);
    }

    @Override
    public @NonNull AbstractBinaryStreamEncoder getEncoder( @NonNull AbstractFunctionCallMarshaller.DataSource dataSource, @NonNull OutputStream outputStream) {
        return new LZ4CompressedBinaryStream.Encoder(outputStream, dataSource == AbstractFunctionCallMarshaller.DataSource.LIVE_STREAM);
    }

    protected boolean consumeTargetEventInUnmarshaller(@NonNull TargetEventDescriptor targetEventDescriptor) {
        assert (targetEventDescriptor.getEventType() != TargetEvent.TargetEventType.MIDSTREAM_DATA);
        return false;
    }

    protected void postProcessFunctionCallDescriptor(@NonNull FunctionCallDescriptor functionCallDescriptor) {
        @Nullable String notes = functionCallDescriptor.getNotes();
        if (notes != null && notes.isEmpty()) {
            functionCallDescriptor.setNotes(null);
        }
    }

    private static final class Message {
        public final  @NonNull MgdProtosV2.ParentMessageProto proto;
        public final int sizeBytes;

        private Message(byte @NonNull [] data) throws InvalidProtocolBufferException {
            this.proto = (MgdProtosV2.ParentMessageProto)NullUtils.neverNull((Object)MgdProtosV2.ParentMessageProto.parseFrom(data));
            try {
                ProtocolBufferLogger.logRead((MessageLite)this.proto);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sizeBytes = data.length;
        }
    }
}

