/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.marshaller.binary_v2;

import com.arm.mgd.core.pb.v2.MgdProtosV2;
import com.arm.mgd.core.target.marshaller.binary_v2.gen.ProtoBuilderHelper;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.target.marshaller.stream.AbstractBinaryStreamEncoder;
import com.arm.mgd.utils.NullUtils;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

class FunctionCallListAccumulator {
    private final int blockSize;
    private final int maxDynamicByteDataSize;
    private int currentLength = 0;
    private final @NonNull List< @NonNull MgdProtosV2.FunctionCallProto> functionCalls = new ArrayList<MgdProtosV2.FunctionCallProto>();
    private final @NonNull List< @NonNull MgdProtosV2.DynamicByteDataProto> dynamicByteDatas = new ArrayList<MgdProtosV2.DynamicByteDataProto>();
    private final int processID;
    private final @NonNull AbstractBinaryStreamEncoder sOut;
    private final @NonNull AtomicLong dynamicByteDataCount = new AtomicLong(0L);

    public FunctionCallListAccumulator(int blockSize, int maxDynamicByteDataSize, int processID, @NonNull AbstractBinaryStreamEncoder sOut) {
        this.blockSize = blockSize;
        this.maxDynamicByteDataSize = maxDynamicByteDataSize;
        this.processID = processID;
        this.sOut = sOut;
    }

    public void add( @NonNull MgdProtosV2.FunctionCallProto functionCall) throws IOException {
        if (this.currentLength > this.blockSize) {
            this.flush();
        }
        this.functionCalls.add(functionCall);
        this.currentLength += functionCall.toByteArray().length;
    }

    public @Nullable Long addDynamicByteData(@Nullable IByteDataProvider byteData) {
        if (byteData == null) {
            return null;
        }
        long initialId = this.dynamicByteDataCount.get();
        @NonNull ByteBuffer data = byteData.getData();
        int length = byteData.getLength();
        int offset = 0;
        while (true) {
            data.position(offset);
            int remaining = length - offset;
            int numBytes = Math.min(remaining, this.maxDynamicByteDataSize);
            MgdProtosV2.DynamicByteDataProto.Builder resultBuilder = MgdProtosV2.DynamicByteDataProto.newBuilder();
            resultBuilder.setId(this.dynamicByteDataCount.getAndIncrement());
            resultBuilder.setLength(remaining);
            resultBuilder.setData(ByteString.copyFrom((ByteBuffer)data, (int)numBytes));
            this.dynamicByteDatas.add((MgdProtosV2.DynamicByteDataProto)NullUtils.neverNull((Object)resultBuilder.build()));
            if (numBytes == remaining) break;
            offset += numBytes;
        }
        this.currentLength += byteData.getLength();
        return initialId;
    }

    public void flush() throws IOException {
        for (MgdProtosV2.DynamicByteDataProto proto : this.dynamicByteDatas) {
            MgdProtosV2.ParentMessageProto.Builder parentBuilder = MgdProtosV2.ParentMessageProto.newBuilder();
            parentBuilder.setDynamicByteData(proto);
            parentBuilder.setProcessId(this.processID);
            this.sOut.writeMessage((MessageLite)parentBuilder.build());
        }
        if (this.functionCalls.size() != 0) {
            MgdProtosV2.FunctionCallListProto functionCallsContainer = ProtoBuilderHelper.buildFunctionCallListProto(this.functionCalls);
            this.sOut.writeMessage((MessageLite)ProtoBuilderHelper.buildParentMessageProto(this.processID, functionCallsContainer, null, null));
        }
        this.dynamicByteDatas.clear();
        this.functionCalls.clear();
        this.currentLength = 0;
    }
}

