/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.marshaller.ascii;

import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.target.data.AbstractFreeAttachment;
import com.arm.mgd.core.target.data.FrameFeaturesFlagsEnum;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.IArgumentAttachment;
import com.arm.mgd.core.target.io.live.ModifyStateInterceptorCommand;
import com.arm.mgd.core.target.marshaller.AbstractFunctionCallMarshaller;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallArgumentDescriptor;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallDescriptor;
import com.arm.mgd.core.target.marshaller.utils.Timestamp;
import com.arm.mgd.kapi.extended.ArgumentSpec;
import com.arm.mgd.kapi.extended.UsageSpec;
import com.arm.mgd.kapi.gen.ElementTypeSpec;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FunctionCallDescriptorBuilder {
    private final @NonNull List<@NonNull FunctionCallArgumentDescriptor> arguments;
    private final @Nullable Integer errorCode;
    private final @NonNull Set<@NonNull FrameFeaturesFlagsEnum> featuresEnabled;
    private final @NonNull List<@NonNull AbstractFreeAttachment> freeAttachments;
    private final @NonNull IFunctionOrAliasSpecExtended functionSpec;
    private final int pid;
    private final @Nullable FunctionCallArgumentDescriptor returnValue;
    private final long tid;
    private final long timestampStart;
    private final long timestampStop;
    private final boolean frameEnd;

    private static @NonNull IFunctionOrAliasSpecExtended findFunctionSpec(@NonNull String name) {
        IFunctionOrAliasSpecExtended functionSpec = KapiSpec.getFunctionSpecByName(name);
        if (functionSpec != null) {
            return functionSpec;
        }
        return KapiSpec.getDefaultFunction(name);
    }

    private static @NonNull List<@NonNull FunctionCallArgumentDescriptor> parseArguments(@NonNull IFunctionOrAliasSpecExtended functionSpec, Serializable @Nullable [] args) {
        if (args == null) {
            return NullUtils.EMPTY_LIST;
        }
        if (functionSpec.isUnrecognisedFunction()) {
            ArrayList<@NonNull FunctionCallArgumentDescriptor> result = new ArrayList<FunctionCallArgumentDescriptor>(args.length);
            Serializable[] serializableArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Serializable arg = serializableArray[n2];
                result.add(FunctionCallArgumentDescriptor.fromValue((Serializable)NullUtils.neverNull((Object)FunctionCall.convertArgStringToJavaType(arg, null, null))));
                ++n2;
            }
            return result;
        }
        ArrayList<@NonNull FunctionCallArgumentDescriptor> result = new ArrayList<FunctionCallArgumentDescriptor>(args.length);
        int i = 0;
        while (i < args.length) {
            ArgumentSpec argSpec = functionSpec.getArg().get(i);
            result.add(FunctionCallArgumentDescriptor.fromValue((Serializable)NullUtils.neverNull((Object)FunctionCall.convertArgStringToJavaType(args[i], argSpec.getBasicType().getJtype(), argSpec.getUsage()))));
            ++i;
        }
        return result;
    }

    private static @Nullable FunctionCallArgumentDescriptor parseReturnValue(@NonNull IFunctionOrAliasSpecExtended functionSpec, @Nullable Serializable returnValue) {
        ElementTypeSpec elementType;
        if (returnValue == null) {
            return null;
        }
        try {
            elementType = functionSpec.getReturnType().getBasicType().getJtype();
        }
        catch (Throwable t) {
            elementType = null;
        }
        UsageSpec usage = functionSpec.getReturnType() != null ? functionSpec.getReturnType().getUsage() : null;
        return FunctionCallArgumentDescriptor.fromValue((Serializable)NullUtils.neverNull((Object)FunctionCall.convertArgStringToJavaType(returnValue, elementType, usage)));
    }

    public FunctionCallDescriptorBuilder(@NonNull String name, Serializable @Nullable [] args, int pid, long tid, long timestampStart, long timestampStop, @Nullable Serializable returnValue) {
        this(name, args, pid, tid, timestampStart, timestampStop, returnValue, null);
    }

    public FunctionCallDescriptorBuilder(@NonNull String name, Serializable @Nullable [] args, int pid, long tid, long timestampStart, long timestampStop, @Nullable Serializable returnValue, @Nullable Integer errorCode) {
        this(name, args, pid, tid, timestampStart, timestampStop, returnValue, errorCode, false);
    }

    public FunctionCallDescriptorBuilder(@NonNull String name, Serializable @Nullable [] args, int pid, long tid, long timestampStart, long timestampStop, @Nullable Serializable returnValue, @Nullable Integer errorCode, boolean frameEnd) {
        this.functionSpec = FunctionCallDescriptorBuilder.findFunctionSpec(name);
        this.arguments = FunctionCallDescriptorBuilder.parseArguments(this.functionSpec, args);
        this.pid = pid;
        this.tid = tid;
        this.timestampStart = timestampStart;
        this.timestampStop = timestampStop;
        this.returnValue = FunctionCallDescriptorBuilder.parseReturnValue(this.functionSpec, returnValue);
        this.errorCode = this.functionSpec.isUnrecognisedFunction() ? Integer.valueOf(0) : errorCode;
        this.featuresEnabled = new HashSet<FrameFeaturesFlagsEnum>();
        this.freeAttachments = new ArrayList<AbstractFreeAttachment>();
        this.frameEnd = frameEnd;
    }

    public void addArgAttachment(int argIndex, @NonNull IArgumentAttachment argAttachment) {
        Pointer ptrValue;
        Serializable object = this.arguments.get(argIndex).getRawObjectValue();
        Pointer pointer = ptrValue = object instanceof Pointer ? (Pointer)object : null;
        assert (ptrValue != null);
        argAttachment.setOriginalPointerValue(ptrValue);
        this.arguments.set(argIndex, FunctionCallArgumentDescriptor.fromValue(argAttachment));
    }

    public void addFreeAttachment(@NonNull AbstractFreeAttachment freeAttachment) {
        this.freeAttachments.add(freeAttachment);
    }

    public @NonNull FunctionCallDescriptor build() {
        int errorValue = this.errorCode != null ? this.errorCode.intValue() : this.functionSpec.getKapiSpec().getApi().getApiInfo().getSuccessConstant().getResolvedValue().intValue();
        return new FunctionCallDescriptor(this.pid, this.tid, new Timestamp(this.timestampStart), new Timestamp(this.timestampStop), this.functionSpec, errorValue, this.getReturnValue(), this.getArguments(), this.functionSpec.isAlwaysFrameEnd() || this.frameEnd, NullUtils.EMPTY_LIST, null, this.freeAttachments, this.featuresEnabled, NullUtils.EMPTY_LIST, null);
    }

    public @NonNull List<@NonNull Serializable> getArguments() {
        List<@NonNull T> listOfArgValues = IntStream.range(0, this.arguments.size()).mapToObj(i -> this.arguments.get(i).getObjectValue(this.functionSpec, i)).collect(Collectors.toList());
        @NonNull List<@NonNull Serializable> rewrittenArgValues = IntStream.range(0, this.arguments.size()).mapToObj(i -> AbstractFunctionCallMarshaller.rewriteArgumentAttachment(this.functionSpec, i, listOfArgValues)).collect(Collectors.toList());
        return rewrittenArgValues;
    }

    public @NonNull IFunctionOrAliasSpecExtended getFunctionSpec() {
        return this.functionSpec;
    }

    public @Nullable Serializable getReturnValue() {
        return this.returnValue != null ? this.returnValue.getReturnObjectValue(this.functionSpec) : null;
    }

    public void setCurrentFrameCommand(ModifyStateInterceptorCommand currentFrameCommand) {
        if (currentFrameCommand != ModifyStateInterceptorCommand.ALL_DISABLED) {
            switch (currentFrameCommand) {
                case ALLATTACHMENTSMODE_ENABLED: {
                    this.featuresEnabled.add(FrameFeaturesFlagsEnum.FRAME_CAPTURE_ENABLED);
                    break;
                }
                case FRAGMENTCOUNT_ENABLED: {
                    this.featuresEnabled.add(FrameFeaturesFlagsEnum.FRAGMENT_COUNT_ENABLED);
                    this.featuresEnabled.add(FrameFeaturesFlagsEnum.FRAME_CAPTURE_ENABLED);
                    break;
                }
                case OVERDRAW_ENABLED: {
                    this.featuresEnabled.add(FrameFeaturesFlagsEnum.OVERDRAW_ENABLED);
                    this.featuresEnabled.add(FrameFeaturesFlagsEnum.FRAME_CAPTURE_ENABLED);
                    break;
                }
                case SHADERMAP_ENABLED: {
                    this.featuresEnabled.add(FrameFeaturesFlagsEnum.SHADER_MAP_ENABLED);
                    this.featuresEnabled.add(FrameFeaturesFlagsEnum.FRAME_CAPTURE_ENABLED);
                    break;
                }
                default: {
                    assert (false) : "Unexpected modify state : " + currentFrameCommand;
                    break;
                }
            }
        }
    }
}

