/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.io.live;

import com.arm.mgd.core.target.io.live.IInterceptorCommand;
import com.arm.mgd.core.target.io.live.IPerProcessInterceptorCommand;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public enum PerProcessInterceptorCommand implements IPerProcessInterceptorCommand
{
    DISABLE_FILMSTRIP(IInterceptorCommand.Command.SET_FILMSTRIP, PerProcessCommandParameter.DISABLE),
    DISABLE_SEND_OUTPUT_BUFFERS(IInterceptorCommand.Command.SET_OUTPUT_BUFFER_SENDING, PerProcessCommandParameter.DISABLE),
    ENABLE_FILMSTRIP(IInterceptorCommand.Command.SET_FILMSTRIP, PerProcessCommandParameter.ENABLE),
    ENABLE_SEND_OUTPUT_BUFFERS(IInterceptorCommand.Command.SET_OUTPUT_BUFFER_SENDING, PerProcessCommandParameter.ENABLE),
    END_FRAME_REPLAY(IInterceptorCommand.Command.END_FRAME_REPLAY, null),
    FRAME_CAPTURE(IInterceptorCommand.Command.CAPTURE_FRAME, null),
    FRAME_REPLAY(IInterceptorCommand.Command.ENTER_FRAME_REPLAY, PerProcessCommandParameter.REPLAY_NO_CAPTURE),
    FRAME_REPLAY_CAPTURE(IInterceptorCommand.Command.ENTER_FRAME_REPLAY, PerProcessCommandParameter.REPLAY_CAPTURE),
    FRAME_STEP(IInterceptorCommand.Command.STEP_TO_NEXT_FRAME_END, null),
    RESUME_APPLICATION(IInterceptorCommand.Command.RESUME, null),
    PAUSE_NOW(IInterceptorCommand.Command.PAUSE_ON_NEXT_CALL, null),
    PAUSE_ON_FRAME_END(IInterceptorCommand.Command.PAUSE_ON_FRAME_END, null),
    DISCONNECT(IInterceptorCommand.Command.DISCONNECT, null),
    ADD_DEFERRED_COMMAND(IInterceptorCommand.Command.DEFERRED_COMMAND, PerProcessCommandParameter.ADD),
    REMOVE_DEFERRED_COMMAND(IInterceptorCommand.Command.DEFERRED_COMMAND, PerProcessCommandParameter.REMOVE),
    HOST_ATTACHED(IInterceptorCommand.Command.HOST_ATTACH_STATE_CHANGED, PerProcessCommandParameter.ATTACHED),
    HOST_DETACHED(IInterceptorCommand.Command.HOST_ATTACH_STATE_CHANGED, PerProcessCommandParameter.DETACHED),
    ENABLE_HEADLESS_MODE(IInterceptorCommand.Command.SET_HEADLESS_MODE, PerProcessCommandParameter.ENABLE);

    private final @NonNull IInterceptorCommand.Command command;
    private final @Nullable IInterceptorCommand.ICommandParameter parameter;

    private PerProcessInterceptorCommand(IInterceptorCommand.Command command, IInterceptorCommand.ICommandParameter parameter) {
        this.command = command;
        this.parameter = parameter;
    }

    @Override
    public IInterceptorCommand.Command getCommand() {
        return this.command;
    }

    @Override
    public @Nullable IInterceptorCommand.ICommandParameter getParameter() {
        return this.parameter;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Per process interceptor command ");
        sb.append(this.command.name()).append(" ");
        if (this.parameter instanceof Enum) {
            sb.append(((Enum)((Object)this.parameter)).name());
        } else if (this.parameter != null) {
            sb.append(this.parameter.toString());
        } else {
            sb.append("<null parameter>");
        }
        return sb.toString();
    }

    public static enum PerProcessCommandParameter implements IInterceptorCommand.ICommandParameter
    {
        ENABLE,
        DISABLE,
        ADD,
        REMOVE,
        ATTACHED,
        DETACHED,
        REPLAY_NO_CAPTURE,
        REPLAY_CAPTURE;

    }
}

