/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.io.connection;

import com.arm.mgd.core.target.data.FeatureAuthorisationRequestEventAttachment;
import com.arm.mgd.core.target.io.ProcessConfig;
import com.arm.mgd.core.target.io.connection.AbstractConnection;
import com.arm.mgd.core.target.io.connection.IInboundConnection;
import com.arm.mgd.core.target.io.connection.IOutboundConnection;
import com.arm.mgd.core.target.io.connection.ProtocolVersionException;
import com.arm.mgd.core.target.io.live.IDaemonCommand;
import com.arm.mgd.core.target.io.live.IInterceptorCommand;
import com.arm.mgd.core.target.io.live.IPerProcessInterceptorCommand;
import com.arm.mgd.core.target.io.live.PerProcessInterceptorCommand;
import com.arm.mgd.core.target.marshaller.AbstractFunctionCallMarshaller;
import com.arm.mgd.core.target.marshaller.AbstractLiveTraceMarshaller;
import com.arm.mgd.core.target.marshaller.IUnmarshallerDataSink;
import com.arm.mgd.core.target.marshaller.bytedata.IByteStore;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.logging.Level;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class LiveConnection
extends AbstractConnection
implements IOutboundConnection {
    private final @NonNull Socket socket;
    private final @NonNull String connectionName;

    public static @NonNull LiveConnection createLiveConnection(@NonNull Socket socket, @NonNull IUnmarshallerDataSink dataSink, @NonNull IInboundConnection.IConnectionStatusChangeListener statusChangeListener, @NonNull IByteStore byteStore, @NonNull String connectionName) throws IOException, ProtocolVersionException {
        socket.setSoTimeout(1000);
        boolean onlyAcceptCurrentVersion = !connectionName.equals("DaemonConnection");
        AbstractFunctionCallMarshaller unmarshaller = AbstractConnection.getMarshallerFromStreamHeader((InputStream)NullUtils.neverNull((Object)socket.getInputStream()), onlyAcceptCurrentVersion);
        assert (unmarshaller instanceof AbstractLiveTraceMarshaller);
        socket.setSoTimeout(0);
        return new LiveConnection(socket, dataSink, unmarshaller, statusChangeListener, byteStore, connectionName);
    }

    private LiveConnection(@NonNull Socket socket, @NonNull IUnmarshallerDataSink dataSink, @NonNull AbstractFunctionCallMarshaller unmarshaller, @NonNull IInboundConnection.IConnectionStatusChangeListener statusChangeListener, @NonNull IByteStore byteStore, @NonNull String connectionName) throws IOException {
        super(AbstractFunctionCallMarshaller.DataSource.LIVE_STREAM, dataSink, (InputStream)NullUtils.neverNull((Object)socket.getInputStream()), unmarshaller, statusChangeListener, byteStore);
        this.socket = socket;
        this.connectionName = connectionName;
    }

    @Override
    public @NonNull String getConnectionName() {
        return this.connectionName;
    }

    @Override
    public @NonNull OutputStream getOutputStream() throws IOException {
        return (OutputStream)NullUtils.neverNull((Object)this.socket.getOutputStream());
    }

    public SocketAddress getSocketAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    @Override
    public void sendCommand(IDaemonCommand command) throws IOException {
        this.dispatchCommand(0, command);
    }

    @Override
    public void sendCommand(int processID, IPerProcessInterceptorCommand command) throws IOException {
        this.dispatchCommand(processID, command);
    }

    @Override
    public void sendDeferredCommand(int processID, @NonNull IPerProcessInterceptorCommand command, @NonNull IPerProcessInterceptorCommand attachmentCommand, int frameNumber) throws IOException {
        assert (processID != 0);
        this.dispatchDeferredCommand(processID, command, attachmentCommand, frameNumber);
    }

    @Override
    public void sendFeatureAuthorisationCommand(@NonNull FeatureAuthorisationRequestEventAttachment attachment, boolean allow, @Nullable String reason) throws IOException {
        this.dispatchFeatureAuthorisationCommand(0, attachment, allow, reason);
    }

    @Override
    public void sendProcessConfigurationCommand(int processID, @NonNull ProcessConfig processConfig) throws IOException {
        this.getUnmarshaller().writeInterceptorConfigurationToStream(this.getOutputStream(), processID, processConfig.interceptorConfig);
        PerProcessInterceptorCommand command = processConfig.outputBuffersEnabled ? PerProcessInterceptorCommand.ENABLE_SEND_OUTPUT_BUFFERS : PerProcessInterceptorCommand.DISABLE_SEND_OUTPUT_BUFFERS;
        this.dispatchCommand(processID, command);
    }

    @Override
    protected void closeInputStream() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            CoreLogging.severeNoAssert(this, e, "Unable to close target socket");
        }
    }

    @Override
    protected boolean readContent() throws IOException {
        if (!super.readContent()) {
            CoreLogging.userMessage(this, Level.WARNING, "The connection to the interceptor daemon on the target was lost. Make sure that the network connection to your target device is still working and that the interceptor daemon is still running.");
            return false;
        }
        return true;
    }

    @Override
    public final @NonNull AbstractLiveTraceMarshaller getUnmarshaller() {
        return (AbstractLiveTraceMarshaller)super.getUnmarshaller();
    }

    private void dispatchDeferredCommand(int processID, @NonNull IPerProcessInterceptorCommand command, @NonNull IPerProcessInterceptorCommand attachmentCommand, int frameNumber) throws IOException {
        this.getUnmarshaller().writeDeferredCommandToStream(this.getOutputStream(), processID, command, attachmentCommand, frameNumber);
    }

    private void dispatchFeatureAuthorisationCommand(int processID, @NonNull FeatureAuthorisationRequestEventAttachment attachment, boolean allow, @Nullable String reason) throws IOException {
        this.getUnmarshaller().writeFeatureAuthorisationCommandToStream(this.getOutputStream(), processID, attachment, allow, reason);
    }

    private void dispatchCommand(int processID, @NonNull IInterceptorCommand command) throws IOException {
        this.getUnmarshaller().writeCommandToStream(this.getOutputStream(), processID, command);
    }
}

