/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.io.connection;

import com.arm.mgd.core.target.io.connection.ProtocolVersionException;
import com.arm.mgd.utils.NullUtils;
import com.arm.mgd.utils.VersionProperties;
import org.eclipse.jdt.annotation.NonNull;

public class InvalidProtocolVersionException
extends ProtocolVersionException {
    private static final long serialVersionUID = 8567518007776403732L;

    public InvalidProtocolVersionException(@NonNull String acceptedFileVersions, @NonNull String acceptedLiveVersions, @NonNull String version, boolean live) {
        super(InvalidProtocolVersionException.getMessage(acceptedFileVersions, acceptedLiveVersions, version, live));
    }

    private static @NonNull String getMessage(@NonNull String acceptedFileVersions, @NonNull String acceptedLiveVersions, @NonNull String version, boolean live) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!live) {
            stringBuilder.append("The version of the trace file you are trying to open is not supported.").append(System.lineSeparator()).append(System.lineSeparator()).append("This version of ").append(VersionProperties.FULL_PRODUCT_NAME).append(" accepts the following trace version(s): ").append(acceptedFileVersions).append(".").append(System.lineSeparator()).append("The version of the trace file you are trying to open is: ").append(version).append(".");
        } else {
            stringBuilder.append("The version of the ").append(VersionProperties.FULL_PRODUCT_NAME).append(" daemon you are trying to connect to is not supported.").append(System.lineSeparator()).append(System.lineSeparator()).append("This version of ").append(VersionProperties.FULL_PRODUCT_NAME).append(" accepts the following daemon version(s): ").append(acceptedLiveVersions).append(".").append(System.lineSeparator()).append("The version of the ").append(VersionProperties.FULL_PRODUCT_NAME).append(" daemon you are trying to connect to is: ").append(version).append(".");
        }
        return NullUtils.buildString((StringBuilder)stringBuilder);
    }
}

