/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.io.connection;

import com.arm.mgd.core.target.io.connection.AbstractConnection;
import com.arm.mgd.core.target.io.connection.IInboundConnection;
import com.arm.mgd.core.target.io.connection.ProtocolVersionException;
import com.arm.mgd.core.target.marshaller.AbstractFunctionCallMarshaller;
import com.arm.mgd.core.target.marshaller.IUnmarshallerDataSink;
import com.arm.mgd.core.target.marshaller.bytedata.IByteStore;
import com.arm.mgd.utils.NullUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jdt.annotation.NonNull;

public final class FileConnection
extends AbstractConnection {
    private final @NonNull File file;

    public static @NonNull FileConnection createFileConnection(@NonNull File file, @NonNull IUnmarshallerDataSink dataSink, @NonNull IInboundConnection.IConnectionStatusChangeListener statusChangeListener, @NonNull IByteStore byteStore) throws IOException, ProtocolVersionException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        try {
            AbstractFunctionCallMarshaller unmarshaller = AbstractConnection.getMarshallerFromStreamHeader(bis, false);
            return new FileConnection(file, dataSink, (InputStream)bis, unmarshaller, statusChangeListener, byteStore);
        }
        catch (Exception e) {
            try {
                bis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ProtocolVersionException) {
                throw (ProtocolVersionException)e;
            }
            throw new IOException("Could not create file connection", e);
        }
    }

    private FileConnection(@NonNull File file, @NonNull IUnmarshallerDataSink dataSink, @NonNull InputStream inputStream, @NonNull AbstractFunctionCallMarshaller unmarshaller, @NonNull IInboundConnection.IConnectionStatusChangeListener statusChangeListener, @NonNull IByteStore byteStore) {
        super(AbstractFunctionCallMarshaller.DataSource.FILE_STREAM, dataSink, inputStream, unmarshaller, statusChangeListener, byteStore);
        this.file = file;
    }

    @Override
    public @NonNull String getConnectionName() {
        return (String)NullUtils.neverNull((Object)this.file.getName());
    }

    public @NonNull File getFile() {
        return this.file;
    }
}

