/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.io.connection;

import com.arm.mgd.core.target.io.connection.ConnectionStatus;
import com.arm.mgd.core.target.io.connection.EmptyProtocolVersionException;
import com.arm.mgd.core.target.io.connection.IInboundConnection;
import com.arm.mgd.core.target.io.connection.InvalidProtocolVersionException;
import com.arm.mgd.core.target.io.connection.ProtocolVersionException;
import com.arm.mgd.core.target.marshaller.AbstractFunctionCallMarshaller;
import com.arm.mgd.core.target.marshaller.AbstractLiveTraceMarshaller;
import com.arm.mgd.core.target.marshaller.FunctionCallMarshallerCurrent;
import com.arm.mgd.core.target.marshaller.IUnmarshallerDataSink;
import com.arm.mgd.core.target.marshaller.binary_v2.FunctionCallMarshallerD001;
import com.arm.mgd.core.target.marshaller.binary_v2.FunctionCallMarshallerD005;
import com.arm.mgd.core.target.marshaller.bytedata.IByteStore;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.IMemoryListener;
import com.arm.mgd.core.util.MemoryMonitor;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractConnection
implements IInboundConnection {
    public static final int DAEMON_VERSION_TO_SUPPORT_KILL_COMMAND = 27;
    public static final @NonNull String DAEMON_CONNECTION_NAME_FOR_KILL_COMMAND = "DaemonConnection";
    private static final Map<String, Class<? extends AbstractFunctionCallMarshaller>> MARSHALLER_CLASSES = new TreeMap<String, Class<? extends AbstractFunctionCallMarshaller>>(){
        {
            this.put("C002", FunctionCallMarshallerD001.class);
            this.put("C003", FunctionCallMarshallerD001.class);
            this.put("C004", FunctionCallMarshallerD001.class);
            this.put("C005", FunctionCallMarshallerD005.class);
            this.put("C006", FunctionCallMarshallerD005.class);
            this.put("C007", FunctionCallMarshallerD005.class);
            this.put("C008", FunctionCallMarshallerD005.class);
            this.put("C009", FunctionCallMarshallerD005.class);
            this.put("C013", FunctionCallMarshallerD005.class);
            this.put("C015", FunctionCallMarshallerD005.class);
            this.put("C016", FunctionCallMarshallerD005.class);
            this.put("C023", FunctionCallMarshallerD005.class);
            this.put("C024", FunctionCallMarshallerD005.class);
            this.put("C027", FunctionCallMarshallerD005.class);
            this.put("D001", FunctionCallMarshallerD001.class);
            this.put("D002", FunctionCallMarshallerD001.class);
            this.put("D003", FunctionCallMarshallerD001.class);
            this.put("D004", FunctionCallMarshallerD001.class);
            this.put("D005", FunctionCallMarshallerD005.class);
            this.put("D006", FunctionCallMarshallerD005.class);
            this.put("D007", FunctionCallMarshallerD005.class);
            this.put("D008", FunctionCallMarshallerD005.class);
            this.put("D009", FunctionCallMarshallerD005.class);
            this.put("D010", FunctionCallMarshallerD005.class);
            this.put("D011", FunctionCallMarshallerD005.class);
            this.put("D012", FunctionCallMarshallerD005.class);
            this.put("D013", FunctionCallMarshallerD005.class);
            this.put("D014", FunctionCallMarshallerD005.class);
            this.put("D015", FunctionCallMarshallerD005.class);
            this.put("D016", FunctionCallMarshallerD005.class);
            this.put("D017", FunctionCallMarshallerD005.class);
            this.put("D018", FunctionCallMarshallerD005.class);
            this.put("D019", FunctionCallMarshallerD005.class);
            this.put("D020", FunctionCallMarshallerD005.class);
            this.put("D021", FunctionCallMarshallerD005.class);
            this.put("D022", FunctionCallMarshallerD005.class);
            this.put("D023", FunctionCallMarshallerD005.class);
            this.put("D024", FunctionCallMarshallerD005.class);
            this.put("D025", FunctionCallMarshallerD005.class);
            this.put("D026", FunctionCallMarshallerD005.class);
            this.put("D027", FunctionCallMarshallerD005.class);
            this.put("D028", FunctionCallMarshallerD005.class);
            this.put("D029", FunctionCallMarshallerD005.class);
            this.put("D030", FunctionCallMarshallerD005.class);
            this.put("D031", FunctionCallMarshallerD005.class);
            this.put("D032", FunctionCallMarshallerD005.class);
            this.put("D033", FunctionCallMarshallerD005.class);
            this.put("D034", FunctionCallMarshallerD005.class);
            this.put("D035", FunctionCallMarshallerD005.class);
        }
    };
    private static final int VERSION_LENGTH = 4;
    private @NonNull ConnectionStatus connectionStatus;
    private @NonNull IUnmarshallerDataSink dataSink;
    private final @NonNull InputStream inputStream;
    private final @NonNull Thread readerThread;
    private final @NonNull IInboundConnection.IConnectionStatusChangeListener statusChangeListener;
    private final @NonNull AbstractFunctionCallMarshaller unmarshaller;
    private final @NonNull AbstractFunctionCallMarshaller.DataSource dataSource;
    private final @NonNull IByteStore byteStore;

    private static @NonNull String getAcceptedTraceVersions() {
        assert (MARSHALLER_CLASSES.size() > 0);
        StringJoiner stringJoiner = new StringJoiner(", ");
        for (String version : MARSHALLER_CLASSES.keySet()) {
            if (version.startsWith("C")) continue;
            stringJoiner.add(version);
        }
        return (String)NullUtils.neverNull((Object)stringJoiner.toString());
    }

    public static @NonNull AbstractFunctionCallMarshaller getMarshallerFromStreamHeader(@NonNull InputStream inputStream, boolean onlyAcceptCurrentVersion) throws ProtocolVersionException {
        byte[] bytes = new byte[4];
        try {
            int bytesRead = inputStream.read(bytes);
            if (bytesRead == -1) {
                String error = "No input received when trying to read the trace version.";
                if (onlyAcceptCurrentVersion) {
                    error = String.valueOf(error) + " Is the interceptor daemon running?";
                }
                throw new EmptyProtocolVersionException(error);
            }
            if (bytesRead != 4) {
                throw new ProtocolVersionException("Input received when trying to read the trace version is too short.");
            }
        }
        catch (IOException e) {
            throw new ProtocolVersionException(e);
        }
        String traceVersion = new String(bytes, StandardCharsets.US_ASCII).trim();
        Class<? extends AbstractFunctionCallMarshaller> marshallersClass = AbstractConnection.getMarshallerClass(onlyAcceptCurrentVersion, traceVersion);
        if (marshallersClass == null) {
            throw new InvalidProtocolVersionException(AbstractConnection.getAcceptedTraceVersions(), AbstractLiveTraceMarshaller.getAcceptedLiveTargetVersion(), (String)NullUtils.neverNull((Object)traceVersion), onlyAcceptCurrentVersion);
        }
        try {
            return (AbstractFunctionCallMarshaller)NullUtils.neverNull((Object)marshallersClass.getConstructor(String.class).newInstance(traceVersion));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProtocolVersionException(e);
        }
    }

    private static Class<? extends AbstractFunctionCallMarshaller> getMarshallerClass(boolean onlyAcceptCurrentVersion, String traceVersion) {
        if (onlyAcceptCurrentVersion) {
            if (AbstractLiveTraceMarshaller.isAcceptedLiveTargetVersion(traceVersion)) {
                return FunctionCallMarshallerCurrent.class;
            }
            return null;
        }
        return MARSHALLER_CLASSES.get(traceVersion);
    }

    protected AbstractConnection(@NonNull AbstractFunctionCallMarshaller.DataSource dataSource, @NonNull IUnmarshallerDataSink dataSink, @NonNull InputStream inputStream, @NonNull AbstractFunctionCallMarshaller unmarshaller, @NonNull IInboundConnection.IConnectionStatusChangeListener statusChangeListener, @NonNull IByteStore byteStore) {
        this.dataSource = dataSource;
        this.dataSink = dataSink;
        this.inputStream = inputStream;
        this.unmarshaller = unmarshaller;
        this.statusChangeListener = statusChangeListener;
        this.connectionStatus = ConnectionStatus.NOT_STARTED;
        this.byteStore = byteStore;
        this.readerThread = new Thread("TargetReader"){

            /*
             * Loose catch block
             */
            @Override
            public void run() {
                block12: {
                    if (AbstractConnection.this.getConnectionStatus() == ConnectionStatus.NOT_STARTED) {
                        try {
                            try {
                                AbstractConnection.this.setConnectionStatus(ConnectionStatus.UNMARSHALLING);
                                if (AbstractConnection.this.readContent()) {
                                    AbstractConnection.this.setConnectionStatus(ConnectionStatus.TERMINATED_SUCCESS);
                                } else {
                                    AbstractConnection.this.setConnectionStatus(ConnectionStatus.TERMINATED_ERROR);
                                }
                            }
                            catch (SocketException e) {
                                CoreLogging.info(AbstractConnection.this, e, null);
                                AbstractConnection.this.setConnectionStatus(ConnectionStatus.TERMINATED_SUCCESS);
                                AbstractConnection.this.closeInputStream();
                            }
                            catch (IOException e) {
                                CoreLogging.severe(AbstractConnection.this, e, "Unable to read trace data stream " + AbstractConnection.this.getConnectionName());
                                AbstractConnection.this.setConnectionStatus(ConnectionStatus.TERMINATED_ERROR);
                                AbstractConnection.this.closeInputStream();
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                CoreLogging.severe(AbstractConnection.this, "Failed while reading trace data stream " + AbstractConnection.this.getConnectionName());
                                AbstractConnection.this.setConnectionStatus(ConnectionStatus.TERMINATED_ERROR);
                                AbstractConnection.this.closeInputStream();
                                break block12;
                                {
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                }
                            }
                        }
                        finally {
                            AbstractConnection.this.closeInputStream();
                        }
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void closeConnection() {
        ConnectionStatus status;
        AbstractConnection abstractConnection = this;
        synchronized (abstractConnection) {
            status = this.getConnectionStatus();
            if (status == ConnectionStatus.NOT_STARTED) {
                this.setConnectionStatus(ConnectionStatus.TERMINATED_SUCCESS);
                this.closeInputStream();
            }
        }
        if (status == ConnectionStatus.UNMARSHALLING) {
            this.unmarshaller.requestStop();
            try {
                try {
                    this.readerThread.join(500L);
                }
                catch (InterruptedException e) {
                    CoreLogging.severe(this, e, "Failed to terminate read");
                    this.closeInputStream();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.getConnectionStatus() != ConnectionStatus.TERMINATED_SUCCESS) {
                        this.setConnectionStatus(ConnectionStatus.TERMINATED_ERROR);
                    }
                }
            }
            finally {
                this.closeInputStream();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                if (this.getConnectionStatus() != ConnectionStatus.TERMINATED_SUCCESS) {
                    this.setConnectionStatus(ConnectionStatus.TERMINATED_ERROR);
                }
            }
        }
    }

    @Override
    public final long getBytesRead() {
        return this.unmarshaller.getNumberOfBytesRead();
    }

    @Override
    public final synchronized @NonNull ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    @Override
    public final @NonNull String getCoreLoggingSourceKey() {
        return (String)NullUtils.neverNull((Object)this.toString());
    }

    @Override
    public AbstractFunctionCallMarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    @Override
    public final @NonNull String getUnmarshallerVersion() {
        return this.unmarshaller.getTargetVersion();
    }

    @Override
    public boolean isClosed() {
        ConnectionStatus status = this.getConnectionStatus();
        return status == ConnectionStatus.TERMINATED_ERROR || status == ConnectionStatus.TERMINATED_SUCCESS;
    }

    @Override
    public final synchronized void start() throws IllegalStateException {
        if (this.connectionStatus == ConnectionStatus.NOT_STARTED) {
            try {
                this.readerThread.start();
            }
            catch (IllegalThreadStateException e) {
                throw new IllegalStateException(e);
            }
        } else {
            throw new IllegalStateException("Connection already started");
        }
    }

    @Override
    public final void waitForUnmarshallerToComplete() {
        try {
            this.readerThread.join();
        }
        catch (InterruptedException e) {
            CoreLogging.severe(this, e, "Joining reading thread interrupted");
        }
    }

    protected void closeInputStream() {
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            CoreLogging.severeNoAssert(this, e, "Unable to close target input stream");
        }
    }

    protected boolean readContent() throws IOException {
        boolean stopRequested = false;
        IMemoryListener lowMemoryListener = new IMemoryListener(){

            @Override
            public void onMemoryBelowWarningLevel(int remainingMemoryMb) {
                AbstractConnection.this.unmarshaller.requestStop();
                CoreLogging.severe(null, "Trace processing halted due to lack of memory");
            }

            @Override
            public void onMemoryBelowCriticalLevel(int remainingMemoryMb) {
                AbstractConnection.this.unmarshaller.requestStop();
                CoreLogging.severe(null, "Trace processing halted due to critical lack of memory");
            }
        };
        MemoryMonitor.getInstance().addListener(lowMemoryListener);
        try {
            try {
                stopRequested = this.unmarshaller.unmarshall(this.dataSource, this.inputStream, this.dataSink, this.byteStore);
            }
            catch (OutOfMemoryError e) {
                CoreLogging.severe(this, "Out of memory detected whilst reading trace data");
                MemoryMonitor.getInstance().removeListener(lowMemoryListener);
            }
        }
        finally {
            MemoryMonitor.getInstance().removeListener(lowMemoryListener);
        }
        return stopRequested;
    }

    private synchronized void setConnectionStatus(@NonNull ConnectionStatus connectionStatus) {
        assert (this.connectionStatus.canChangeTo(connectionStatus)) : "Invalid state transition (" + (Object)((Object)this.connectionStatus) + " -> " + (Object)((Object)connectionStatus) + ")";
        ConnectionStatus oldStatus = this.connectionStatus;
        this.connectionStatus = connectionStatus;
        if (connectionStatus == ConnectionStatus.TERMINATED_ERROR || connectionStatus == ConnectionStatus.TERMINATED_SUCCESS) {
            this.dataSink.setInputComplete();
        }
        if (oldStatus != connectionStatus) {
            this.statusChangeListener.onConnectionStatusChanged(this, oldStatus, connectionStatus);
        }
    }
}

