/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.io;

import com.arm.mgd.core.pb.v2.MgdProtosV2;
import com.arm.mgd.core.target.data.AsynchronousFunctionAttachment;
import com.arm.mgd.core.target.data.AsynchronousFunctionData;
import com.arm.mgd.core.target.data.BookmarkModel;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.IProcessTargetEventListener;
import com.arm.mgd.core.target.data.InterceptorTarget;
import com.arm.mgd.core.target.data.ProcessEndedTargetEventAttachment;
import com.arm.mgd.core.target.data.ProcessStartedTargetEventAttachment;
import com.arm.mgd.core.target.data.TargetEvent;
import com.arm.mgd.core.target.data.TargetEventAttachment;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.interceptorconfig.InterceptorConfig;
import com.arm.mgd.core.target.data.interceptorconfig.InterceptorConfigEventAttachment;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.target.io.ProcessConfig;
import com.arm.mgd.core.target.io.ProcessConfigHistory;
import com.arm.mgd.core.target.io.ProcessConfigPreset;
import com.arm.mgd.core.target.marshaller.IMarshallerDataSource;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallDescriptor;
import com.arm.mgd.core.target.marshaller.utils.Timestamp;
import com.arm.mgd.core.util.ICoreLoggingSource;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.core.util.ListenerList;
import com.arm.mgd.lightweight.model.TracedProcess;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ProcessTarget
implements ICoreLoggingSource,
IMarshallerDataSource {
    private final @NonNull TraceDataModel model;
    private final @NonNull AbstractTarget parentTarget;
    private @Nullable ProcessEndedTargetEventAttachment processEndedAttachment;
    private final int processID;
    private @Nullable ProcessStartedTargetEventAttachment processStartedAttachment;
    private final ListenerList<IProcessTargetEventListener> targetEventListeners = new ListenerList();
    private final @NonNull TracedProcess lightweightProcess;
    private final @NonNull List<@NonNull ProcessConfigHistory> processConfigHistory = new ArrayList<ProcessConfigHistory>();
    private final @NonNull Set< @NonNull MgdProtosV2.ProductFeatures> authorisationFeatures = new HashSet<MgdProtosV2.ProductFeatures>();

    public ProcessTarget(@NonNull AbstractTarget parentTarget, int processID, boolean alreadyStarted, @NonNull String processName) {
        this.parentTarget = parentTarget;
        this.processID = processID;
        this.lightweightProcess = parentTarget.getLightweightModel().getTracedProcess(processID);
        this.model = new TraceDataModel(this, (String)NullUtils.neverNull((Object)String.format("%s: %s", parentTarget.getConnection().getConnectionName(), processName)), processID, alreadyStarted, processName, parentTarget.getConnection().getUnmarshallerVersion());
        this.processConfigHistory.add(new ProcessConfigHistory(ProcessConfigPreset.LEGACY.getConfig(), 0));
    }

    public @NonNull TracedProcess getLightweightProcess() {
        return this.lightweightProcess;
    }

    public void addTargetEventListeners(IProcessTargetEventListener listener) {
        this.targetEventListeners.add(listener);
    }

    public void close(@NonNull ICoreProgressMonitor iCoreProgressMonitor) {
        this.model.close(iCoreProgressMonitor);
        this.targetEventListeners.clear();
    }

    public void dispatchTargetEvent(@NonNull TargetEvent targetEvent) {
        TargetEventAttachment attachment;
        @Nullable FunctionCall lastFunctionProcessed = this.lightweightProcess.getProcessModelProcessor().getLastCompletedFunctionCall();
        if (lastFunctionProcessed != null) {
            this.model.waitForFunctionToBeProcessed(lastFunctionProcessed);
        }
        if (targetEvent.getEventType() == TargetEvent.TargetEventType.PROCESS_STARTED && this.processStartedAttachment == null) {
            attachment = targetEvent.findAttachment(ProcessStartedTargetEventAttachment.class);
            this.processStartedAttachment = attachment;
        } else if (targetEvent.getEventType() == TargetEvent.TargetEventType.PROCESS_FINISHED && this.processEndedAttachment == null) {
            attachment = targetEvent.findAttachment(ProcessEndedTargetEventAttachment.class);
            this.processEndedAttachment = attachment;
        } else if (targetEvent.getEventType() == TargetEvent.TargetEventType.ASYNCHRONOUS_FUNCTION_CALL_DATA) {
            attachment = targetEvent.findAttachment(AsynchronousFunctionData.class);
            assert (attachment != null) : "No AsynchronousFunctionData attachment with ASYNCHRONOUS_FUNCTION_CALL_DATA event";
            @Nullable AsynchronousFunctionAttachment assetData = ((AsynchronousFunctionData)attachment).getAttachment();
            Integer functionCallUID = NullUtils.intValueOf((int)((AsynchronousFunctionData)attachment).getFunctionCallUid());
            if (assetData != null) {
                this.model.getAsynchronousDataModel().addAsynchronousAssetData(functionCallUID, assetData);
            }
        } else if (targetEvent.getEventType() == TargetEvent.TargetEventType.SEND_OUTPUT_BUFFERS_DISABLED) {
            this.onChangedOutputBuffersConfiguration(lastFunctionProcessed, false);
        } else if (targetEvent.getEventType() == TargetEvent.TargetEventType.SEND_OUTPUT_BUFFERS_ENABLED) {
            this.onChangedOutputBuffersConfiguration(lastFunctionProcessed, true);
        } else if (targetEvent.getEventType() == TargetEvent.TargetEventType.INTERCEPTOR_CONFIGURATION && (attachment = targetEvent.findAttachment(InterceptorConfigEventAttachment.class)) != null) {
            this.onChangedInterceptorConfiguration(lastFunctionProcessed, ((InterceptorConfigEventAttachment)attachment).getInterceptorConfig());
        }
        for (IProcessTargetEventListener listener : this.targetEventListeners) {
            listener.onTargetEventReceived(this, targetEvent);
        }
    }

    @Override
    public @NonNull FunctionCall getCallItem(int i) throws IndexOutOfBoundsException {
        return this.model.getCallItem(i);
    }

    @Override
    public String getCoreLoggingSourceKey() {
        return this.parentTarget.getCoreLoggingSourceKey();
    }

    @Override
    public int getFunctionCallCount() {
        return this.model.count();
    }

    public @NonNull TraceDataModel getModel() {
        return this.model;
    }

    public @NonNull AbstractTarget getParentTarget() {
        return this.parentTarget;
    }

    @Override
    public ProcessEndedTargetEventAttachment getProcessEndedAttachment() {
        if (this.processEndedAttachment != null) {
            return new ProcessEndedTargetEventAttachment(this.processID, this.processEndedAttachment.getTimestamp(), false);
        }
        long timestamp = this.model.count() > 0 ? this.model.getCallItem(this.model.count() - 1).getTimestampStop() : 0L;
        return new ProcessEndedTargetEventAttachment(this.processID, new Timestamp(timestamp), false);
    }

    @Override
    public int getProcessID() {
        return this.processID;
    }

    @Override
    public ProcessStartedTargetEventAttachment getProcessStartedAttachment() {
        if (this.processStartedAttachment != null) {
            return this.processStartedAttachment;
        }
        long timestamp = this.model.count() > 0 ? this.model.getCallItem(this.model.count() - 1).getTimestampStart() : 0L;
        return new ProcessStartedTargetEventAttachment(this.processID, this.model.getProcessName(), new Timestamp(timestamp), InterceptorTarget.INTERCEPTOR_TARGET_UNKNOWN, (Boolean)this.model.processStartedBeforeTracing());
    }

    @Override
    public boolean requiresProcessHeaderForMarshalling() {
        return true;
    }

    public void setIsActive(boolean isActive) {
    }

    public @NonNull FunctionCall appendNewFunctionCall(@NonNull FunctionCallDescriptor functionCallDescriptor) {
        FunctionCall functionCall = this.model.createFunction(functionCallDescriptor);
        this.model.insertIntoProcessorChain(functionCall);
        String notes = functionCallDescriptor.getNotes();
        if (notes != null) {
            this.model.getBookmarkModel().addBookmark(functionCall, notes);
        }
        return functionCall;
    }

    @Override
    public boolean hasAsynchronousAssetData() {
        return this.model.getAsynchronousDataModel().hasAsynchronousAssetData();
    }

    @Override
    public @NonNull Map<Integer, List<@NonNull AsynchronousFunctionAttachment>> getAsynchronousAssetData() {
        return this.model.getAsynchronousDataModel().getAsynchronousAssetData();
    }

    @Override
    public @Nullable String getNoteForCallItem(int i) {
        BookmarkModel.Bookmark b = this.model.getBookmarkModel().getBookmark(this.getCallItem(i));
        return b != null ? b.getNote() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull ProcessConfigHistory.Range getProcessConfigsAtCallItem(@NonNull FunctionCall functionCall) {
        assert (functionCall.getModel().getParentProcessTarget() == this);
        int index = functionCall.getIndex();
        List<ProcessConfigHistory> list = this.processConfigHistory;
        synchronized (list) {
            assert (this.processConfigHistory.size() > 0);
            int startIndex = -1;
            if (index == -1) {
                startIndex = 0;
            } else {
                int i = this.processConfigHistory.size() - 1;
                while (i >= 0) {
                    ProcessConfigHistory configHistory = this.processConfigHistory.get(i);
                    if (configHistory.functionCallIndexFromInclusive <= index) {
                        startIndex = i;
                        break;
                    }
                    --i;
                }
            }
            if (startIndex == -1) {
                throw new AssertionError((Object)("Invalid FunctionCall index: " + functionCall.getIndex()));
            }
            assert (startIndex < this.processConfigHistory.size());
            int endIndex = startIndex + 1;
            @NonNull ProcessConfigHistory start = this.processConfigHistory.get(startIndex);
            @Nullable ProcessConfigHistory end = this.processConfigHistory.size() == endIndex ? null : this.processConfigHistory.get(endIndex);
            return new ProcessConfigHistory.Range(start, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @NonNull ProcessConfigHistory getMostRecentProcessConfig() {
        List<ProcessConfigHistory> list = this.processConfigHistory;
        synchronized (list) {
            assert (this.processConfigHistory.size() > 0);
            return this.processConfigHistory.get(this.processConfigHistory.size() - 1);
        }
    }

    private void onChangedOutputBuffersConfiguration(@Nullable FunctionCall lastFunctionProcessed, boolean enabled) {
        ProcessConfigHistory mostRecentConfig = this.getMostRecentProcessConfig();
        ProcessConfig newConfig = new ProcessConfig(mostRecentConfig.processConfig.interceptorConfig, enabled);
        this.updateProcessConfigurationHistory(lastFunctionProcessed, newConfig);
    }

    private void onChangedInterceptorConfiguration(@Nullable FunctionCall lastFunctionProcessed, @NonNull InterceptorConfig config) {
        ProcessConfigHistory mostRecentConfig = this.getMostRecentProcessConfig();
        ProcessConfig newConfig = new ProcessConfig(config, mostRecentConfig.processConfig.outputBuffersEnabled);
        this.updateProcessConfigurationHistory(lastFunctionProcessed, newConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProcessConfigurationHistory(@Nullable FunctionCall lastFunctionProcessed, @NonNull ProcessConfig newConfig) {
        int configIndex = lastFunctionProcessed == null ? 0 : lastFunctionProcessed.getIndex() + 1;
        ProcessConfigHistory newConfigHistory = new ProcessConfigHistory(newConfig, configIndex);
        ProcessConfigHistory mostRecentConfig = this.getMostRecentProcessConfig();
        List<ProcessConfigHistory> list = this.processConfigHistory;
        synchronized (list) {
            if (!mostRecentConfig.processConfig.equals(newConfig)) {
                if (mostRecentConfig.functionCallIndexFromInclusive == configIndex) {
                    this.processConfigHistory.set(this.processConfigHistory.size() - 1, newConfigHistory);
                } else {
                    this.processConfigHistory.add(newConfigHistory);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull List<@NonNull ProcessConfigHistory> getInterceptorConfigHistory() {
        List<ProcessConfigHistory> list = this.processConfigHistory;
        synchronized (list) {
            return new ArrayList<ProcessConfigHistory>(this.processConfigHistory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull Set< @NonNull MgdProtosV2.ProductFeatures> getAuthorisationFeatures() {
        Set<MgdProtosV2.ProductFeatures> set = this.authorisationFeatures;
        synchronized (set) {
            return new HashSet<MgdProtosV2.ProductFeatures>(this.authorisationFeatures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthorisationFeature( @NonNull MgdProtosV2.ProductFeatures feature) {
        Set<MgdProtosV2.ProductFeatures> set = this.authorisationFeatures;
        synchronized (set) {
            this.authorisationFeatures.add(feature);
        }
    }
}

