/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.io;

import com.arm.mgd.core.target.data.interceptorconfig.ISelectableResource;
import com.arm.mgd.core.target.data.interceptorconfig.InterceptorConfig;
import com.arm.mgd.core.target.data.interceptorconfig.cl.ClConfig;
import com.arm.mgd.core.target.data.interceptorconfig.cl.ClResource;
import com.arm.mgd.core.target.data.interceptorconfig.gles.GlesConfig;
import com.arm.mgd.core.target.data.interceptorconfig.gles.GlesResource;
import com.arm.mgd.core.target.data.interceptorconfig.vulkan.VulkanConfig;
import com.arm.mgd.core.target.data.interceptorconfig.vulkan.VulkanResource;
import com.arm.mgd.core.target.io.ProcessConfig;
import com.arm.mgd.utils.NullUtils;
import com.arm.mgd.utils.VersionProperties;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ProcessConfigPreset {
    public static final @NonNull ProcessConfigPreset FUNCTIONS_ONLY;
    public static final @NonNull ProcessConfigPreset BALANCED;
    public static final @NonNull ProcessConfigPreset LEGACY;
    public static final @NonNull ProcessConfigPreset FULL_TRACE;
    public static final @NonNull ProcessConfigPreset EVERYTHING;
    public static final @NonNull List<@NonNull ProcessConfigPreset> PRESETS;
    private final @NonNull ProcessConfig config;
    private final @NonNull String name;
    private final @NonNull String description;

    static {
        ArrayList<@NonNull ProcessConfigPreset> presets = new ArrayList<ProcessConfigPreset>();
        ProcessConfig config = new ProcessConfig(InterceptorConfig.NOTHING_SELECTED, false);
        FUNCTIONS_ONLY = new ProcessConfigPreset(config, "Functions Only", "Trace function calls only. Fastest and smallest trace size.");
        presets.add(FUNCTIONS_ONLY);
        ArrayList<@NonNull ClResource> clResources = new ArrayList<ClResource>();
        clResources.add(new ClResource(ISelectableResource.SelectableResourceType.CL_PROGRAM_ASSET_SOURCE, true));
        ArrayList<@NonNull GlesResource> glResources = new ArrayList<GlesResource>();
        glResources.add(new GlesResource(ISelectableResource.SelectableResourceType.GL_SHADER_ASSET_SOURCE, true));
        glResources.add(new GlesResource(ISelectableResource.SelectableResourceType.GL_SHADER_ASSET_UNIFORM, true));
        ClConfig clConfig = new ClConfig(clResources, false);
        GlesConfig glesConfig = new GlesConfig(glResources, false);
        ProcessConfig config2 = new ProcessConfig(new InterceptorConfig(clConfig, glesConfig, VulkanConfig.NOTHING_SELECTED), false);
        BALANCED = new ProcessConfigPreset(config2, "Balanced", "A good balance between tracing speed, trace size, and information.");
        presets.add(BALANCED);
        clResources = new ArrayList();
        clResources.add(new ClResource(ISelectableResource.SelectableResourceType.CL_PROGRAM_ASSET_SOURCE, true));
        clResources.add(new ClResource(ISelectableResource.SelectableResourceType.CL_EXPLICIT_MEMORY_ASSET, true));
        glResources = new ArrayList();
        glResources.add(new GlesResource(ISelectableResource.SelectableResourceType.GL_SHADER_ASSET_SOURCE, true));
        glResources.add(new GlesResource(ISelectableResource.SelectableResourceType.GL_SHADER_ASSET_BINARY, true));
        glResources.add(new GlesResource(ISelectableResource.SelectableResourceType.GL_SHADER_ASSET_UNIFORM, true));
        glResources.add(new GlesResource(ISelectableResource.SelectableResourceType.GL_TEXTURE_ASSET, true));
        glResources.add(new GlesResource(ISelectableResource.SelectableResourceType.GL_EXPLICIT_BUFFER_ASSET, true));
        ArrayList<@NonNull VulkanResource> vkResources = new ArrayList<VulkanResource>();
        vkResources.add(new VulkanResource(ISelectableResource.SelectableResourceType.VK_SHADER_ASSET_BINARY, true));
        ClConfig clConfig2 = new ClConfig(clResources, false);
        GlesConfig glesConfig2 = new GlesConfig(glResources, false);
        VulkanConfig vulkanConfig = new VulkanConfig(vkResources, false);
        ProcessConfig config3 = new ProcessConfig(new InterceptorConfig(clConfig2, glesConfig2, vulkanConfig), false);
        LEGACY = new ProcessConfigPreset(config3, "Legacy", "The default trace configuration used in older versions of " + VersionProperties.FULL_PRODUCT_NAME + ".");
        presets.add(LEGACY);
        config = new ProcessConfig(InterceptorConfig.EVERYTHING_SELECTED, false);
        FULL_TRACE = new ProcessConfigPreset(config, "Full Trace", "Trace all supported inputs. Can be slow for complex applications.");
        presets.add(FULL_TRACE);
        config = new ProcessConfig(InterceptorConfig.EVERYTHING_SELECTED, true);
        EVERYTHING = new ProcessConfigPreset(config, "Everything", "Trace all supported inputs and outputs. Slowest and creates the largest traces.");
        presets.add(EVERYTHING);
        PRESETS = NullUtils.unmodifiableList(presets);
    }

    private ProcessConfigPreset(@NonNull ProcessConfig config, @NonNull String name, @NonNull String description) {
        this.config = config;
        this.name = name;
        this.description = description;
    }

    public @NonNull ProcessConfig getConfig() {
        return this.config;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull String getDescription() {
        return this.description;
    }

    public static @Nullable ProcessConfigPreset getPresetForConfig(@NonNull ProcessConfig config) {
        for (ProcessConfigPreset preset : PRESETS) {
            if (!preset.config.equals(config)) continue;
            return preset;
        }
        return null;
    }

    public static @NonNull String getPresetNameForConfig(@NonNull ProcessConfig config) {
        @Nullable ProcessConfigPreset preset = ProcessConfigPreset.getPresetForConfig(config);
        return preset != null ? preset.name : "Custom";
    }
}

