/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.io;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.authorisation.AuthorisationManager;
import com.arm.mgd.core.authorisation.Feature;
import com.arm.mgd.core.authorisation.FeatureAuthorisation;
import com.arm.mgd.core.target.data.FeatureAuthorisationRequestEventAttachment;
import com.arm.mgd.core.target.data.InterceptorExecutionState;
import com.arm.mgd.core.target.io.AbstractLiveTarget;
import com.arm.mgd.core.target.io.IProcessConfigChangeListener;
import com.arm.mgd.core.target.io.LiveProcessTarget;
import com.arm.mgd.core.target.io.LiveTargetGlobalState;
import com.arm.mgd.core.target.io.ProcessConfig;
import com.arm.mgd.core.target.io.ProcessTarget;
import com.arm.mgd.core.target.io.connection.ConnectionStatus;
import com.arm.mgd.core.target.io.connection.EmptyProtocolVersionException;
import com.arm.mgd.core.target.io.connection.LiveConnection;
import com.arm.mgd.core.target.io.connection.ProtocolVersionException;
import com.arm.mgd.core.target.io.live.GlobalInterceptorCommand;
import com.arm.mgd.core.target.io.live.InterceptorCaptureState;
import com.arm.mgd.core.target.io.live.InterceptorStateListener;
import com.arm.mgd.core.target.io.live.ModifyStateInterceptorCommand;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.core.util.ListenerList;
import com.arm.mgd.core.util.WeakListenerSet;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class LiveTarget
extends AbstractLiveTarget {
    public static final @NonNull String DEFAULT_ADDRESS = "127.0.0.1";
    public static final int DEFAULT_PORT = 5002;
    public static final @NonNull String OLDER_VERSION_OF_DAEMON_ALREADY_RUNNING_MESSAGE = "An older version of the GA Daemon is already running on the device. Please kill the daemon process and try again";
    private final @NonNull Map<@NonNull LiveTargetGlobalState, Object> globalStateItemValues = new HashMap<LiveTargetGlobalState, Object>(){
        {
            LiveTargetGlobalState[] liveTargetGlobalStateArray = LiveTargetGlobalState.values();
            int n = liveTargetGlobalStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                LiveTargetGlobalState globalStateItem = liveTargetGlobalStateArray[n2];
                this.put(globalStateItem, globalStateItem.defaultValue);
                ++n2;
            }
        }
    };
    private final @NonNull ListenerList<InterceptorStateListener> interceptorStateListeners = new ListenerList();
    private final @NonNull WeakListenerSet<@NonNull IProcessConfigChangeListener> configListeners = new WeakListenerSet();
    private final @NonNull AtomicReference<@NonNull ProcessConfig> defaultProcessConfig;

    public LiveTarget(@NonNull Socket targetSocket, @NonNull String connectionName, @NonNull ProcessConfig defaultProcessConfig) throws IOException, ProtocolVersionException {
        super((dataSink, statusChangeListener, byteStore) -> LiveConnection.createLiveConnection(targetSocket, dataSink, statusChangeListener, byteStore, connectionName), connectionName);
        this.defaultProcessConfig = new AtomicReference<ProcessConfig>(defaultProcessConfig);
    }

    public static @NonNull LiveTarget get(@NonNull SocketAddress targetAddress, int numRetries, int connectTimeoutMS, int retryDelayMS, @NonNull String connectionName, @NonNull ProcessConfig defaultProcessConfig) throws IOException, ProtocolVersionException {
        int connectRetriesLeft = numRetries;
        LiveTarget liveTarget = null;
        while (true) {
            @NonNull Socket targetSocket = new Socket();
            try {
                try {
                    targetSocket.connect(targetAddress, connectTimeoutMS);
                    liveTarget = new LiveTarget(targetSocket, connectionName, defaultProcessConfig);
                }
                catch (Throwable t) {
                    try {
                        targetSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw t;
                }
            }
            catch (SocketTimeoutException e) {
                throw e;
            }
            catch (EmptyProtocolVersionException | IOException e) {
                if (--connectRetriesLeft == 0) {
                    throw e;
                }
                try {
                    Thread.sleep(retryDelayMS);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
        return (LiveTarget)NullUtils.neverNull((Object)liveTarget);
    }

    public void addInterceptorStateListener(InterceptorStateListener interceptorStateListener) {
        this.interceptorStateListeners.add(interceptorStateListener);
    }

    @Override
    public void dispatchInterceptorCaptureStateChanged(@NonNull InterceptorCaptureState oldState, @NonNull InterceptorCaptureState newState) {
        for (InterceptorStateListener listener : this.interceptorStateListeners) {
            listener.onInterceptorCaptureStateChanged(oldState, newState);
        }
    }

    @Override
    public void dispatchInterceptorExecutionStateChanged(@NonNull InterceptorExecutionState oldState, @NonNull InterceptorExecutionState newState, int processID) {
        for (InterceptorStateListener listener : this.interceptorStateListeners) {
            listener.onInterceptorStateChanged(oldState, newState, processID);
        }
    }

    @Override
    public void dispatchModifyStateValueChanged(ModifyStateInterceptorCommand oldValue, ModifyStateInterceptorCommand newValue) {
        for (InterceptorStateListener listener : this.interceptorStateListeners) {
            listener.onTargetModifyStateChanged(newValue);
        }
    }

    @Override
    public @NonNull LiveConnection getLiveConnection() {
        return (LiveConnection)this.getConnection();
    }

    @Override
    public boolean getRequestEnabled(@NonNull LiveTargetGlobalState globalStateItem) {
        Object value = this.globalStateItemValues.get((Object)globalStateItem);
        if (value == null) {
            value = globalStateItem.defaultValue;
        }
        assert (value instanceof Boolean);
        return (Boolean)value;
    }

    @Override
    public boolean isConnectionActive() {
        return this.getLiveConnection().getConnectionStatus() == ConnectionStatus.UNMARSHALLING;
    }

    @Override
    public boolean isLiveTarget() {
        return true;
    }

    public void sendPauseCommand() throws IOException {
        if (this.isConnectionActive()) {
            this.getLiveConnection().sendCommand(GlobalInterceptorCommand.PAUSE_ALL_ON_FRAME_END);
        }
    }

    public boolean killDaemonAndCloseConnection() throws IOException {
        @NonNull LiveConnection connection = this.getLiveConnection();
        @NonNull ConnectionStatus connectionStatus = connection.getConnectionStatus();
        if (connectionStatus == ConnectionStatus.TERMINATED_SUCCESS || connectionStatus == ConnectionStatus.TERMINATED_ERROR) {
            return false;
        }
        boolean killCommandSupported = this.isKillCommandSupported();
        try {
            try {
                if (killCommandSupported) {
                    connection.sendCommand(GlobalInterceptorCommand.KILL_DAEMON);
                }
            }
            catch (IOException e) {
                throw new IOException("An exception was thrown while attempting to kill the GA daemon process on the target.");
            }
        }
        finally {
            connection.closeConnection();
            this.close(ICoreProgressMonitor.NULL_MONITOR);
        }
        return killCommandSupported;
    }

    public void sendRestoreAllToDefault() {
        this.forEachProcessTarget(processTarget -> {
            LiveProcessTarget lpt = (LiveProcessTarget)processTarget;
            lpt.enableModifyStateMode(ModifyStateInterceptorCommand.ALL_DISABLED);
            lpt.disableFilmstripMode();
            lpt.resume();
        });
    }

    @Override
    public void setRequestEnabled(@NonNull LiveTargetGlobalState globalStateItem, boolean enabled) {
        this.globalStateItemValues.put(globalStateItem, enabled);
    }

    @Override
    protected @NonNull String getNoVersionErrorMessage() {
        return "No data was received from the target. Check that the daemon is running.";
    }

    @Override
    protected @NonNull ProcessTarget newProcessTargetType(int processID, boolean alreadyStarted, @NonNull String processName) {
        return new LiveProcessTarget(this, processID, alreadyStarted, processName, this.defaultProcessConfig.get());
    }

    @Override
    protected void onTracingStarted(ProcessTarget newProcessTarget) {
        LiveProcessTarget processTarget = (LiveProcessTarget)newProcessTarget;
        processTarget.initializeDefaultsOnProcessStarted();
        this.hasTracingStarted = true;
    }

    @Override
    protected void setTracingStarted() {
    }

    @Override
    public void handleAuthorisationRequest(@NonNull FeatureAuthorisationRequestEventAttachment attachment) {
        @Nullable AuthorisationManager authManager = CoreInstance.getAuthorisationManager();
        assert (authManager != null);
        CompletableFuture<FeatureAuthorisation> authorisationFuture = authManager.getAuthorisation(Feature.getCoreFeature(attachment.getFeature()));
        if (this.isConnectionActive()) {
            authorisationFuture.thenAccept(authorisation -> {
                try {
                    this.sendAuthoriseFeatureCommand(attachment, authorisation.isAuthorised(), authorisation.getReason());
                }
                catch (IOException e) {
                    CoreLogging.severeNoAssert(this, "Authorise feature request failed.");
                }
            });
        }
    }

    private void sendAuthoriseFeatureCommand(@NonNull FeatureAuthorisationRequestEventAttachment attachment, boolean allow, @Nullable String reason) throws IOException {
        this.getLiveConnection().sendFeatureAuthorisationCommand(attachment, allow, reason);
    }

    public void addConfigChangedListener(@NonNull IProcessConfigChangeListener listener) {
        this.configListeners.addListenerAsWeakReference(listener);
    }

    public void removeConfigChangedListener(@NonNull IProcessConfigChangeListener listener) {
        this.configListeners.removeWeakReference(listener);
    }

    public @NonNull ProcessConfig getProcessConfig() {
        return this.defaultProcessConfig.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessConfig(@NonNull ProcessConfig newConfig) {
        AtomicReference<ProcessConfig> atomicReference = this.defaultProcessConfig;
        synchronized (atomicReference) {
            ProcessConfig oldConfig = this.defaultProcessConfig.getAndSet(newConfig);
            this.configListeners.notifyWeakListeners(listener -> listener.onConfigChanged(this, oldConfig, newConfig));
        }
    }
}

