/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.io;

import com.arm.mgd.core.target.data.AutomatedTraceCommand;
import com.arm.mgd.core.target.data.DeferredCommandItem;
import com.arm.mgd.core.target.data.ExecutionStateTargetEventAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.InterceptorExecutionState;
import com.arm.mgd.core.target.data.TargetEvent;
import com.arm.mgd.core.target.io.AbstractLiveTarget;
import com.arm.mgd.core.target.io.IProcessConfigChangeListener;
import com.arm.mgd.core.target.io.LiveTargetGlobalState;
import com.arm.mgd.core.target.io.ProcessConfig;
import com.arm.mgd.core.target.io.ProcessConfigHistory;
import com.arm.mgd.core.target.io.ProcessTarget;
import com.arm.mgd.core.target.io.connection.IOutboundConnection;
import com.arm.mgd.core.target.io.live.InterceptorCaptureState;
import com.arm.mgd.core.target.io.live.ModifyStateInterceptorCommand;
import com.arm.mgd.core.target.io.live.PerProcessInterceptorCommand;
import com.arm.mgd.core.target.marshaller.AbstractLiveTraceMarshaller;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.core.util.UnsupportedTypeException;
import com.arm.mgd.core.util.WeakListenerSet;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jdt.annotation.NonNull;

public class LiveProcessTarget
extends ProcessTarget {
    private @NonNull InterceptorCaptureState captureState = InterceptorCaptureState.NOT_CAPTURING;
    private final @NonNull IOutboundConnection connection;
    private @NonNull ModifyStateInterceptorCommand currentFeature = ModifyStateInterceptorCommand.ALL_DISABLED;
    private boolean filmstripModeEnabled = false;
    private @NonNull InterceptorExecutionState interceptorExecutionState = InterceptorExecutionState.RUNNING;
    private final @NonNull AbstractLiveTarget liveTarget;
    private final @NonNull WeakListenerSet<@NonNull IProcessConfigChangeListener> configListeners = new WeakListenerSet();
    private final @NonNull AtomicReference<@NonNull ProcessConfigHistory> currentProcessConfig;

    public LiveProcessTarget(@NonNull AbstractLiveTarget parentTarget, int processID, boolean alreadyStarted, @NonNull String processName, @NonNull ProcessConfig initialProcessConfig) {
        super(parentTarget, processID, alreadyStarted, processName);
        this.liveTarget = parentTarget;
        this.connection = parentTarget.getLiveConnection();
        this.currentProcessConfig = new AtomicReference<ProcessConfigHistory>(new ProcessConfigHistory(initialProcessConfig, 0));
    }

    public boolean canAttachAndDetach() {
        return this.getModel().containsOnlyGLESAndEGL() && this.isProcessConnectionActive();
    }

    public boolean canCaptureFrame() {
        return this.isProcessConnectionActive() && !this.isDetached() && !this.isWaitingOrCapturingFrame();
    }

    public boolean canEnableModifyStateFeature(ModifyStateInterceptorCommand feature) {
        switch (feature) {
            case OVERDRAW_ENABLED: 
            case SHADERMAP_ENABLED: {
                return this.isProcessConnectionActive() && !this.isDetached() && this.getModel().containsOnlyGLESAndEGL();
            }
            case FRAGMENTCOUNT_ENABLED: {
                return this.isProcessConnectionActive() && !this.isDetached() && this.getModel().containsOnlyGLESAndEGL() && !this.getModel().processStartedBeforeTracing();
            }
            case ALL_DISABLED: {
                return true;
            }
            case ALLATTACHMENTSMODE_ENABLED: {
                return this.isProcessConnectionActive() && !this.isDetached() && this.getModel().containsOnlyGLESAndEGL();
            }
        }
        assert (false) : "Unexpected modify state command: " + feature;
        return false;
    }

    public boolean canPause() {
        return this.isProcessConnectionActive() && !this.isDetached() && !this.isSuspended();
    }

    public boolean canResume() {
        return this.isProcessConnectionActive() && !this.isDetached() && this.isSuspended();
    }

    public void captureFrame() {
        try {
            this.sendFrameCaptureCommand();
        }
        catch (IOException e) {
            CoreLogging.severeNoAssert(this, "Frame capture request failed");
        }
    }

    public void captureReplayFrame() {
        try {
            this.sendReplayFrameCaptureCommand();
        }
        catch (IOException e) {
            CoreLogging.severeNoAssert(this, "Frame capture+replay request failed");
        }
    }

    @Override
    public void close(@NonNull ICoreProgressMonitor iCoreProgressMonitor) {
        super.close(iCoreProgressMonitor);
        this.changeInterceptorExecutionStateTo(InterceptorExecutionState.DISCONNECTED);
    }

    private static @NonNull PerProcessInterceptorCommand getInterceptorCommandForState(@NonNull LiveTargetGlobalState state, boolean enabled) {
        if (enabled) {
            switch (state) {
                case FILMSTRIP_MODE: {
                    return PerProcessInterceptorCommand.ENABLE_FILMSTRIP;
                }
            }
        } else {
            switch (state) {
                case FILMSTRIP_MODE: {
                    return PerProcessInterceptorCommand.DISABLE_FILMSTRIP;
                }
            }
        }
        throw new AssertionError((Object)state);
    }

    private void setTargetMode(@NonNull LiveTargetGlobalState state, boolean enabled) {
        this.liveTarget.setRequestEnabled(state, enabled);
        @NonNull PerProcessInterceptorCommand command = LiveProcessTarget.getInterceptorCommandForState(state, enabled);
        try {
            this.connection.sendCommand(this.getProcessID(), command);
        }
        catch (IOException e) {
            CoreLogging.severeNoAssert(this, command + " request failed");
        }
    }

    public void disableFilmstripMode() {
        this.setTargetMode(LiveTargetGlobalState.FILMSTRIP_MODE, false);
    }

    @Override
    public void dispatchTargetEvent(@NonNull TargetEvent targetEvent) {
        TargetEvent.TargetEventType eventType = targetEvent.getEventType();
        if (eventType != null) {
            this.processTargetEvent(targetEvent);
        }
        super.dispatchTargetEvent(targetEvent);
    }

    public void enableFilmstripMode() {
        this.setTargetMode(LiveTargetGlobalState.FILMSTRIP_MODE, true);
    }

    public void enableModifyStateMode(@NonNull ModifyStateInterceptorCommand newState) {
        switch (newState) {
            case ALL_DISABLED: 
            case ALLATTACHMENTSMODE_ENABLED: 
            case FRAGMENTCOUNT_ENABLED: 
            case OVERDRAW_ENABLED: 
            case SHADERMAP_ENABLED: {
                try {
                    ModifyStateInterceptorCommand oldCurrentFeature = this.currentFeature;
                    this.connection.sendCommand(this.getProcessID(), newState);
                    this.currentFeature = newState;
                    this.changeModifyStateTo(oldCurrentFeature, this.currentFeature);
                }
                catch (IOException e) {
                    CoreLogging.severeNoAssert(this, newState + " request failed");
                }
                break;
            }
            default: {
                assert (false) : "Unexpected command in modify state mode: " + newState;
                break;
            }
        }
    }

    public @NonNull InterceptorCaptureState getInterceptorCaptureState() {
        return this.captureState;
    }

    public InterceptorExecutionState getInterceptorExecutionState() {
        return this.interceptorExecutionState;
    }

    public void initializeDefaultsOnProcessStarted() {
        this.changeInterceptorExecutionStateTo(InterceptorExecutionState.RUNNING);
        if (this.canEnableModifyStateFeature(this.currentFeature)) {
            this.enableModifyStateMode(this.currentFeature);
        }
        if (this.liveTarget.getRequestEnabled(LiveTargetGlobalState.FILMSTRIP_MODE)) {
            this.enableFilmstripMode();
        } else {
            this.disableFilmstripMode();
        }
        this.setProcessConfig(this.currentProcessConfig.get().processConfig);
    }

    public boolean isCapturingFrame() {
        return this.captureState == InterceptorCaptureState.CAPTURING_FRAME;
    }

    public boolean isDetached() {
        return this.getInterceptorExecutionState() == InterceptorExecutionState.DETACHED;
    }

    public boolean isDisconnected() {
        return this.interceptorExecutionState == InterceptorExecutionState.DISCONNECTED;
    }

    public boolean isFilmstripModeEnabled() {
        return this.filmstripModeEnabled;
    }

    public boolean isProcessConnectionActive() {
        return this.liveTarget.isConnectionActive() && !this.isDisconnected();
    }

    public boolean isSuspended() {
        return this.interceptorExecutionState == InterceptorExecutionState.PAUSED || this.interceptorExecutionState == InterceptorExecutionState.PAUSED_ON_FRAME;
    }

    public boolean isWaitingOrCapturingFrame() {
        return this.captureState == InterceptorCaptureState.CAPTURE_PENDING || this.captureState == InterceptorCaptureState.CAPTURING_FRAME;
    }

    public void resume() {
        try {
            this.sendResumeCommand();
        }
        catch (IOException e) {
            CoreLogging.severeNoAssert(this, "Resume request failed");
        }
    }

    public void sendAddAutomatedTraceCommand(AutomatedTraceCommand command) throws IOException {
        this.sendDeferredCommand(PerProcessInterceptorCommand.ADD_DEFERRED_COMMAND, command);
    }

    public void sendDeleteAutomatedTraceCommand(AutomatedTraceCommand command) throws IOException {
        this.sendDeferredCommand(PerProcessInterceptorCommand.REMOVE_DEFERRED_COMMAND, command);
    }

    public void sendEndFrameReplayCommand() throws IOException {
        this.connection.sendCommand(this.getProcessID(), PerProcessInterceptorCommand.END_FRAME_REPLAY);
    }

    public void sendFrameCaptureCommand() throws IOException {
        this.connection.sendCommand(this.getProcessID(), PerProcessInterceptorCommand.FRAME_CAPTURE);
    }

    public void sendPauseCommand() throws IOException {
        if (this.interceptorExecutionState == InterceptorExecutionState.PAUSE_ON_FRAME_PENDING) {
            this.connection.sendCommand(this.getProcessID(), PerProcessInterceptorCommand.PAUSE_NOW);
        } else {
            this.connection.sendCommand(this.getProcessID(), PerProcessInterceptorCommand.PAUSE_ON_FRAME_END);
        }
    }

    public void addConfigChangedListener(@NonNull IProcessConfigChangeListener listener) {
        this.configListeners.addListenerAsWeakReference(listener);
    }

    public void removeConfigChangedListener(@NonNull IProcessConfigChangeListener listener) {
        this.configListeners.removeWeakReference(listener);
    }

    public @NonNull ProcessConfigHistory getProcessConfig() {
        return this.currentProcessConfig.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessConfig(@NonNull ProcessConfig newConfig) {
        AtomicReference<ProcessConfigHistory> atomicReference = this.currentProcessConfig;
        synchronized (atomicReference) {
            ProcessConfigHistory oldConfig = this.currentProcessConfig.getAndSet(new ProcessConfigHistory(newConfig, this.getFunctionCallCount()));
            this.configListeners.notifyWeakListeners(listener -> listener.onConfigChanged(this, processConfigHistory.processConfig, newConfig));
            try {
                this.connection.sendProcessConfigurationCommand(this.getProcessID(), newConfig);
            }
            catch (IOException e) {
                CoreLogging.severeNoAssert(this, "Send process configuration request failed");
            }
        }
    }

    public void sendReplayFrameCaptureCommand() throws IOException {
        this.connection.sendCommand(this.getProcessID(), PerProcessInterceptorCommand.FRAME_REPLAY_CAPTURE);
    }

    public void sendReplayFrameCommand() throws IOException {
        this.connection.sendCommand(this.getProcessID(), PerProcessInterceptorCommand.FRAME_REPLAY);
    }

    public void sendReplayFunctions(FunctionCall[] theFrameFunctions, @NonNull ICoreProgressMonitor monitor) throws IOException, UnsupportedTypeException {
        AbstractLiveTraceMarshaller marshaller = (AbstractLiveTraceMarshaller)this.connection.getUnmarshaller();
        marshaller.marshallFunctionCalls(monitor, this.getProcessID(), theFrameFunctions, this.connection.getOutputStream());
    }

    public void sendResumeCommand() throws IOException {
        this.connection.sendCommand(this.getProcessID(), PerProcessInterceptorCommand.RESUME_APPLICATION);
    }

    public void sendStepCommand() throws IOException {
        this.connection.sendCommand(this.getProcessID(), PerProcessInterceptorCommand.FRAME_STEP);
    }

    public void setAttached(boolean attach) throws IOException {
        this.connection.sendCommand(this.getProcessID(), attach ? PerProcessInterceptorCommand.HOST_ATTACHED : PerProcessInterceptorCommand.HOST_DETACHED);
    }

    @Override
    public void setIsActive(boolean isActive) {
        if (isActive) {
            this.changeInterceptorExecutionStateTo(this.interceptorExecutionState);
            this.changeModifyStateTo(this.currentFeature, this.currentFeature);
        }
    }

    public void step() {
        try {
            this.sendStepCommand();
        }
        catch (IOException e) {
            CoreLogging.severeNoAssert(this, "Step request failed");
        }
    }

    private void changeCaptureStateTo(@NonNull InterceptorCaptureState newState) {
        InterceptorCaptureState oldState = this.captureState;
        this.captureState = newState;
        this.liveTarget.dispatchInterceptorCaptureStateChanged(oldState, newState);
    }

    private void changeInterceptorExecutionStateTo(@NonNull InterceptorExecutionState newState) {
        InterceptorExecutionState oldState = this.interceptorExecutionState;
        this.interceptorExecutionState = newState;
        this.liveTarget.dispatchInterceptorExecutionStateChanged(oldState, newState, this.getProcessID());
        if (newState != oldState && newState == InterceptorExecutionState.DETACHED) {
            this.getModel().onTracingDetachedEvent();
        } else if (oldState == InterceptorExecutionState.DETACHED && newState != oldState && newState != InterceptorExecutionState.DISCONNECTED) {
            this.getModel().onTracingReattachedEvent();
        }
    }

    private void changeModifyStateTo(@NonNull ModifyStateInterceptorCommand oldValue, @NonNull ModifyStateInterceptorCommand newValue) {
        this.liveTarget.dispatchModifyStateValueChanged(oldValue, newValue);
    }

    private void processTargetEvent(@NonNull TargetEvent targetEvent) {
        ExecutionStateTargetEventAttachment executionStateAttachment = targetEvent.findAttachment(ExecutionStateTargetEventAttachment.class);
        switch (targetEvent.getEventType()) {
            case FRAME_CAPTURE_WAITING: {
                this.changeCaptureStateTo(InterceptorCaptureState.CAPTURE_PENDING);
                break;
            }
            case FRAME_CAPTURE_STARTED: {
                this.changeCaptureStateTo(InterceptorCaptureState.CAPTURING_FRAME);
                break;
            }
            case FRAME_CAPTURE_FINISHED: {
                this.changeCaptureStateTo(InterceptorCaptureState.NOT_CAPTURING);
                break;
            }
            case TRACING_SUSPENDED: {
                if (executionStateAttachment != null) {
                    this.updateInterceptorExecutionState(executionStateAttachment);
                    break;
                }
                this.changeInterceptorExecutionStateTo(InterceptorExecutionState.PAUSED_ON_FRAME);
                break;
            }
            case END_FRAME_REPLAY: {
                if (executionStateAttachment != null) {
                    this.updateInterceptorExecutionState(executionStateAttachment);
                    break;
                }
                this.changeInterceptorExecutionStateTo(InterceptorExecutionState.PAUSED_ON_FRAME);
                break;
            }
            case TRACING_RESUMED: {
                if (executionStateAttachment != null) {
                    this.updateInterceptorExecutionState(executionStateAttachment);
                    break;
                }
                if (!this.isCapturingFrame()) {
                    this.changeInterceptorExecutionStateTo(InterceptorExecutionState.RUNNING);
                    break;
                }
                this.changeInterceptorExecutionStateTo(InterceptorExecutionState.STEPPING);
                break;
            }
            case FILMSTRIP_MODE_DISABLED: {
                this.filmstripModeEnabled = false;
                this.changeInterceptorExecutionStateTo(this.interceptorExecutionState);
                break;
            }
            case FILMSTRIP_MODE_ENABLED: {
                this.filmstripModeEnabled = true;
                this.changeInterceptorExecutionStateTo(this.interceptorExecutionState);
                break;
            }
            case PROCESS_FINISHED: {
                this.changeInterceptorExecutionStateTo(InterceptorExecutionState.DISCONNECTED);
                break;
            }
            case INTERCEPTOR_EXECUTION_STATE_UPDATE: {
                this.updateInterceptorExecutionState(targetEvent.findAttachment(ExecutionStateTargetEventAttachment.class));
                break;
            }
        }
    }

    private void sendDeferredCommand(@NonNull PerProcessInterceptorCommand deferredCommand, AutomatedTraceCommand command) throws IOException {
        List<DeferredCommandItem> commandBundle = command.getCommandType().getCommandBundle();
        for (DeferredCommandItem deferredCommandItem : commandBundle) {
            this.connection.sendDeferredCommand(this.getProcessID(), deferredCommand, deferredCommandItem.getCommand(), command.getFrameNumber() + deferredCommandItem.getOffset());
        }
    }

    private void updateInterceptorExecutionState(ExecutionStateTargetEventAttachment attachment) {
        if (attachment == null) {
            return;
        }
        this.changeInterceptorExecutionStateTo(attachment.getCurrentInterceptorExecutionState());
    }
}

