/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.io;

import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.target.io.ProcessTarget;
import com.arm.mgd.core.target.marshaller.FunctionCallMarshallerCurrent;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.core.util.UnsupportedTypeException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

public class FunctionCallWriter {
    public static void write(File file, AbstractTarget target, ICoreProgressMonitor monitor) throws IOException {
        FunctionCallMarshallerCurrent marshaller = new FunctionCallMarshallerCurrent();
        if (file.exists() && !file.delete()) {
            throw new IOException("Save abandoned: Unable to delete existing file " + file);
        }
        try (PrintStream sOut = new PrintStream(file);){
            sOut.print(marshaller.getTargetVersion());
            marshaller.marshallAuthorisedFeatures(sOut, target);
            marshaller.marshallDeviceInfo(sOut, target);
            IOException exception = target.processTargets(processTargets -> {
                try {
                    for (ProcessTarget processTarget : processTargets) {
                        if (!monitor.isCancelled()) {
                            marshaller.marshallTrace(sOut, processTarget, monitor);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    return e;
                }
                catch (UnsupportedTypeException e) {
                    return new IOException(e.getMessage());
                }
                if (monitor.isCancelled()) {
                    file.delete();
                } else {
                    for (ProcessTarget processTarget : processTargets) {
                        processTarget.getModel().clearModifiedSinceLastSave();
                    }
                }
                return null;
            });
            if (exception != null) {
                throw exception;
            }
        }
    }

    public static void write(File file, AbstractTarget target) throws IOException {
        FunctionCallWriter.write(file, target, ICoreProgressMonitor.NULL_MONITOR);
    }
}

