/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.io;

import com.arm.mgd.core.target.data.FeatureAuthorisationRequestEventAttachment;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.target.io.ProcessTarget;
import com.arm.mgd.core.target.io.connection.FileConnection;
import com.arm.mgd.core.target.io.connection.ProtocolVersionException;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class FileTarget
extends AbstractTarget {
    public FileTarget(@NonNull File inFile) throws IOException, ProtocolVersionException {
        super((dataSink, statusChangeListener, byteStore) -> FileConnection.createFileConnection(inFile, dataSink, statusChangeListener, byteStore), (String)NullUtils.neverNull((Object)inFile.getName()));
    }

    public @NonNull String getFileName() {
        return (String)NullUtils.neverNull((Object)this.getFileConnection().getFile().getName());
    }

    @Override
    public boolean isLiveTarget() {
        return false;
    }

    @Override
    protected @NonNull String getNoVersionErrorMessage() {
        return "Unable to read trace data from file " + this.getFileConnection().getFile().getAbsolutePath() + " (no version information found)";
    }

    @Override
    protected @NonNull ProcessTarget newProcessTargetType(int processID, boolean alreadyStarted, @NonNull String processName) {
        return new ProcessTarget(this, processID, alreadyStarted, processName);
    }

    @Override
    protected void onTracingStarted(@NonNull ProcessTarget processTarget) {
    }

    @Override
    protected void setTracingStarted() {
    }

    private FileConnection getFileConnection() {
        return (FileConnection)this.getConnection();
    }

    @Override
    public void handleAuthorisationRequest(FeatureAuthorisationRequestEventAttachment attachment) {
    }
}

