/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.io;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.authorisation.AuthorisationManager;
import com.arm.mgd.core.authorisation.Feature;
import com.arm.mgd.core.authorisation.FeatureAuthorisation;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.target.data.AuthorisationFeatureEventAttachment;
import com.arm.mgd.core.target.data.DeviceConnectionRequestEventAttachment;
import com.arm.mgd.core.target.data.DeviceInfoEventAttachment;
import com.arm.mgd.core.target.data.FeatureAuthorisationRequestEventAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.ITargetDeviceInfo;
import com.arm.mgd.core.target.data.ProcessEndedTargetEventAttachment;
import com.arm.mgd.core.target.data.ProcessStartedTargetEventAttachment;
import com.arm.mgd.core.target.data.TargetEvent;
import com.arm.mgd.core.target.data.TargetEventAttachment;
import com.arm.mgd.core.target.data.TargetEventDescriptor;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.VersionInfoEventAttachment;
import com.arm.mgd.core.target.io.ITargetEventListener;
import com.arm.mgd.core.target.io.ProcessTarget;
import com.arm.mgd.core.target.io.connection.ConnectionStatus;
import com.arm.mgd.core.target.io.connection.IInboundConnection;
import com.arm.mgd.core.target.io.connection.ProtocolVersionException;
import com.arm.mgd.core.target.marshaller.AbstractLiveTraceMarshaller;
import com.arm.mgd.core.target.marshaller.IUnmarshallerDataSink;
import com.arm.mgd.core.target.marshaller.bytedata.CompressedMemoryMappedByteStore;
import com.arm.mgd.core.target.marshaller.bytedata.IByteStore;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallDescriptor;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreLoggingSource;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.core.util.WeakListenerSet;
import com.arm.mgd.lightweight.LightweightModel;
import com.arm.mgd.utils.NullUtils;
import com.arm.mgd.utils.VersionProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractTarget
implements ICoreLoggingSource,
INavigationElement<AbstractTarget> {
    private static final @NonNull String UNKNOWN_PROCESS_NAME = "<unknown>";
    private static final @NonNull String AUTHORISATION_REASON_IS_MALI_DEVICE = "Authorised by default since it is a Mali device.";
    private static final @NonNull String AUTHORISATION_REASON_UNROOTED_ANDROID = "Unrooted Android devices are allowed by deafult.";
    private final @NonNull IInboundConnection connection;
    private final @NonNull ReentrantReadWriteLock processLock = new ReentrantReadWriteLock();
    private boolean sentMidstreamWarning = false;
    protected boolean hasTracingStarted = false;
    private @Nullable LightweightModel lightweightModel;
    private final @NonNull AtomicReference<@Nullable TraceDataModel> activeModel = new AtomicReference();
    private final @NonNull Map<@NonNull Integer, ProcessTarget> processTargetMap = new LinkedHashMap<Integer, ProcessTarget>();
    private final @NonNull Set<@NonNull ProcessTarget> processTargetsWithFunctionCalls = new HashSet<ProcessTarget>();
    private final @NonNull AtomicBoolean disconnected = new AtomicBoolean(false);
    private final @NonNull AtomicBoolean closed = new AtomicBoolean(false);
    private final @NonNull CompressedMemoryMappedByteStore byteStore;
    private final boolean isKillCommandSupported;
    private final @NonNull IInboundConnection.IConnectionStatusChangeListener statusChangeListener = new IInboundConnection.IConnectionStatusChangeListener(){

        @Override
        public void onConnectionStatusChanged(@NonNull IInboundConnection notUsed, @NonNull ConnectionStatus oldStatus, @NonNull ConnectionStatus newStatus) {
            if (newStatus == ConnectionStatus.UNMARSHALLING && oldStatus == ConnectionStatus.NOT_STARTED) {
                AbstractTarget.this.setTracingStarted();
            }
            if (oldStatus == ConnectionStatus.UNMARSHALLING && newStatus == ConnectionStatus.TERMINATED_SUCCESS || oldStatus == ConnectionStatus.UNMARSHALLING && newStatus == ConnectionStatus.TERMINATED_ERROR) {
                AbstractTarget.this.writeLock(() -> {
                    if (!AbstractTarget.this.isDisconnected()) {
                        AbstractTarget.this.deviceInfo.complete(DeviceInfoEventAttachment.deviceInfoNotAvailable());
                        AbstractTarget.this.isAuthorised.complete(new FeatureAuthorisation(true, AbstractTarget.AUTHORISATION_REASON_IS_MALI_DEVICE, Feature.NON_MALI_DEVICE));
                        AbstractTarget.this.disconnected.set(true);
                        AbstractTarget.this.targetEventListeners.notifyWeakListeners(listener -> listener.onTargetDisconnected(AbstractTarget.this));
                    }
                    return null;
                });
            }
        }
    };
    private final @NonNull WeakListenerSet<@NonNull ITargetEventListener> targetEventListeners = new WeakListenerSet();
    private final @NonNull IUnmarshallerDataSink unmarshallerDataSink = new IUnmarshallerDataSink(){

        @Override
        public void addTargetEvent(@NonNull TargetEventDescriptor targetEventDescriptor) {
            AbstractTarget.this.dispatchTargetEvent(targetEventDescriptor);
        }

        @Override
        public void appendNewFunctionCall(@NonNull FunctionCallDescriptor functionCallDescriptor) {
            AbstractTarget.this.appendNewFunctionCall(functionCallDescriptor);
        }

        @Override
        public String getCoreLoggingSourceKey() {
            return AbstractTarget.this.getCoreLoggingSourceKey();
        }

        @Override
        public void setInputComplete() {
            AbstractTarget.this.markAllProcessesComplete();
        }
    };
    protected @NonNull CompletableFuture<@NonNull ITargetDeviceInfo> deviceInfo = new CompletableFuture();
    protected @NonNull CompletableFuture<@NonNull FeatureAuthorisation> isAuthorised = new CompletableFuture();
    private boolean nonMaliDeviceAuthorisationRequested = false;
    protected @NonNull Map<Feature, CompletableFuture<@NonNull FeatureAuthorisation>> authorisationFeatures = new HashMap<Feature, CompletableFuture<FeatureAuthorisation>>();

    protected AbstractTarget(@NonNull IInboundConnectionFactory connectionFactory, @NonNull String identifier) throws IOException, ProtocolVersionException {
        this.byteStore = new CompressedMemoryMappedByteStore(identifier);
        this.connection = connectionFactory.create(this.unmarshallerDataSink, this.statusChangeListener, this.byteStore);
        this.lightweightModel = new LightweightModel(this);
        this.isKillCommandSupported = AbstractTarget.isKillCommandSupportedForVersion(this.connection.getUnmarshallerVersion());
    }

    private static boolean isKillCommandSupportedForVersion(@NonNull String unmarshallerVersion) {
        int daemonVersion = Integer.parseInt(unmarshallerVersion.substring(1));
        return daemonVersion >= 27;
    }

    public void addTargetEventListener(@NonNull ITargetEventListener targetListener) {
        this.readLock(() -> {
            if (this.isClosed()) {
                targetListener.onTargetClose(this);
            } else {
                for (ProcessTarget processTarget : this.processTargetsWithFunctionCalls) {
                    targetListener.onNewTargetModelEvent(this, processTarget.getModel());
                }
                if (this.isDisconnected()) {
                    targetListener.onTargetDisconnected(this);
                }
                this.targetEventListeners.addListenerAsWeakReference(targetListener);
            }
            return null;
        });
    }

    public final void asyncRead() {
        this.connection.start();
    }

    public void close(@NonNull ICoreProgressMonitor iCoreProgressMonitor) {
        assert (!this.isClosed());
        this.writeLock(() -> {
            this.disconnected.set(true);
            this.closed.set(true);
            this.activeModel.set(null);
            for (ProcessTarget processTarget : this.processTargetMap.values()) {
                processTarget.close(iCoreProgressMonitor);
            }
            this.processTargetMap.clear();
            this.processTargetsWithFunctionCalls.clear();
            assert (this.lightweightModel != null);
            this.lightweightModel.setIsComplete();
            this.lightweightModel = null;
            this.targetEventListeners.notifyWeakListeners(listener -> listener.onTargetClose(this));
            this.targetEventListeners.clear();
            this.byteStore.dispose();
            return null;
        });
        if (this.nonMaliDeviceAuthorisationRequested) {
            @Nullable AuthorisationManager authManager = CoreInstance.getAuthorisationManager();
            assert (authManager != null);
            authManager.releaseAuthorisation(Feature.NON_MALI_DEVICE);
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isDisconnected() {
        return this.disconnected.get();
    }

    @Override
    public int compareTo(AbstractTarget o) {
        assert (false) : "This function is not implemented";
        return 0;
    }

    public void setActiveModel(@NonNull TraceDataModel newModel) {
        assert (newModel.getParentProcessTarget().getParentTarget() == this);
        this.writeLock(() -> {
            if (this.isClosed()) {
                return null;
            }
            @Nullable TraceDataModel oldModel = this.activeModel.get();
            if (oldModel != newModel) {
                if (oldModel != null) {
                    oldModel.getParentProcessTarget().setIsActive(false);
                }
                newModel.getParentProcessTarget().setIsActive(true);
                this.activeModel.set(newModel);
            }
            return null;
        });
    }

    public @Nullable TraceDataModel getActiveModel() {
        return this.activeModel.get();
    }

    public @Nullable ProcessTarget getActiveProcessTarget() {
        TraceDataModel model = this.getActiveModel();
        return model != null ? model.getParentProcessTarget() : null;
    }

    public @NonNull List<@NonNull TraceDataModel> getModels() {
        return this.processTargets(targets -> {
            ArrayList<@NonNull TraceDataModel> models = new ArrayList<TraceDataModel>(targets.size());
            for (ProcessTarget target : targets) {
                models.add(target.getModel());
            }
            return models;
        });
    }

    @Override
    public @NonNull List<@NonNull TraceDataModel> getChildren() {
        return this.getModels();
    }

    public @NonNull IInboundConnection getConnection() {
        return this.connection;
    }

    @Override
    public final String getCoreLoggingSourceKey() {
        return this.connection.getCoreLoggingSourceKey();
    }

    @Override
    public int getLabelIndex() {
        assert (false) : "This function is not implemented";
        return 0;
    }

    @Override
    public @NonNull String getLabelText() {
        return this.connection.getConnectionName();
    }

    public @NonNull LightweightModel getLightweightModel() {
        if (this.lightweightModel != null) {
            return this.lightweightModel;
        }
        throw new AssertionError((Object)"Target has been closed");
    }

    @Override
    public @NonNull String getLongLabelText() {
        return this.getLabelText();
    }

    public @NonNull IByteStore getByteStore() {
        return this.byteStore;
    }

    public <ReturnType> ReturnType readLock(@NonNull Supplier<ReturnType> supplier) {
        ReentrantReadWriteLock.ReadLock lock = this.processLock.readLock();
        lock.lock();
        try {
            ReturnType ReturnType = supplier.get();
            return ReturnType;
        }
        finally {
            lock.unlock();
        }
    }

    private <ReturnType> ReturnType writeLock(@NonNull Supplier<ReturnType> supplier) {
        ReentrantReadWriteLock.WriteLock lock = this.processLock.writeLock();
        lock.lock();
        try {
            ReturnType ReturnType = supplier.get();
            return ReturnType;
        }
        finally {
            lock.unlock();
        }
    }

    public @Nullable ProcessTarget getProcessTarget(int processID) {
        return this.readLock(() -> this.processTargetMap.get(processID));
    }

    public @Nullable ProcessTarget getFirstConnectedProcessTarget(@NonNull String processName) {
        assert (this.processTargetMap instanceof LinkedHashMap);
        return this.readLock(() -> {
            for (ProcessTarget pt : this.processTargetMap.values()) {
                if (!pt.getModel().getProcessName().equals(processName)) continue;
                return pt;
            }
            return null;
        });
    }

    public int processTargetCount() {
        ReentrantReadWriteLock.ReadLock lock = this.processLock.readLock();
        lock.lock();
        try {
            int n = this.processTargetMap.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public <ReturnType> ReturnType processTargets(Function<Collection<@NonNull ProcessTarget>, ReturnType> functor) {
        return (ReturnType)this.readLock(() -> functor.apply(NullUtils.neverNullCollection(this.processTargetMap.values())));
    }

    public void forEachProcessTarget(@NonNull Consumer<@NonNull ProcessTarget> functor) {
        this.readLock(() -> {
            for (Map.Entry<Integer, ProcessTarget> entry : this.processTargetMap.entrySet()) {
                functor.accept((ProcessTarget)NullUtils.neverNull((Object)entry.getValue()));
            }
            return null;
        });
    }

    @Override
    public @NonNull String getToolTipText() {
        return this.getLongLabelText();
    }

    public int getTotalFunctionCallCount() {
        ReentrantReadWriteLock.ReadLock lock = this.processLock.readLock();
        lock.lock();
        try {
            int total = 0;
            for (Map.Entry<Integer, ProcessTarget> entry : this.processTargetMap.entrySet()) {
                total += entry.getValue().getModel().count();
            }
            int n = total;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean hasBeenModified() {
        return this.processTargets(targets -> {
            for (ProcessTarget target : targets) {
                if (!target.getModel().hasBeenModifiedSinceLastSave()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
    }

    public abstract boolean isLiveTarget();

    @Override
    public boolean isTheChildrenListFinal() {
        return this.getConnection().isClosed();
    }

    public void removeTargetEventListener(@NonNull ITargetEventListener targetListener) {
        this.readLock(() -> {
            if (!this.isClosed()) {
                this.targetEventListeners.removeWeakReference(targetListener);
            }
            return null;
        });
    }

    public final void syncRead() {
        this.connection.start();
        this.connection.waitForUnmarshallerToComplete();
        this.waitForProcessingToComplete();
    }

    public final void waitForProcessingToComplete() {
        this.getLightweightModel().waitForModelProcessorToComplete(60000L);
    }

    protected abstract @NonNull String getNoVersionErrorMessage();

    protected @NonNull ProcessTarget getOrCreateProcessTargetFor(@Nullable String processName, int processID, boolean processStartedBeforeTracing) {
        ProcessTarget existing = this.getProcessTarget(processID);
        if (existing != null) {
            return existing;
        }
        ProcessTarget result = this.newProcessTargetType(processID, processStartedBeforeTracing, processName != null ? processName : UNKNOWN_PROCESS_NAME);
        this.writeLock(() -> {
            this.processTargetMap.put(NullUtils.intValueOf((int)processID), result);
            this.onTracingStarted(result);
            return null;
        });
        return result;
    }

    protected abstract @NonNull ProcessTarget newProcessTargetType(int var1, boolean var2, @NonNull String var3);

    protected abstract void onTracingStarted(@NonNull ProcessTarget var1);

    public boolean hasTakenTrace() {
        return this.hasTracingStarted;
    }

    protected abstract void setTracingStarted();

    private void appendNewFunctionCall(@NonNull FunctionCallDescriptor functionCallDescriptor) {
        ProcessTarget processTarget = this.getOrCreateProcessTargetFor(null, functionCallDescriptor.getProcessId(), true);
        FunctionCall newFunctionCall = processTarget.appendNewFunctionCall(functionCallDescriptor);
        if (this.isLiveTarget() && !this.sentMidstreamWarning) {
            KapiSpec kapiSpec = functionCallDescriptor.getFunctionSpec().getKapiSpec();
            if (processTarget.getModel().processStartedBeforeTracing() && (KapiSpec.CL.equals(kapiSpec) || KapiSpec.VULKAN.equals(kapiSpec))) {
                this.sentMidstreamWarning = true;
                CoreLogging.userMessage(this, Level.WARNING, "Application was already running when trace was started.\nThe state of the API and the collection of assets may be incomplete.\nSome features may also be unavailable.");
            }
        }
        if (newFunctionCall.getIndex() == 0) {
            TraceDataModel model = processTarget.getModel();
            model.waitForFunctionToBeProcessed(newFunctionCall);
            assert (model.count() > 0);
            assert (model.getCallItem(0) == newFunctionCall);
            this.writeLock(() -> {
                boolean added = this.processTargetsWithFunctionCalls.add(processTarget);
                assert (added);
                this.targetEventListeners.notifyWeakListeners(listener -> listener.onNewTargetModelEvent(this, model));
                return null;
            });
        }
    }

    private void dispatchTargetEvent(@NonNull TargetEventDescriptor targetEventDescriptor) {
        TargetEvent targetEvent = new TargetEvent(this, targetEventDescriptor);
        Integer sourcePid = targetEventDescriptor.getProcessId();
        if (targetEvent.getEventType() == TargetEvent.TargetEventType.DAEMON_INTERCEPTOR_VERSION_ERROR) {
            @NonNull String daemonVersion = "";
            @NonNull String interceptorVersion = "";
            for (TargetEventAttachment att : targetEvent.getAttachments()) {
                if (!(att instanceof VersionInfoEventAttachment)) continue;
                VersionInfoEventAttachment info = (VersionInfoEventAttachment)att;
                daemonVersion = info.getDaemonVersion();
                interceptorVersion = info.getInterceptorVersion();
                break;
            }
            assert (!daemonVersion.isEmpty() && !interceptorVersion.isEmpty()) : "Failed to get daemon or interception version attachments out of a Daemon/Interceptor version error event.";
            CoreLogging.userMessage(this, Level.WARNING, AbstractTarget.getVersionMismatchErrorMessage(daemonVersion, interceptorVersion));
        } else if (targetEvent.getEventType() == TargetEvent.TargetEventType.PROCESS_STARTED) {
            try {
                ProcessStartedTargetEventAttachment attachment = targetEvent.findAttachment(ProcessStartedTargetEventAttachment.class);
                if (attachment != null) {
                    String processName = attachment.getProcessName();
                    Boolean processStartedBeforeCapturing = attachment.getProcessStartedBeforeTracing();
                    ProcessTarget processTarget = this.getOrCreateProcessTargetFor(processName != null ? processName : UNKNOWN_PROCESS_NAME, sourcePid, processStartedBeforeCapturing != null ? processStartedBeforeCapturing : false);
                    if (processTarget.getFunctionCallCount() != 0) {
                        this.onTracingStarted(processTarget);
                    }
                    processTarget.getModel().setProcessStarted();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else if (targetEvent.getEventType() == TargetEvent.TargetEventType.PROCESS_FINISHED) {
            ProcessEndedTargetEventAttachment attachment = targetEvent.findAttachment(ProcessEndedTargetEventAttachment.class);
            @Nullable ProcessTarget processTarget = this.getProcessTarget(sourcePid);
            if (processTarget != null) {
                TraceDataModel model = processTarget.getModel();
                processTarget.dispatchTargetEvent(targetEvent);
                if (model.isProcessRunning()) {
                    model.setProcessEnded();
                } else if (attachment != null && attachment.isFromDaemon()) {
                    CoreLogging.warning(this, "Did not receive process closed message from interceptor. Did the traced process crash?");
                }
            }
        } else if (targetEvent.getEventType() == TargetEvent.TargetEventType.AUTHORISATION_FEATURE_USED) {
            AuthorisationFeatureEventAttachment attachment = targetEvent.findAttachment(AuthorisationFeatureEventAttachment.class);
            assert (attachment != null);
            this.addFeatureAuthorisation(Feature.getCoreFeature(attachment.getFeature()));
        } else if (targetEvent.getEventType() == TargetEvent.TargetEventType.DEVICE_INFO) {
            DeviceInfoEventAttachment deviceInfoEventAttachment = targetEvent.findAttachment(DeviceInfoEventAttachment.class);
            if (deviceInfoEventAttachment == null) {
                return;
            }
            this.handleDeviceInfoEvent(deviceInfoEventAttachment);
        } else if (sourcePid == 0) {
            FeatureAuthorisationRequestEventAttachment attachment;
            if (targetEvent.getEventType() == TargetEvent.TargetEventType.CONNECTION_REQUEST) {
                DeviceConnectionRequestEventAttachment attachment2 = targetEvent.findAttachment(DeviceConnectionRequestEventAttachment.class);
                if (attachment2 != null) {
                    this.addFeatureAuthorisation(Feature.getCoreFeature(attachment2.getFeature()));
                }
            } else if (targetEvent.getEventType() == TargetEvent.TargetEventType.AUTHORISATION_REQUEST && (attachment = targetEvent.findAttachment(FeatureAuthorisationRequestEventAttachment.class)) != null) {
                this.handleAuthorisationRequest(attachment);
            }
        } else {
            ProcessTarget processTarget = this.getOrCreateProcessTargetFor(null, sourcePid, true);
            processTarget.dispatchTargetEvent(targetEvent);
        }
    }

    private void handleDeviceInfoEvent(@NonNull DeviceInfoEventAttachment deviceInfoEventAttachment) {
        this.deviceInfo.complete(deviceInfoEventAttachment);
        boolean isMaliTarget = deviceInfoEventAttachment.equals(DeviceInfoEventAttachment.deviceInfoNotAvailable()) ? true : AbstractTarget.isMaliTarget(deviceInfoEventAttachment);
        if (isMaliTarget) {
            this.isAuthorised.complete(new FeatureAuthorisation(true, AUTHORISATION_REASON_IS_MALI_DEVICE, Feature.NON_MALI_DEVICE));
        } else {
            this.getNonMaliDeviceAuthorisation();
        }
    }

    private static @NonNull String getVersionMismatchErrorMessage(@NonNull String daemonVersion, @NonNull String interceptorVersion) {
        String acceptedVersions = AbstractLiveTraceMarshaller.getAcceptedLiveTargetVersion();
        assert (acceptedVersions.contains(daemonVersion)) : "Active connection with out of date daemon should not be allowed.";
        assert (!Objects.equals(daemonVersion, interceptorVersion)) : "Daemon+intercepter version mismatch but the versions are the same.";
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("An application was started with a ").append(VersionProperties.FULL_PRODUCT_NAME).append(" interceptor version that does not match the currently connected ").append(VersionProperties.FULL_PRODUCT_NAME).append(" daemon. Make sure that any components you have installed are from the most recent version of ").append(VersionProperties.FULL_PRODUCT_NAME).append(".").append(System.lineSeparator()).append(System.lineSeparator()).append(VersionProperties.FULL_PRODUCT_NAME).append(" accepts the following version(s): ").append(acceptedVersions).append(".").append(System.lineSeparator()).append("The currently connected ").append(VersionProperties.FULL_PRODUCT_NAME).append(" daemon version is: ").append(daemonVersion).append(".").append(System.lineSeparator()).append("The application is using ").append(VersionProperties.FULL_PRODUCT_NAME).append(" interceptor version: ").append(interceptorVersion).append(".");
        return NullUtils.buildString((StringBuilder)messageBuilder);
    }

    private static boolean isMaliTarget(@NonNull ITargetDeviceInfo targetDeviceInfo) {
        boolean isMaliTarget = targetDeviceInfo.getGlVendor().startsWith("ARM") && targetDeviceInfo.getGlRenderer().startsWith("Mali-");
        return isMaliTarget;
    }

    private void getNonMaliDeviceAuthorisation() {
        @Nullable AuthorisationManager authManager = CoreInstance.getAuthorisationManager();
        assert (authManager != null);
        authManager.getAuthorisation(Feature.NON_MALI_DEVICE).thenAccept(authorisation -> {
            this.nonMaliDeviceAuthorisationRequested = true;
            this.isAuthorised.complete((FeatureAuthorisation)NullUtils.neverNull((Object)authorisation));
            if (!authorisation.isAuthorised()) {
                this.connection.getUnmarshaller().requestStop();
            }
        });
    }

    public void addFeatureAuthorisation(@NonNull Feature feature) {
        @Nullable AuthorisationManager authManager = CoreInstance.getAuthorisationManager();
        assert (authManager != null);
        @NonNull CompletableFuture<@NonNull FeatureAuthorisation> authorised = new CompletableFuture<FeatureAuthorisation>();
        if (feature.equals((Object)Feature.UNROOTED_ANDROID_SUPPORT)) {
            authorised.complete(new FeatureAuthorisation(true, AUTHORISATION_REASON_UNROOTED_ANDROID, feature));
        } else {
            authManager.getAuthorisation(feature).thenAccept(authorisation -> {
                authorised.complete((FeatureAuthorisation)authorisation);
                if (!authorisation.isAuthorised()) {
                    this.isAuthorised.complete((FeatureAuthorisation)authorisation);
                    this.connection.getUnmarshaller().requestStop();
                }
            });
        }
        this.authorisationFeatures.put(feature, authorised);
    }

    public @NonNull CompletableFuture<@NonNull ITargetDeviceInfo> getDeviceInfo() {
        return this.deviceInfo;
    }

    public @NonNull CompletableFuture<@NonNull FeatureAuthorisation> isAuthorised() {
        return this.isAuthorised;
    }

    public boolean isKillCommandSupported() {
        return this.isKillCommandSupported;
    }

    public @NonNull Map<Feature, CompletableFuture<@NonNull FeatureAuthorisation>> getAuthorisationFeatures() {
        return this.authorisationFeatures;
    }

    public abstract void handleAuthorisationRequest(@NonNull FeatureAuthorisationRequestEventAttachment var1);

    private void markAllProcessesComplete() {
        this.processTargets(targets -> {
            for (ProcessTarget processTarget : targets) {
                processTarget.getModel().setInputComplete();
            }
            this.getLightweightModel().setIsComplete();
            return null;
        });
    }

    static /* synthetic */ AtomicBoolean access$1(AbstractTarget abstractTarget) {
        return abstractTarget.disconnected;
    }

    static /* synthetic */ WeakListenerSet access$2(AbstractTarget abstractTarget) {
        return abstractTarget.targetEventListeners;
    }

    protected static interface IInboundConnectionFactory {
        public @NonNull IInboundConnection create(@NonNull IUnmarshallerDataSink var1, @NonNull IInboundConnection.IConnectionStatusChangeListener var2, @NonNull IByteStore var3) throws IOException, ProtocolVersionException;
    }
}

