/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data.tracestatedata;

import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.diff.IDiffable;
import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.state.GLESApiVersion;
import com.arm.mgd.core.state.GraphicsContext;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.state.TargetStateMap;
import com.arm.mgd.core.target.data.AbstractFreeAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.memoryreport.MemoryReportChannel;
import com.arm.mgd.core.target.data.memoryreport.MemoryReportModel;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateData;
import com.arm.mgd.core.traceanalyses.TraceAnalysisModel;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.lightweight.bridge.LightweightStateBridge;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class TraceStateSnapshot
implements IDiffable<TraceStateSnapshot> {
    private static final String OUT_OF_RANGE_FUNCTION_CALL_INDEX_MESSAGE = "The function call index: %s is out of range.";
    private static final int LOAD_CACHED_SNAPSHOT_THRESHOLD = 50000;
    private int currentSelection = -1;
    private final @NonNull TraceDataModel model;
    private @NonNull TraceStateData traceStateData;
    private final @NonNull LightweightStateBridge lightweightStateBridge;

    protected TraceStateSnapshot(@NonNull TraceDataModel model) {
        this.model = model;
        this.traceStateData = new TraceStateData(this);
        this.lightweightStateBridge = new LightweightStateBridge(this);
    }

    public int getCurrentSelection() {
        return this.currentSelection;
    }

    /*
     * Unable to fully structure code
     */
    protected void setSelectedFunction(int newSelectionIndex) {
        if (this.currentSelection == newSelectionIndex) {
            return;
        }
        if (!this.isFunctionCallInRange(newSelectionIndex)) {
            throw new IndexOutOfBoundsException(String.format("The function call index: %s is out of range.", new Object[]{Integer.toString(newSelectionIndex)}));
        }
        movingBackwards = newSelectionIndex < this.currentSelection;
        v0 = movingFarForwards = newSelectionIndex - this.currentSelection > 50000;
        if (movingBackwards || movingFarForwards) {
            this.restoreSnapshotPriorToFunction(newSelectionIndex);
        }
        if (TraceStateSnapshot.$assertionsDisabled || this.currentSelection <= newSelectionIndex) ** GOTO lbl12
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            this.processNextFunction();
lbl12:
            // 2 sources

            ** while (this.currentSelection < newSelectionIndex)
        }
lbl13:
        // 1 sources

        this.getModel().getSnapshotsCache().cachePut(this.currentSelection, this.traceStateData);
    }

    private boolean isFunctionCallInRange(int functionCallId) {
        return (functionCallId >= 0 || functionCallId == -1) && functionCallId < this.model.internalCount();
    }

    private void restoreSnapshotPriorToFunction(int newSelectionIndex) {
        int previousKnownSnapshot;
        block4: {
            previousKnownSnapshot = this.getModel().getSnapshotsCache().findNearestResumePoint(newSelectionIndex);
            if (previousKnownSnapshot != -1) {
                try {
                    CoreLogging.log(this.model, Level.FINE, "Re-using snapshot " + previousKnownSnapshot);
                    this.traceStateData = this.model.getSnapshotsCache().cacheGet(previousKnownSnapshot, this);
                    this.currentSelection = previousKnownSnapshot;
                }
                catch (Exception e) {
                    previousKnownSnapshot = -1;
                    e.printStackTrace();
                    if (!this.model.isClosed()) break block4;
                    throw new RuntimeException("Snapshot in use after model closed", e);
                }
            }
        }
        if (previousKnownSnapshot == -1) {
            this.traceStateData.reset();
            this.currentSelection = -1;
        }
        this.lightweightStateBridge.update(this.model.getCallItem(this.currentSelection));
    }

    private void processNextFunction() {
        assert (this.currentSelection + 1 < this.model.internalCount());
        FunctionCall previousFc = this.currentSelection > 0 ? this.model.getCallItem(this.currentSelection) : null;
        ++this.currentSelection;
        FunctionCall fc = this.model.getCallItem(this.currentSelection);
        IFunctionOrAliasSpecExtended functionSpec = fc.getFunctionSpec();
        assert (functionSpec != null);
        if (previousFc == null || previousFc.getPid() != fc.getPid() || previousFc.getTid() != fc.getTid()) {
            this.traceStateData.setCurrentContext(fc);
        }
        if (fc.isFrameEnd()) {
            this.onFrameEnd();
        }
        for (AbstractFreeAttachment freeAttachment : fc.getFreeAttachments()) {
            freeAttachment.earlyPreProcess(this);
        }
        this.lightweightStateBridge.update(fc);
        functionSpec.processAssets(this, fc);
        this.getMemoryReportModel().setNewFunctionFlag();
        for (AbstractFreeAttachment freeAttachment : fc.getFreeAttachments()) {
            freeAttachment.process(this);
        }
    }

    private void onFrameEnd() {
        for (IAssetItem iAssetItem : this.getAssetTableBySpec(KapiSpec.GLES.assetTables.SHADER_TRAITS.SPEC)) {
            GlShaderAsset shaderAsset = (GlShaderAsset)iAssetItem;
            shaderAsset.resetCurrentFrameShaderInvocations();
        }
        for (IAssetItem iAssetItem : this.getAssetTableBySpec(KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC)) {
            GlProgramAsset programAsset = (GlProgramAsset)iAssetItem;
            programAsset.getLinkedShaders().forEach(GlShaderAsset::resetCurrentFrameShaderInvocations);
            programAsset.getAttachedShaders().forEach(GlShaderAsset::resetCurrentFrameShaderInvocations);
        }
    }

    public void clearGlobalAssetState(@NonNull FunctionCall functionCall) {
        this.traceStateData.reset();
        this.traceStateData.setCurrentContext(functionCall);
    }

    public @NonNull TargetStateMap getStateData(KapiSpec api) {
        return this.lightweightStateBridge.getTargetStateMap((KapiSpec)NullUtils.neverNull((Object)api));
    }

    public Collection<AssetTable> getTargetAssetTables(KapiSpec api) {
        return this.traceStateData.getAssetTables(api);
    }

    public AssetTable getAssetTableBySpec(AssetTableSpec assetTableSpec) {
        return this.traceStateData.getAssetTableBySpec(assetTableSpec);
    }

    public @NonNull StateItem getStateItemBySpec(@NonNull StateSpec stateSpec) {
        return this.lightweightStateBridge.getStateItemBySpec(stateSpec);
    }

    public @NonNull Collection<? extends StateItem> getStateItems(@NonNull KapiSpec api) {
        return this.getStateData(api).getStateItems();
    }

    public @NonNull GraphicsContext getCurrentContext() {
        return this.traceStateData.getCurrentContext();
    }

    public IAssetItem addAsset(IAssetItem ai) {
        AssetTable assetMap = this.getAssetTableBySpec(ai.getAssetSpec());
        return assetMap.addAsset(ai);
    }

    public void createContext(@NonNull Pointer newContextHandle, Pointer shareContexthandle, @NonNull GLESApiVersion apiVersion, @NonNull FunctionCall currentFunctionCall) {
        this.traceStateData.createContext(newContextHandle, shareContexthandle, apiVersion, currentFunctionCall);
    }

    public GraphicsContext makeCurrentContext(long tid, @NonNull Pointer contextHandle, @NonNull FunctionCall currentFunctionCall) {
        return this.traceStateData.makeCurrent(tid, contextHandle, currentFunctionCall);
    }

    @Override
    public final Class<TraceStateSnapshot> getIDiffableTClass() {
        return TraceStateSnapshot.class;
    }

    public @NonNull FunctionCall getCurrentFunctionCall() {
        return this.model.getCallItem(this.currentSelection);
    }

    public @NonNull MemoryReportModel getMemoryReportModel() {
        return (MemoryReportModel)NullUtils.neverNull((Object)this.traceStateData.getMemoryReportModel());
    }

    public void addDataToMemoryReportModel(ArrayList<MemoryReportChannel> channelList) {
        this.traceStateData.addMemoryReport(channelList);
    }

    public @NonNull LightweightStateBridge getLightweightStateBridge() {
        return this.lightweightStateBridge;
    }

    public @NonNull TraceDataModel getModel() {
        return this.model;
    }

    public abstract @Nullable TraceAnalysisModel getTraceAnalysisModel();

    public @NonNull ISnapshotAssetParent asSnapshotAssetParent() {
        return this.traceStateData;
    }
}

