/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data.tracestatedata;

import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.TargetAssetMap;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.state.GLESApiVersion;
import com.arm.mgd.core.state.GraphicsContext;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.memoryreport.MemoryReportChannel;
import com.arm.mgd.core.target.data.memoryreport.MemoryReportModel;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.kapi.gen.AssetTablesSpec;
import com.arm.mgd.kapi.gen.ScopeSpec;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TraceStateData
implements ISnapshotAssetParent {
    private static final long serialVersionUID = -6628459389285647028L;
    private @NonNull GraphicsContext commonContext;
    private @NonNull GraphicsContext currentContext;
    private final Map<@NonNull Long, GraphicsContext> tidContextMap = new HashMap<Long, GraphicsContext>();
    private final Map<@NonNull Pointer, GraphicsContext> pointerContextMap = new HashMap<Pointer, GraphicsContext>();
    private transient @NonNull TraceStateSnapshot traceStateSnapshot;
    private @NonNull MemoryReportModel memoryReportModel = new MemoryReportModel();
    private long nextGraphicsContextIndex = 0L;

    public TraceStateData(@NonNull TraceStateSnapshot traceStateSnapshot) {
        this.traceStateSnapshot = traceStateSnapshot;
        this.commonContext = this.createContext(0L, Pointer.valueOf(0L), null, GLESApiVersion.UNKNOWN, traceStateSnapshot.getCurrentFunctionCall());
        this.currentContext = this.getDefaultContext();
    }

    public List<AssetTable> getAssetTables(KapiSpec api) {
        ArrayList<AssetTable> assetTables = new ArrayList<AssetTable>();
        AssetTablesSpec tableSpecsForApi = api.getApi().getAssetTables();
        for (AssetTableSpec tableSpec : tableSpecsForApi.getAssetTable()) {
            AssetTable table = this.getAssetTableBySpec(tableSpec);
            assetTables.add(table);
        }
        return assetTables;
    }

    public @NonNull GraphicsContext getCurrentContext() {
        return this.currentContext;
    }

    public void setCurrentContext(@NonNull FunctionCall fc) {
        this.currentContext = this.getCurrentContextByProcessAndThread(fc.getTid());
    }

    private @NonNull GraphicsContext getCurrentContextByProcessAndThread(long tid) {
        GraphicsContext context = this.tidContextMap.get(tid);
        if (context == null) {
            context = this.getDefaultContext();
        }
        return context;
    }

    private @NonNull GraphicsContext getDefaultContext() {
        return (GraphicsContext)NullUtils.neverNull((Object)this.pointerContextMap.get(Pointer.valueOf(0L)));
    }

    private Object readResolve() {
        return this;
    }

    private @NonNull GraphicsContext createContext(long index, @NonNull Pointer contextHandle, @Nullable Pointer parentContextHandle, @NonNull GLESApiVersion apiVersion, @NonNull FunctionCall currentFunctionCall) {
        GraphicsContext parentContext = null;
        if (parentContextHandle != null && parentContextHandle.address() != 0L && (parentContext = this.pointerContextMap.get(parentContextHandle)) == null) {
            CoreLogging.warning(this.traceStateSnapshot.getModel(), "Missing context for eglCreateContext");
            assert (false) : "Missing GraphicsContext " + parentContextHandle;
        }
        @NonNull GraphicsContext context = GraphicsContext.create(index, contextHandle, apiVersion, this, parentContext, currentFunctionCall);
        this.pointerContextMap.put(contextHandle, context);
        return context;
    }

    public @NonNull GraphicsContext createContext(@NonNull Pointer contextHandle, @Nullable Pointer parentContextHandle, @NonNull GLESApiVersion apiVersion, @NonNull FunctionCall currentFunctionCall) {
        return this.createContext(this.nextGraphicsContextIndex++, contextHandle, parentContextHandle, apiVersion, currentFunctionCall);
    }

    AssetTable getAssetTableBySpec(AssetTableSpec assetTableSpec) {
        if (assetTableSpec.getScope() == ScopeSpec.COMMON) {
            return ((TargetAssetMap)NullUtils.neverNull((Object)this.commonContext.assetData.get(assetTableSpec.getKapiSpec()))).getAssetTable(assetTableSpec);
        }
        if (assetTableSpec.getScope() == ScopeSpec.SHARED) {
            return ((TargetAssetMap)NullUtils.neverNull((Object)this.currentContext.contextGroup.assetData.get(assetTableSpec.getKapiSpec()))).getAssetTable(assetTableSpec);
        }
        return ((TargetAssetMap)NullUtils.neverNull((Object)this.currentContext.assetData.get(assetTableSpec.getKapiSpec()))).getAssetTable(assetTableSpec);
    }

    @NonNull GraphicsContext makeCurrent(long tid, @NonNull Pointer contextHandle, @NonNull FunctionCall currentFunctionCall) {
        GraphicsContext context = this.pointerContextMap.get(contextHandle);
        if (context == null) {
            context = this.createContext(contextHandle, null, GLESApiVersion.UNKNOWN, currentFunctionCall);
        }
        assert (context != null);
        this.tidContextMap.put(NullUtils.longValueOf((long)tid), context);
        this.currentContext = context;
        return context;
    }

    void reset() {
        this.tidContextMap.clear();
        this.commonContext = this.createContext(0L, Pointer.valueOf(0L), null, GLESApiVersion.UNKNOWN, this.traceStateSnapshot.getModel().getCallItem(-1));
    }

    public void addMemoryReport(ArrayList<MemoryReportChannel> channelList) {
        this.memoryReportModel.addData(channelList);
    }

    public @NonNull MemoryReportModel getMemoryReportModel() {
        return this.memoryReportModel;
    }

    @Override
    public @NonNull String getCoreLoggingSourceKey() {
        return this.traceStateSnapshot.getModel().getCoreLoggingSourceKey();
    }

    @Override
    public @NonNull TraceStateSnapshot getTraceStateSnapshot() {
        return this.traceStateSnapshot;
    }

    public void setTraceStateSnapshot(@NonNull TraceStateSnapshot traceStateSnapshot) {
        this.traceStateSnapshot = traceStateSnapshot;
    }
}

