/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data.tracestatedata;

import com.arm.mgd.core.target.data.ByteStoreCachedObject;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateData;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.target.marshaller.bytedata.IByteStore;
import com.arm.mgd.core.util.BinarySearch;
import com.arm.mgd.core.util.CoreLogging;
import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.logging.Level;
import org.eclipse.jdt.annotation.NonNull;

public class SnapshotCache {
    private static final int BASIC_SNAPSHOT_SIZE = 25000;
    private final @NonNull IByteStore byteStore;
    private final TreeMap<Integer, ByteStoreCachedObject<TraceStateData>> map = new TreeMap();

    public SnapshotCache(@NonNull IByteStore byteStore) {
        this.byteStore = byteStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull TraceStateData cacheGet(int functionCallIndex, @NonNull TraceStateSnapshot parentSnapshot) throws IOException, ClassNotFoundException {
        assert (parentSnapshot != null);
        Integer snapshotKey = functionCallIndex;
        ByteStoreCachedObject<TraceStateData> cachedSnapshot = null;
        TreeMap<Integer, ByteStoreCachedObject<TraceStateData>> treeMap = this.map;
        synchronized (treeMap) {
            cachedSnapshot = this.map.get(snapshotKey);
        }
        assert (cachedSnapshot != null);
        TraceStateData stateData = cachedSnapshot.deserializeObject();
        stateData.setTraceStateSnapshot(parentSnapshot);
        return stateData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cachePut(int functionCallIndex, @NonNull TraceStateData traceStateData) {
        TreeMap<Integer, ByteStoreCachedObject<TraceStateData>> treeMap = this.map;
        synchronized (treeMap) {
            block7: {
                if (this.map.containsKey(functionCallIndex)) {
                    return;
                }
                try {
                    FunctionCall callItem = traceStateData.getTraceStateSnapshot().getModel().getCallItem(functionCallIndex);
                    if (callItem.hasMidstreamTraceData() || functionCallIndex > 0 && functionCallIndex % 25000 == 0) {
                        CoreLogging.log(null, Level.FINE, "Caching state snapshot for function call " + functionCallIndex);
                        this.map.put(functionCallIndex, new ByteStoreCachedObject<TraceStateData>(traceStateData, this.byteStore));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError((Object)("Unable to serialise data for function call " + functionCallIndex));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findNearestResumePoint(int newFunctionCallIndex) {
        TreeMap<Integer, ByteStoreCachedObject<TraceStateData>> treeMap = this.map;
        synchronized (treeMap) {
            if (this.map.containsKey(newFunctionCallIndex)) {
                return newFunctionCallIndex;
            }
            BinarySearch.BinarySearchNeighbours neighbours = BinarySearch.findNeighbours((SortedSet)this.map.keySet(), newFunctionCallIndex);
            return neighbours.previous != null ? neighbours.previous : -1;
        }
    }
}

