/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data.memoryreport;

import com.arm.mgd.core.target.data.memoryreport.MemoryReportChannel;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;

public class MemoryReportParser {
    private String fileName;
    private ArrayList<MemoryReportChannel> data = new ArrayList();
    private static Pattern channelPattern = Pattern.compile("(\\AChannel:\\s)(.*)(\\s[(].*)");
    private static Pattern binPattern = Pattern.compile("(\\s*)(\\d+)([:]\\s*)(\\d+)(\\s[/]\\s)(\\d+)");
    private static Pattern emptyPattern = Pattern.compile("\\A\\s[(]empty[)]\\z");

    public MemoryReportParser(@NonNull String dump) {
        this.parse(dump);
    }

    private void parse(@NonNull String dump) {
        String[] lines = dump.split("[\\r\\n]+");
        boolean first = true;
        String curChannelName = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (first) {
                first = false;
                this.fileName = line.replaceAll(":", "");
            } else {
                Matcher channelMatch = channelPattern.matcher(line);
                if (channelMatch.matches()) {
                    curChannelName = channelMatch.group(2);
                    this.data.add(new MemoryReportChannel(curChannelName));
                } else {
                    Matcher binMatch = binPattern.matcher(line);
                    if (binMatch.matches()) {
                        long bin = Long.parseLong(binMatch.group(2));
                        long memAllocs = Long.parseLong(binMatch.group(4));
                        long occupiedMem = Long.parseLong(binMatch.group(6));
                        this.data.get(this.data.size() - 1).addBin(bin, memAllocs, occupiedMem);
                    } else {
                        Matcher emptyMatch = emptyPattern.matcher(line);
                        if (emptyMatch.matches()) {
                            // empty if block
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public ArrayList<MemoryReportChannel> getData() {
        return this.data;
    }

    public long getTotalMemory() {
        long total = 0L;
        for (MemoryReportChannel channel : this.data) {
            total += channel.getTotalAllocatedMemory();
        }
        return total;
    }

    public String getFileName() {
        return this.fileName;
    }
}

