/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data.memoryreport;

import com.arm.mgd.core.target.data.memoryreport.MemoryReportBin;
import com.arm.mgd.core.target.data.memoryreport.MemoryReportChannel;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class MemoryReportModel
implements Serializable {
    private static final long serialVersionUID = -8241005131127241728L;
    private HashMap<String, MemoryReportChannel> map = new HashMap();
    boolean overwriteData = false;

    public @NonNull ArrayList<MemoryReportChannel> getMemoryReport() {
        return new ArrayList<MemoryReportChannel>(this.map.values());
    }

    public @Nullable MemoryReportChannel getChannel(String channelName) {
        return this.map.get(channelName);
    }

    public void addData(ArrayList<MemoryReportChannel> channelList) {
        if (this.overwriteData) {
            this.map.clear();
        }
        for (MemoryReportChannel channel : channelList) {
            String channelName = channel.getChannelName();
            if (this.map.containsKey(channelName)) {
                @NonNull MemoryReportChannel storedChannel = (MemoryReportChannel)NullUtils.neverNull((Object)this.map.get(channelName));
                for (MemoryReportBin bin : channel.getBins()) {
                    storedChannel.addBin(bin.getBin(), bin.getMemoryAllocations(), bin.getOccupiedMemory());
                }
                continue;
            }
            this.map.put(channelName, channel);
        }
    }

    public void setNewFunctionFlag() {
        this.overwriteData = true;
    }

    public long getTotalAllocatedMemory() {
        long totalAllocatedMemory = 0L;
        for (MemoryReportChannel channel : this.map.values()) {
            totalAllocatedMemory += channel.getTotalAllocatedMemory();
        }
        return totalAllocatedMemory;
    }
}

