/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data.memoryreport;

import com.arm.mgd.core.target.data.memoryreport.MemoryReportBin;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jdt.annotation.NonNull;

public class MemoryReportChannel
implements Serializable {
    private static final long serialVersionUID = 5751161866810820276L;
    private HashMap<Long, MemoryReportBin> bins = new HashMap();
    private final @NonNull String channelName;

    public MemoryReportChannel(String channelName) {
        assert (channelName != null);
        this.channelName = channelName;
    }

    public void addBin(long bin, long memoryAllocations, long occupiedMemory) {
        MemoryReportBin storedBin = this.bins.get(bin);
        if (storedBin != null) {
            storedBin.incMemoryAllocations(memoryAllocations);
            storedBin.incOccupiedMemory(occupiedMemory);
        } else {
            this.bins.put(bin, new MemoryReportBin(bin, memoryAllocations, occupiedMemory));
        }
    }

    public @NonNull String getChannelName() {
        return this.channelName;
    }

    public long getTotalAllocatedMemory() {
        long total = 0L;
        for (MemoryReportBin bin : this.bins.values()) {
            total += bin.getOccupiedMemory();
        }
        return total;
    }

    public Collection<MemoryReportBin> getBins() {
        return this.bins.values();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bins == null ? 0 : this.bins.hashCode());
        result = 31 * result + this.channelName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MemoryReportChannel)) {
            return false;
        }
        MemoryReportChannel otherChannel = (MemoryReportChannel)obj;
        if (!this.channelName.equals(otherChannel.getChannelName())) {
            return false;
        }
        for (MemoryReportBin bin : this.bins.values()) {
            if (otherChannel.getBins().contains(bin)) continue;
            return false;
        }
        return true;
    }
}

