/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data.memoryreport;

import java.io.Serializable;

public class MemoryReportBin
implements Serializable {
    private static final long serialVersionUID = 8701518904737074601L;
    private final long bin;
    private long memoryAllocations;
    private long occupiedMemory;

    public MemoryReportBin(long bin, long memoryAllocations, long occupiedMemory) {
        this.bin = bin;
        this.memoryAllocations = memoryAllocations;
        this.occupiedMemory = occupiedMemory;
    }

    public long getOccupiedMemory() {
        return this.occupiedMemory;
    }

    public long getBin() {
        return this.bin;
    }

    public long getMemoryAllocations() {
        return this.memoryAllocations;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.bin ^ this.bin >>> 32);
        result = 31 * result + (int)(this.memoryAllocations ^ this.memoryAllocations >>> 32);
        result = 31 * result + (int)(this.occupiedMemory ^ this.occupiedMemory >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MemoryReportBin)) {
            return false;
        }
        MemoryReportBin other = (MemoryReportBin)obj;
        if (this.bin != other.bin) {
            return false;
        }
        if (this.memoryAllocations != other.memoryAllocations) {
            return false;
        }
        return this.occupiedMemory == other.occupiedMemory;
    }

    public void incMemoryAllocations(long newMemoryAllocations) {
        this.memoryAllocations += newMemoryAllocations;
    }

    public void incOccupiedMemory(long newOccupiedMemory) {
        this.occupiedMemory += newOccupiedMemory;
    }
}

