/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data.interceptorconfig.vulkan;

import com.arm.mgd.core.pb.v2.MgdProtosV2;
import com.arm.mgd.core.target.data.interceptorconfig.AbstractSelectableResourceContainer;
import com.arm.mgd.core.target.data.interceptorconfig.ISelectableResource;
import com.arm.mgd.core.target.data.interceptorconfig.vulkan.VulkanResource;
import com.arm.mgd.core.target.marshaller.binary_v2.gen.ProtoBuilderHelper;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class VulkanConfig
extends AbstractSelectableResourceContainer<VulkanResource> {
    private static final long serialVersionUID = -3123058307714079391L;
    public static final @NonNull VulkanConfig NOTHING_SELECTED = new VulkanConfig(NullUtils.EMPTY_LIST, false);
    public static final @NonNull VulkanConfig EVERYTHING_SELECTED = new VulkanConfig(NullUtils.EMPTY_LIST, true);

    public VulkanConfig(@NonNull List<@NonNull VulkanResource> resources, boolean missingSelectedByDefault) {
        for (VulkanResource resource : resources) {
            this.selectableResources.put(resource.getSelectableResourceType(), resource);
        }
        this.init(missingSelectedByDefault);
    }

    private void init(boolean missingSelectedByDefault) {
        for (ISelectableResource.SelectableResourceType type : VulkanResource.VALID_RESOURCE_TYPES) {
            this.selectableResources.putIfAbsent(type, new VulkanResource(type, missingSelectedByDefault));
        }
        this.selectableResources.remove((Object)ISelectableResource.SelectableResourceType.SELECTABLE_RESOURCE_UNKNOWN);
        assert (this.selectableResources.size() == VulkanResource.VALID_RESOURCE_TYPES.size() - 1);
    }

    @Override
    public @NonNull String getName() {
        return "Vulkan Configuration";
    }

    @Override
    public ISelectableResource.SelectableResourceType getSelectableResourceType() {
        return ISelectableResource.SelectableResourceType.VULKAN_CONFIG;
    }

    public  @NonNull MgdProtosV2.VulkanConfigProto getProtoBuf() {
        @NonNull ArrayList< @NonNull MgdProtosV2.VulkanResourceProto> resourceConfigMessages = new ArrayList<MgdProtosV2.VulkanResourceProto>();
        for (ISelectableResource resource : this.selectableResources.values()) {
            MgdProtosV2.VulkanResourceProto message = ProtoBuilderHelper.buildVulkanResourceProto(VulkanResource.convertFromSelectableResourceType(resource.getSelectableResourceType()), resource.isSelectedForCapture());
            resourceConfigMessages.add(message);
        }
        return ProtoBuilderHelper.buildVulkanConfigProto(resourceConfigMessages);
    }

    public @NonNull Collection<@NonNull VulkanResource> getResources() {
        return NullUtils.unmodifiableCollection((Collection)NullUtils.neverNullCollection(this.selectableResources.values()));
    }
}

