/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data.interceptorconfig.gles;

import com.arm.mgd.core.pb.v2.MgdProtosV2;
import com.arm.mgd.core.target.data.interceptorconfig.AbstractSelectableResourceContainer;
import com.arm.mgd.core.target.data.interceptorconfig.ISelectableResource;
import com.arm.mgd.core.target.data.interceptorconfig.gles.GlesResource;
import com.arm.mgd.core.target.marshaller.binary_v2.gen.ProtoBuilderHelper;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class GlesConfig
extends AbstractSelectableResourceContainer<GlesResource> {
    private static final long serialVersionUID = 5731694872150826883L;
    public static final @NonNull GlesConfig NOTHING_SELECTED = new GlesConfig(NullUtils.EMPTY_LIST, false);
    public static final @NonNull GlesConfig EVERYTHING_SELECTED = new GlesConfig(NullUtils.EMPTY_LIST, true);

    public GlesConfig(@NonNull List<@NonNull GlesResource> resources, boolean missingSelectedByDefault) {
        for (GlesResource resource : resources) {
            this.selectableResources.put(resource.getSelectableResourceType(), resource);
        }
        this.init(missingSelectedByDefault);
    }

    private void init(boolean missingSelectedByDefault) {
        for (ISelectableResource.SelectableResourceType type : GlesResource.VALID_RESOURCE_TYPES) {
            this.selectableResources.putIfAbsent(type, new GlesResource(type, missingSelectedByDefault));
        }
        this.selectableResources.remove((Object)ISelectableResource.SelectableResourceType.SELECTABLE_RESOURCE_UNKNOWN);
        assert (this.selectableResources.size() == GlesResource.VALID_RESOURCE_TYPES.size() - 1);
    }

    @Override
    public @NonNull String getName() {
        return "GLES Configuration";
    }

    @Override
    public ISelectableResource.SelectableResourceType getSelectableResourceType() {
        return ISelectableResource.SelectableResourceType.GLES_CONFIG;
    }

    public  @NonNull MgdProtosV2.GlesConfigProto getProtoBuf() {
        @NonNull ArrayList< @NonNull MgdProtosV2.GlesResourceProto> resourceConfigMessages = new ArrayList<MgdProtosV2.GlesResourceProto>();
        for (ISelectableResource resource : this.selectableResources.values()) {
            MgdProtosV2.GlesResourceProto message = ProtoBuilderHelper.buildGlesResourceProto(GlesResource.convertFromSelectableResourceType(resource.getSelectableResourceType()), resource.isSelectedForCapture());
            resourceConfigMessages.add(message);
        }
        return ProtoBuilderHelper.buildGlesConfigProto(resourceConfigMessages);
    }

    public @NonNull Collection<@NonNull GlesResource> getResources() {
        return NullUtils.unmodifiableCollection((Collection)NullUtils.neverNullCollection(this.selectableResources.values()));
    }
}

