/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data.interceptorconfig.cl;

import com.arm.mgd.core.pb.v2.MgdProtosV2;
import com.arm.mgd.core.target.data.interceptorconfig.AbstractSelectableResourceContainer;
import com.arm.mgd.core.target.data.interceptorconfig.ISelectableResource;
import com.arm.mgd.core.target.data.interceptorconfig.cl.ClResource;
import com.arm.mgd.core.target.marshaller.binary_v2.gen.ProtoBuilderHelper;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class ClConfig
extends AbstractSelectableResourceContainer<ClResource> {
    private static final long serialVersionUID = 7847665797824070486L;
    public static final @NonNull ClConfig NOTHING_SELECTED = new ClConfig(NullUtils.EMPTY_LIST, false);
    public static final @NonNull ClConfig EVERYTHING_SELECTED = new ClConfig(NullUtils.EMPTY_LIST, true);

    public ClConfig(@NonNull List<@NonNull ClResource> resources, boolean missingSelectedByDefault) {
        for (ClResource resource : resources) {
            this.selectableResources.put(resource.getSelectableResourceType(), resource);
        }
        this.init(missingSelectedByDefault);
    }

    private void init(boolean missingSelectedByDefault) {
        for (ISelectableResource.SelectableResourceType type : ClResource.VALID_RESOURCE_TYPES) {
            this.selectableResources.putIfAbsent(type, new ClResource(type, missingSelectedByDefault));
        }
        this.selectableResources.remove((Object)ISelectableResource.SelectableResourceType.SELECTABLE_RESOURCE_UNKNOWN);
        assert (this.selectableResources.size() == ClResource.VALID_RESOURCE_TYPES.size() - 1);
    }

    @Override
    public @NonNull String getName() {
        return "CL Configuration";
    }

    @Override
    public ISelectableResource.SelectableResourceType getSelectableResourceType() {
        return ISelectableResource.SelectableResourceType.CL_CONFIG;
    }

    public  @NonNull MgdProtosV2.ClConfigProto getProtoBuf() {
        @NonNull ArrayList< @NonNull MgdProtosV2.ClResourceProto> resourceConfigMessages = new ArrayList<MgdProtosV2.ClResourceProto>();
        for (ISelectableResource resource : this.selectableResources.values()) {
            MgdProtosV2.ClResourceProto message = ProtoBuilderHelper.buildClResourceProto(ClResource.convertFromSelectableResourceType(resource.getSelectableResourceType()), resource.isSelectedForCapture());
            resourceConfigMessages.add(message);
        }
        return ProtoBuilderHelper.buildClConfigProto(resourceConfigMessages);
    }

    public @NonNull Collection<@NonNull ClResource> getResources() {
        return NullUtils.unmodifiableCollection((Collection)NullUtils.neverNullCollection(this.selectableResources.values()));
    }
}

