/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data.interceptorconfig;

import com.arm.mgd.core.target.data.interceptorconfig.cl.ClConfig;
import com.arm.mgd.core.target.data.interceptorconfig.gles.GlesConfig;
import com.arm.mgd.core.target.data.interceptorconfig.vulkan.VulkanConfig;
import com.arm.mgd.core.target.marshaller.binary_v2.gen.ProtoBuilderHelper;
import java.io.Serializable;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

public class InterceptorConfig
implements Serializable {
    private static final long serialVersionUID = -7336095430646771295L;
    public static final @NonNull InterceptorConfig NOTHING_SELECTED = new InterceptorConfig(ClConfig.NOTHING_SELECTED, GlesConfig.NOTHING_SELECTED, VulkanConfig.NOTHING_SELECTED);
    public static final @NonNull InterceptorConfig EVERYTHING_SELECTED = new InterceptorConfig(ClConfig.EVERYTHING_SELECTED, GlesConfig.EVERYTHING_SELECTED, VulkanConfig.EVERYTHING_SELECTED);
    private @NonNull GlesConfig glesConfig;
    private @NonNull ClConfig clConfig;
    private @NonNull VulkanConfig vulkanConfig;

    public InterceptorConfig(@NonNull ClConfig clConfig, @NonNull GlesConfig glesConfig, @NonNull VulkanConfig vulkanConfig) {
        this.clConfig = clConfig;
        this.glesConfig = glesConfig;
        this.vulkanConfig = vulkanConfig;
    }

    public @NonNull ClConfig getClConfig() {
        return this.clConfig;
    }

    public @NonNull GlesConfig getGlesConfig() {
        return this.glesConfig;
    }

    public @NonNull VulkanConfig getVulkanConfig() {
        return this.vulkanConfig;
    }

    public  @NonNull MgdProtosV2.InterceptorConfigProto getProtoBuf() {
        return ProtoBuilderHelper.buildInterceptorConfigProto(this.clConfig.getProtoBuf(), this.glesConfig.getProtoBuf(), this.vulkanConfig.getProtoBuf());
    }

    public boolean equals(Object other) {
        if (other instanceof InterceptorConfig) {
            InterceptorConfig that = (InterceptorConfig)other;
            return this.clConfig.equals(that.clConfig) && this.glesConfig.equals(that.glesConfig) && this.vulkanConfig.equals(that.vulkanConfig);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.clConfig, this.glesConfig, this.vulkanConfig);
    }
}

