/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data.interceptorconfig;

import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;

public interface ISelectableResource<T extends ISelectableResource<T>> {
    public boolean isSelectedForCapture();

    public @NonNull Collection<@NonNull T> getChildren();

    public @NonNull String getName();

    public @NonNull SelectableResourceType getSelectableResourceType();

    public static enum SelectableResourceType {
        CL_CONFIG,
        GLES_CONFIG,
        VULKAN_CONFIG,
        SELECTABLE_RESOURCE_UNKNOWN,
        GL_EXPLICIT_BUFFER_ASSET,
        GL_IMPLICIT_BUFFER_ASSET,
        GL_SHADER_ASSET_BINARY,
        GL_SHADER_ASSET_SOURCE,
        GL_SHADER_ASSET_UNIFORM,
        GL_TEXTURE_ASSET,
        CL_PROGRAM_ASSET_SOURCE,
        CL_EXPLICIT_MEMORY_ASSET,
        CL_IMPLICIT_MEMORY_ASSET,
        VK_IMPLICIT_DEVICE_MEMORY_ASSET,
        VK_SHADER_ASSET_BINARY;


        public @NonNull SupportedAPIs getApiForResourceType() {
            switch (this) {
                case GLES_CONFIG: 
                case GL_EXPLICIT_BUFFER_ASSET: 
                case GL_IMPLICIT_BUFFER_ASSET: 
                case GL_SHADER_ASSET_BINARY: 
                case GL_SHADER_ASSET_SOURCE: 
                case GL_SHADER_ASSET_UNIFORM: 
                case GL_TEXTURE_ASSET: {
                    return SupportedAPIs.OPENGL_ES;
                }
                case CL_CONFIG: 
                case CL_PROGRAM_ASSET_SOURCE: 
                case CL_EXPLICIT_MEMORY_ASSET: 
                case CL_IMPLICIT_MEMORY_ASSET: {
                    return SupportedAPIs.OPENCL;
                }
                case VULKAN_CONFIG: 
                case VK_IMPLICIT_DEVICE_MEMORY_ASSET: 
                case VK_SHADER_ASSET_BINARY: {
                    return SupportedAPIs.VULKAN;
                }
            }
            throw new IllegalStateException("Unable to get API spec for resource type: " + this.name());
        }
    }

    public static enum SupportedAPIs {
        OPENGL_ES,
        OPENCL,
        VULKAN;

    }
}

