/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.AbstractFreeAttachment;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.UsageSpec;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;

public class VulkanImageSubresourceLayoutAttachment
extends AbstractFreeAttachment {
    private static final long serialVersionUID = 8029413005464603947L;
    private final long aspectMask;
    private final AbstractConstantOrAliasSpecExtended aspectMaskEnum;
    private final int mipLevel;
    private final int arrayLayer;
    private final long offset;
    private final long size;
    private final long rowPitch;
    private final long arrayPitch;
    private final long depthPitch;

    public VulkanImageSubresourceLayoutAttachment(long aspectMask, int mipLevel, int arrayLayer, long offset, long size, long rowPitch, long arrayPitch, long depthPitch) {
        this.aspectMask = aspectMask;
        this.mipLevel = mipLevel;
        this.arrayLayer = arrayLayer;
        this.offset = offset;
        this.size = size;
        this.rowPitch = rowPitch;
        this.arrayPitch = arrayPitch;
        this.depthPitch = depthPitch;
        UsageSpec usageSpec = KapiSpec.VULKAN.basicTypes.VKIMAGESUBRESOURCE.getContainer().getMember().get(0).getUsage();
        Bitfield aspectMaskBitfield = usageSpec.getBitfieldByValue(NullUtils.longValueOf((long)aspectMask));
        assert (aspectMaskBitfield.size() == 1);
        this.aspectMaskEnum = (AbstractConstantOrAliasSpecExtended)aspectMaskBitfield.first();
        assert (this.aspectMaskEnum == KapiSpec.VULKAN.constants.VK_IMAGE_ASPECT_COLOR_BIT || this.aspectMaskEnum == KapiSpec.VULKAN.constants.VK_IMAGE_ASPECT_DEPTH_BIT || this.aspectMaskEnum == KapiSpec.VULKAN.constants.VK_IMAGE_ASPECT_STENCIL_BIT);
    }

    public long getAspectMask() {
        return this.aspectMask;
    }

    public AbstractConstantOrAliasSpecExtended getAspectMaskEnum() {
        return this.aspectMaskEnum;
    }

    public int getMipLevel() {
        return this.mipLevel;
    }

    public int getArrayLayer() {
        return this.arrayLayer;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getSize() {
        return this.size;
    }

    public long getRowPitch() {
        return this.rowPitch;
    }

    public long getArrayPitch() {
        return this.arrayPitch;
    }

    public long getDepthPitch() {
        return this.depthPitch;
    }

    @Override
    public void process(@NonNull TraceStateSnapshot currentState) {
    }
}

