/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.marshaller.TraceParseException;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import org.eclipse.jdt.annotation.Nullable;

public class VulkanImageDiffAttachment {
    private final long imageId;
    private final int width;
    private final int height;
    private final int layers;
    private final int format;
    private final int bytesPerPixel;
    private final PriorImageInfo priorImageInfo;
    private final @Nullable Long priorImageId;
    private final @Nullable Integer blockSize;
    private final @Nullable IByteDataProvider data;

    public VulkanImageDiffAttachment(long imageId, int width, int height, int layers, int format, int bytesPerPixel, PriorImageInfo priorImageInfo, @Nullable Long priorImageId, @Nullable Integer blockSize, @Nullable IByteDataProvider data) throws TraceParseException {
        boolean isValidData = false;
        switch (priorImageInfo) {
            case HAS_NO_PRIOR_IMAGE: {
                if (priorImageId != null || blockSize != null || data == null || data.getLength() != width * height * layers * bytesPerPixel) break;
                isValidData = true;
                break;
            }
            case HAS_PRIOR_IMAGE: {
                if (priorImageId == null || blockSize == null || data == null) break;
                isValidData = true;
                break;
            }
            case IS_UNCHANGED_FROM_PRIOR_IMAGE: {
                if (priorImageId == null || blockSize != null || data != null) break;
                isValidData = true;
            }
        }
        if (!isValidData) {
            throw new TraceParseException("VulkanImageDiffAttachment with id " + imageId + " is not valid.");
        }
        this.imageId = imageId;
        this.width = width;
        this.height = height;
        this.layers = layers;
        this.format = format;
        this.bytesPerPixel = bytesPerPixel;
        this.priorImageInfo = priorImageInfo;
        this.priorImageId = priorImageId;
        this.blockSize = blockSize;
        this.data = data;
    }

    public long getImageId() {
        return this.imageId;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLayers() {
        return this.layers;
    }

    public int getFormat() {
        return this.format;
    }

    public int getBytesPerPixel() {
        return this.bytesPerPixel;
    }

    public PriorImageInfo getPriorImageInfo() {
        return this.priorImageInfo;
    }

    public @Nullable Long getPriorImageId() {
        return this.priorImageId;
    }

    public @Nullable Integer getBlockSize() {
        return this.blockSize;
    }

    public @Nullable IByteDataProvider getData() {
        return this.data;
    }

    public static enum PriorImageInfo {
        HAS_NO_PRIOR_IMAGE,
        HAS_PRIOR_IMAGE,
        IS_UNCHANGED_FROM_PRIOR_IMAGE;

    }
}

