/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.target.data.VulkanImageDiffAttachment;
import com.arm.mgd.core.target.marshaller.TraceParseException;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class VulkanImageCompositor {
    private Map<@NonNull VulkanImageDiffAttachment, AttachmentMetadata> attachmentMetadataMap = new ConcurrentHashMap<VulkanImageDiffAttachment, AttachmentMetadata>();
    private Map<@NonNull Long, AttachmentMetadata> imageIdMetadataMap = new ConcurrentHashMap<Long, AttachmentMetadata>();

    public void addImageDiffAttachment(@NonNull VulkanImageDiffAttachment diffData) throws TraceParseException {
        IByteDataProvider data = diffData.getData();
        AttachmentMetadata priorImageMetadata = null;
        switch (diffData.getPriorImageInfo()) {
            case HAS_NO_PRIOR_IMAGE: {
                long expectedNumBytes = diffData.getWidth() * diffData.getHeight() * diffData.getLayers() * diffData.getBytesPerPixel();
                if (data == null) {
                    throw new TraceParseException("Vulkan image diff with no prior image had no attached data. Expected " + expectedNumBytes + " bytes");
                }
                if ((long)data.getLength() == expectedNumBytes) break;
                throw new TraceParseException("Vulkan image diff with no prior image had " + data.getLength() + " bytes of data. Expected " + expectedNumBytes + " bytes");
            }
            case HAS_PRIOR_IMAGE: 
            case IS_UNCHANGED_FROM_PRIOR_IMAGE: {
                Long priorImageId = (Long)NullUtils.neverNull((Object)diffData.getPriorImageId());
                priorImageMetadata = this.imageIdMetadataMap.get(priorImageId);
                if (priorImageMetadata == null) {
                    throw new TraceParseException("Could not find prior Vulkan image with id: " + priorImageId + ".");
                }
                if (diffData.getWidth() == priorImageMetadata.diffData.getWidth() && diffData.getHeight() == priorImageMetadata.diffData.getHeight() && diffData.getLayers() == priorImageMetadata.diffData.getLayers() && diffData.getFormat() == priorImageMetadata.diffData.getFormat() && diffData.getBytesPerPixel() == priorImageMetadata.diffData.getBytesPerPixel()) break;
                throw new TraceParseException("Vulkan image diff and prior image do not have matching dimensions and format");
            }
            default: {
                throw new AssertionError((Object)diffData.getPriorImageInfo());
            }
        }
        AttachmentMetadata imageMetadata = null;
        if (diffData.getPriorImageInfo() == VulkanImageDiffAttachment.PriorImageInfo.IS_UNCHANGED_FROM_PRIOR_IMAGE) {
            assert (priorImageMetadata != null);
            imageMetadata = priorImageMetadata;
        } else {
            imageMetadata = new AttachmentMetadata(diffData, priorImageMetadata);
        }
        assert (imageMetadata != null);
        @Nullable AttachmentMetadata oldAttachmentMetadata = this.attachmentMetadataMap.put(diffData, imageMetadata);
        @Nullable AttachmentMetadata oldIdAttachmentMetadata = this.imageIdMetadataMap.put(NullUtils.longValueOf((long)diffData.getImageId()), imageMetadata);
        if (oldAttachmentMetadata != null) {
            throw new TraceParseException("Image attachment added more than once to Vulkan image compositor");
        }
        if (oldIdAttachmentMetadata != null) {
            throw new TraceParseException("Vulkan image diff has duplicate image ID to another diff");
        }
    }

    public @NonNull IByteDataProvider getCompositedData(@NonNull VulkanImageDiffAttachment imageDiffAttachment) throws IImageProvider.ImageDataUnavailableException {
        @Nullable AttachmentMetadata attachmentMetadata = this.attachmentMetadataMap.get(imageDiffAttachment);
        if (attachmentMetadata == null) {
            throw new IImageProvider.ImageDataUnavailableException("Could not get Vulkan image diff metadata for " + imageDiffAttachment);
        }
        IByteDataProvider cachedComposite = attachmentMetadata.getCachedComposite();
        if (cachedComposite != null) {
            return cachedComposite;
        }
        ArrayList<@NonNull AttachmentMetadata> diffChain = new ArrayList<AttachmentMetadata>();
        AttachmentMetadata currentMetadata = attachmentMetadata;
        do {
            diffChain.add(currentMetadata);
        } while ((currentMetadata = currentMetadata.priorImageMetadata) != null);
        int startImageIndex = -1;
        IByteDataProvider cachedCompositeProvider = null;
        int i = 1;
        while (i < diffChain.size()) {
            AttachmentMetadata metadata = (AttachmentMetadata)diffChain.get(i);
            cachedCompositeProvider = metadata.getCachedComposite();
            if (cachedCompositeProvider != null) {
                startImageIndex = i - 1;
                break;
            }
            ++i;
        }
        assert (cachedCompositeProvider != null);
        assert (startImageIndex >= 0);
        byte @NonNull [] composite = cachedCompositeProvider.cloneData();
        int imageIndex = startImageIndex;
        while (imageIndex >= 0) {
            VulkanImageCompositor.applyDiff(composite, (AttachmentMetadata)diffChain.get(imageIndex));
            --imageIndex;
        }
        IByteDataProvider finalComposite = IByteDataProvider.createMemoryProvider(composite);
        attachmentMetadata.setCachedComposite(finalComposite);
        return finalComposite;
    }

    private static void applyDiff(byte[] composite, @NonNull AttachmentMetadata metadata) {
        VulkanImageDiffAttachment data = metadata.diffData;
        assert (data.getPriorImageInfo() == VulkanImageDiffAttachment.PriorImageInfo.HAS_PRIOR_IMAGE);
        assert (metadata.priorImageMetadata != null);
        assert (composite.length == data.getHeight() * data.getWidth() * data.getLayers() * data.getBytesPerPixel());
        IByteDataProvider provider = data.getData();
        assert (provider != null);
        int blockSize = (Integer)NullUtils.neverNull((Object)data.getBlockSize());
        int bytesPerPixel = data.getBytesPerPixel();
        int width = data.getWidth();
        int height = data.getHeight();
        long imgLineSize = width * bytesPerPixel;
        long horizontalBlocks = (width + blockSize - 1) / blockSize;
        long verticalBlocks = (height + blockSize - 1) / blockSize;
        long layerBlocks = horizontalBlocks * verticalBlocks;
        ByteBuffer bytes = provider.getData();
        bytes.order(ByteOrder.LITTLE_ENDIAN);
        int srcOffset = 0;
        while (srcOffset < provider.getLength()) {
            bytes.position(srcOffset);
            long blockId = bytes.getInt() & 0xFFFFFFFF;
            long layerBlockId = blockId % layerBlocks;
            srcOffset = bytes.position();
            long y = layerBlockId / horizontalBlocks * (long)blockSize;
            long x = layerBlockId % horizontalBlocks * (long)blockSize;
            long z = blockId / layerBlocks;
            long remainingPixelsX = (long)width - x;
            long remainingPixelsY = (long)height - y;
            long imgOffset = (z * (long)height * (long)width + y * (long)width + x) * (long)bytesPerPixel;
            long thisBlockWidth = Math.min((long)blockSize, remainingPixelsX);
            long thisBlockHeight = Math.min((long)blockSize, remainingPixelsY);
            long blockLineLength = thisBlockWidth * (long)bytesPerPixel;
            int j = 0;
            while ((long)j < thisBlockHeight) {
                bytes.position(srcOffset);
                bytes.get(composite, (int)imgOffset, (int)blockLineLength);
                srcOffset = (int)((long)srcOffset + blockLineLength);
                imgOffset += imgLineSize;
                ++j;
            }
        }
    }

    private static class AttachmentMetadata {
        public final @NonNull VulkanImageDiffAttachment diffData;
        public final @Nullable AttachmentMetadata priorImageMetadata;
        private @NonNull AtomicReference<@Nullable WeakReference<@Nullable IByteDataProvider>> cachedComposite;

        public AttachmentMetadata(@NonNull VulkanImageDiffAttachment diffData, @Nullable AttachmentMetadata priorImageMetadata) {
            this.diffData = diffData;
            this.priorImageMetadata = priorImageMetadata;
            this.cachedComposite = new AtomicReference();
        }

        private @Nullable IByteDataProvider getCachedComposite() {
            if (this.priorImageMetadata == null) {
                IByteDataProvider byteData = this.diffData.getData();
                assert (byteData != null);
                return byteData;
            }
            WeakReference<@Nullable IByteDataProvider> compositeRef = this.cachedComposite.get();
            return compositeRef != null ? (IByteDataProvider)compositeRef.get() : null;
        }

        void setCachedComposite(@NonNull IByteDataProvider composite) {
            assert (this.priorImageMetadata != null);
            assert (composite.getLength() == this.diffData.getWidth() * this.diffData.getHeight() * this.diffData.getLayers() * this.diffData.getBytesPerPixel());
            this.cachedComposite.set(new WeakReference<IByteDataProvider>(composite));
        }
    }
}

