/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.data.AsynchronousDataModel;
import com.arm.mgd.core.target.data.VulkanImageDiffAttachment;
import com.arm.mgd.core.target.data.VulkanSubmitAttachment;
import com.arm.mgd.core.target.marshaller.TraceParseException;
import com.arm.mgd.core.util.CoreLogging;
import org.eclipse.jdt.annotation.NonNull;

public class VulkanFramebufferAttachment
extends VulkanSubmitAttachment {
    private final int attachmentIndex;
    private final @NonNull VulkanImageDiffAttachment imageDiff;

    public VulkanFramebufferAttachment(int attachmentIndex, @NonNull VulkanImageDiffAttachment imageDiff) {
        this.attachmentIndex = attachmentIndex;
        this.imageDiff = imageDiff;
    }

    public int getAttachmentIndex() {
        return this.attachmentIndex;
    }

    public VulkanImageDiffAttachment getImageDiff() {
        return this.imageDiff;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[attachment index=" + this.attachmentIndex + ", width=" + this.imageDiff.getWidth() + ", height=" + this.imageDiff.getHeight() + ", format=" + this.imageDiff.getFormat() + "]";
    }

    @Override
    public void process(@NonNull AsynchronousDataModel dataModel) {
        try {
            dataModel.getVulkanImageCompositor().addImageDiffAttachment(this.imageDiff);
        }
        catch (TraceParseException e) {
            CoreLogging.warning(null, e, null);
        }
    }
}

