/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.asset.VkDeviceMemoryAsset;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.AbstractByteDataFreeAttachment;
import com.arm.mgd.core.target.data.VkMemoryRegion;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.target.marshaller.TraceParseException;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class VulkanDeviceMemoryContentsAttachment
extends AbstractByteDataFreeAttachment {
    private static final long serialVersionUID = -5303825710915065926L;
    private final long device;
    private final long memory;
    private final long offset;

    public VulkanDeviceMemoryContentsAttachment(long device, long memory, long offset, @Nullable IByteDataProvider data) throws TraceParseException {
        super(data);
        this.device = device;
        this.memory = memory;
        this.offset = offset;
        if (data == null) {
            throw new TraceParseException("No data attached to VulkanDeviceMemoryContentsAttachment for device id " + device + ", memory id " + memory + ", and offset " + offset);
        }
    }

    @Override
    public @NonNull IByteDataProvider getData() {
        return (IByteDataProvider)NullUtils.neverNull((Object)super.getData());
    }

    public long getDevice() {
        return this.device;
    }

    public long getMemory() {
        return this.memory;
    }

    public long getOffset() {
        return this.offset;
    }

    @Override
    public void process(@NonNull TraceStateSnapshot currentState) {
        VkDeviceMemoryAsset memoryAsset = (VkDeviceMemoryAsset)currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.DEVICEMEMORY_TRAITS.SPEC).get((Long)this.getMemory());
        if (memoryAsset != null) {
            memoryAsset.addDataRegion(this.getParentFunctionCall(), new VkMemoryRegion(this));
        }
    }
}

