/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.asset.GlVertexAttributeAsset;
import com.arm.mgd.core.asset.GlVertexAttributeHelper;
import com.arm.mgd.core.target.data.AbstractByteDataFreeAttachment;
import com.arm.mgd.core.target.data.ApiUsageException;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.IVertexProvider;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.util.TraceAnalysisLogger;
import com.arm.mgd.core.util.UnsupportedTypeException;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class VertexBufferAttachment
extends AbstractByteDataFreeAttachment
implements IVertexProvider {
    private static final long serialVersionUID = 2815303619648988060L;
    public final @NonNull Long targetAttributeId;
    public final @NonNull AbstractConstantOrAliasSpecExtended valueType;
    public final int elementValueCount;
    public final int minimumIndex;

    public VertexBufferAttachment(@NonNull Long index, @NonNull AbstractConstantOrAliasSpecExtended elementType, int elementSize, @Nullable IByteDataProvider data, int minimumIndex) {
        super(data);
        this.targetAttributeId = index;
        this.valueType = elementType;
        this.elementValueCount = elementSize;
        this.minimumIndex = minimumIndex;
    }

    @Override
    public void process(TraceStateSnapshot currentState) {
        GlVertexAttributeAsset vertexAttributeAsset = GlVertexAttributeAsset.getVertexAttributeAssetById(currentState, (FunctionCall)NullUtils.neverNull((Object)currentState.getCurrentFunctionCall()), this.targetAttributeId);
        if (vertexAttributeAsset.getArraySize() != (long)this.elementValueCount) {
            TraceAnalysisLogger.warning(currentState, this.getParentFunctionCall(), "Unexpected buffer size (was " + vertexAttributeAsset.getArraySize() + " but was expecting " + this.elementValueCount + ").");
        }
        if (!vertexAttributeAsset.getArrayType().equals(this.valueType)) {
            TraceAnalysisLogger.warning(currentState, this.getParentFunctionCall(), "Unexpected buffer type (was " + vertexAttributeAsset.getArrayType() + " but was expecting " + this.valueType + ").");
        }
        vertexAttributeAsset.setClientVertexProvider(this);
    }

    @Override
    public @NonNull Number @Nullable [] getVertex(int index, long stride, long offset, long numberOfComponents, @NonNull AbstractConstantOrAliasSpecExtended type) throws UnsupportedTypeException {
        assert (index >= 0);
        assert (numberOfComponents == (long)this.elementValueCount);
        assert (type.equals(this.valueType));
        long elementSize = GlVertexAttributeHelper.getElementSize(numberOfComponents, type);
        byte @Nullable [] vertexBufferData = this.getVertexBufferData(index, (int)elementSize);
        return vertexBufferData != null ? type.getNumberArray(vertexBufferData) : null;
    }

    private byte @Nullable [] getVertexBufferData(int index, int elementSize) {
        IByteDataProvider provider = this.getData();
        if (provider == null) {
            return null;
        }
        int vertexOffset = (index - this.minimumIndex) * elementSize;
        if (vertexOffset <= provider.getLength() - elementSize && vertexOffset >= 0) {
            return provider.getRange(vertexOffset, vertexOffset + elementSize).cloneData();
        }
        return null;
    }

    @Override
    public void checkBounds(long offset) throws ApiUsageException {
    }
}

