/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.SynchronousTraceStateSnapshot;
import java.io.PrintWriter;
import java.io.Serializable;
import org.eclipse.jdt.annotation.NonNull;

public class TraceWriter {
    public static void write(@NonNull TraceDataModel model, @NonNull PrintWriter out) {
        StringBuilder sb = new StringBuilder();
        sb.append("Export generated from trace file: ").append(model.getModelName()).append('\n');
        out.println(sb.toString());
        SynchronousTraceStateSnapshot snapshot = new SynchronousTraceStateSnapshot(model);
        int i = 0;
        while (i < model.count()) {
            snapshot.setSelectedFunction(i);
            String returnValueAsString = null;
            sb.setLength(0);
            FunctionCall fc = model.getCallItem(i);
            sb.append(i).append('\t');
            sb.append("0x" + Long.toHexString(snapshot.getCurrentContext().getHandle())).append('\t');
            sb.append(fc.getPid()).append('\t');
            sb.append(fc.getTid()).append('\t');
            sb.append(fc.getTimestampStart()).append('\t');
            sb.append(fc.getTimestampStop()).append('\t');
            Serializable returnValue = fc.getReturnValue();
            if (returnValue != null) {
                returnValueAsString = returnValue.toString();
            }
            sb.append(returnValueAsString).append('\t');
            sb.append(fc.getFullNameAndArguments());
            out.println(sb.toString());
            ++i;
        }
    }
}

