/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.ITraceItem;
import com.arm.mgd.core.target.data.TargetEventDescriptor;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.lightweight.processors.IPushProcessor;
import com.arm.mgd.lightweight.processors.util.AbstractAsynchronousQueueingPushProcessor;
import com.arm.mgd.lightweight.processors.util.IQueueItemProcessor;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public class TraceDataModelProcessor
extends AbstractAsynchronousQueueingPushProcessor<ITraceItem, Processor> {
    private static final int QUEUE_SIZE = 10;

    public TraceDataModelProcessor(TraceDataModel model) {
        super((String)NullUtils.neverNull((Object)TraceDataModelProcessor.class.getSimpleName()), 10, new Processor(model));
    }

    @Override
    public @NonNull IPushProcessor<?> getParentProcessor() {
        return ((Processor)this.processor).model.getParentProcessTarget().getLightweightProcess().getProcessModelProcessor();
    }

    protected static class Processor
    implements IQueueItemProcessor<ITraceItem> {
        private final TraceDataModel model;

        public Processor(TraceDataModel model) {
            this.model = model;
        }

        @Override
        public boolean process(ITraceItem traceItem) {
            if (traceItem instanceof TargetEventDescriptor) {
                return false;
            }
            if (traceItem instanceof FunctionCall) {
                this.handleFunctionCall((FunctionCall)traceItem);
                return true;
            }
            throw new AssertionError((Object)("Unexpected trace item : " + traceItem.getClass() + " : " + traceItem));
        }

        private void handleFunctionCall(FunctionCall functionCall) {
            this.model.processIntoModel(functionCall);
        }
    }
}

