/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.asset.SourceAsset;
import com.arm.mgd.core.counters.Counters;
import com.arm.mgd.core.counters.PerFrameStatistics;
import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.ISerializationProxy;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.SerializableDependency;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.offlinecompiler.GlShaderCompiler;
import com.arm.mgd.core.offlinecompiler.GlShaderStats;
import com.arm.mgd.core.pb.v2.MgdProtosV2;
import com.arm.mgd.core.replay.AbstractFrameOverride;
import com.arm.mgd.core.replay.FrameOverrides;
import com.arm.mgd.core.target.data.AbstractFreeAttachment;
import com.arm.mgd.core.target.data.AbstractOverrideAttachment;
import com.arm.mgd.core.target.data.AsynchronousDataModel;
import com.arm.mgd.core.target.data.AutomatedTraceCommand;
import com.arm.mgd.core.target.data.AutomatedTraceCommandManager;
import com.arm.mgd.core.target.data.BookmarkModel;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.Frames;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.IFunctionCallModelListener;
import com.arm.mgd.core.target.data.TraceDataModelProcessor;
import com.arm.mgd.core.target.data.tracestatedata.PrimaryTraceStateSnapshot;
import com.arm.mgd.core.target.data.tracestatedata.SnapshotCache;
import com.arm.mgd.core.target.data.tracestatedata.SynchronousTraceStateSnapshot;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.target.io.ProcessTarget;
import com.arm.mgd.core.target.marshaller.bytedata.CompressedMemoryMappedByteStore;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallDescriptor;
import com.arm.mgd.core.target.marshaller.utils.Timestamp;
import com.arm.mgd.core.traceanalyses.TraceAnalysisModel;
import com.arm.mgd.core.util.ChildrenStatisticsCache;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreLoggingSource;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.core.util.IStatisticType;
import com.arm.mgd.core.util.ListenerList;
import com.arm.mgd.core.util.MemoryMonitor;
import com.arm.mgd.core.util.ReadOnlySubList;
import com.arm.mgd.core.util.Statistic;
import com.arm.mgd.core.util.TraceAnalysisLogger;
import com.arm.mgd.kapi.IAssetProcessingActionWithChildren;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.kapi.gen.AssetProcessingActionCreateSpec;
import com.arm.mgd.kapi.gen.AssetProcessingActionsGroupBaseSpec;
import com.arm.mgd.kapi.gen.AssetProcessingSpec;
import com.arm.mgd.lightweight.processors.IPushProcessor;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TraceDataModel
implements SerializableDependency,
ICoreLoggingSource,
INavigationElement<TraceDataModel> {
    private static final long serialVersionUID = 5231973604319231695L;
    public static final int NO_SELECTED_FUNCTION = -1;
    private final ListenerList<IFunctionCallModelListener> listeners = new ListenerList();
    private boolean containsGLES = false;
    private boolean containsEGL = false;
    private boolean containsCL = false;
    private boolean containsVULKAN = false;
    private final @NonNull Counters counters = new Counters();
    private final Map<AssetTableSpec, Long> maximumAssetIDCache = new HashMap<AssetTableSpec, Long>();
    private int lastIndex = -1;
    private final @NonNull PrimaryTraceStateSnapshot primarySnapshot;
    private int index = -1;
    private final @NonNull CompressedMemoryMappedByteStore snapshotByteStore;
    private final @NonNull SnapshotCache snapshotsCache;
    private static Map<Integer, TraceDataModel> allModelsCache = new HashMap<Integer, TraceDataModel>();
    private final @NonNull Frames frames = new Frames(this);
    private @NonNull String modelName;
    private final @NonNull BookmarkModel bookmarkModel = new BookmarkModel(this);
    private final @NonNull BookmarkModel.IBookmarkChangeListener bookmarkChangeListener;
    private final @NonNull AtomicBoolean bookmarksChangedSinceSave = new AtomicBoolean(false);
    private boolean closed = false;
    private final @NonNull FrameOverrides currentActiveOverrides = new FrameOverrides();
    private final @NonNull ProcessTarget parentTarget;
    private final boolean processStartedBeforeTracing;
    private boolean functionsAddedSinceSave;
    private final int processID;
    private final @NonNull PerFrameStatistics statistics = new PerFrameStatistics(this);
    private final @NonNull AsynchronousDataModel asynchronousDataModel = new AsynchronousDataModel();
    private final String originalVersion;
    private final @NonNull AtomicInteger processedFunctions = new AtomicInteger(0);
    private int contextGroupIdCounter = 0;
    private @NonNull String processName;
    private boolean completed;
    private boolean processRunning = true;
    private final @NonNull AutomatedTraceCommandManager automatedTraceCommandManager = new AutomatedTraceCommandManager();
    private final @NonNull TraceDataModelProcessor processor;
    private boolean nextFunctionIsReattachFunction = false;
    private boolean hasEverBeenReattached = false;
    private final transient @NonNull FunctionCall dummyFunctionCall;
    private static final int GL_SHADER_STATS_CACHE_MAX_SIZE = 5000;
    private final Map<SourceAsset.ISourceProvider, Map<GlShaderCompiler, GlShaderStats>> glShaderStatsCache = new LinkedHashMap<SourceAsset.ISourceProvider, Map<GlShaderCompiler, GlShaderStats>>(5000, 0.75f, true){
        private static final long serialVersionUID = -7639088999168362758L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<SourceAsset.ISourceProvider, Map<GlShaderCompiler, GlShaderStats>> eldest) {
            return this.size() > 5000;
        }
    };
    private final @NonNull List<@NonNull AbstractFreeAttachment> writeReplacedMidstreamAttachments = new ArrayList<AbstractFreeAttachment>();
    private final @NonNull Map<@NonNull AbstractFreeAttachment, Integer> writeReplacedMidstreamAttachmentsMap = new HashMap<AbstractFreeAttachment, Integer>();
    private final @NonNull ChildrenStatisticsCache statisticsCache = new ChildrenStatisticsCache(this);

    @Override
    public Object writeReplace() {
        return new SerializationProxy(this);
    }

    public TraceDataModel(@NonNull ProcessTarget processTarget, @NonNull String modelName, int processID, boolean processStartedBeforeTracing, @NonNull String processName, @NonNull String originalVersion) {
        this.parentTarget = processTarget;
        this.processID = processID;
        this.modelName = modelName;
        this.processName = processName;
        this.originalVersion = originalVersion;
        this.processStartedBeforeTracing = processStartedBeforeTracing;
        this.dummyFunctionCall = new DummyFunctionCall(this);
        this.primarySnapshot = new PrimaryTraceStateSnapshot(this);
        this.processor = new TraceDataModelProcessor(this);
        this.snapshotByteStore = new CompressedMemoryMappedByteStore(String.valueOf(processName) + "_TraceStateData");
        this.snapshotsCache = new SnapshotCache(this.snapshotByteStore);
        processTarget.getLightweightProcess().getProcessModelProcessor().addDependentProcessor(this.processor);
        TraceDataModel previous = allModelsCache.put(this.hashCode(), this);
        this.bookmarkChangeListener = new BookmarkModel.IBookmarkChangeListener(){

            @Override
            public boolean onBookmarksChange(@NonNull TraceDataModel model, @NonNull Map<@NonNull FunctionCall, @Nullable BookmarkModel.Bookmark> modifiedBookmarks) {
                TraceDataModel.this.bookmarksChangedSinceSave.set(true);
                return true;
            }
        };
        this.bookmarkModel.addListener(null, this.bookmarkChangeListener);
        assert (previous == null);
    }

    public void addListener(@NonNull IFunctionCallModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(@NonNull IFunctionCallModelListener listener) {
        this.listeners.remove(listener);
    }

    static @Nullable TraceDataModel findCachedModelByHashCode(int hashCode) {
        return allModelsCache.get(hashCode);
    }

    public @NonNull String getModelName() {
        return this.modelName;
    }

    public void add(@NonNull FunctionCall fcToAdd) {
        assert (fcToAdd.getModel() == this);
        KapiSpec spec = fcToAdd.getFunctionSpec().getKapiSpec();
        if (spec != null) {
            this.updateModelAPIContents(spec);
        }
        this.insertIntoProcessorChain(fcToAdd);
        this.waitForFunctionToBeProcessed(fcToAdd);
    }

    private void updateModelAPIContents(@NonNull KapiSpec fcSpec) {
        if (fcSpec.equals(KapiSpec.GLES)) {
            this.containsGLES = true;
        } else if (fcSpec.equals(KapiSpec.EGL)) {
            this.containsEGL = true;
        } else if (fcSpec.equals(KapiSpec.CL)) {
            this.containsCL = true;
        } else if (fcSpec.equals(KapiSpec.VULKAN)) {
            this.containsVULKAN = true;
        }
    }

    public boolean containsGLES() {
        return this.containsGLES;
    }

    public boolean containsEGL() {
        return this.containsEGL;
    }

    public boolean containsCL() {
        return this.containsCL;
    }

    public boolean containsVULKAN() {
        return this.containsVULKAN;
    }

    public boolean containsOnlyGLESAndEGL() {
        return this.containsGLES && this.containsEGL && !this.containsCL && !this.containsVULKAN;
    }

    public boolean containsOnlyCL() {
        return this.containsCL && !this.containsEGL && !this.containsGLES && !this.containsVULKAN;
    }

    public void waitForFunctionToBeProcessed(@NonNull FunctionCall fcToWaitOn) {
        assert (fcToWaitOn.getModel() == this);
        boolean success = IPushProcessor.waitForFunctionCallToBeProcessed(this.processor, fcToWaitOn, () -> this.isClosed() || this.completed);
        if (success) {
            while (this.count() <= fcToWaitOn.getIndex()) {
            }
        }
    }

    public void insertIntoProcessorChain(@NonNull FunctionCall fcToAdd) {
        assert (!this.closed);
        assert (!this.completed);
        assert (this.processRunning);
        assert (fcToAdd.getPid() == this.processID);
        KapiSpec spec = fcToAdd.getFunctionSpec().getKapiSpec();
        if (spec != null) {
            this.updateModelAPIContents(spec);
        }
        try {
            this.parentTarget.getLightweightProcess().getProcessModelProcessor().enqueueItem(fcToAdd);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        @Nullable Integer asynchronousFunctionCallUid = fcToAdd.getAsynchronousFunctionCallUid();
        if (asynchronousFunctionCallUid != null) {
            this.asynchronousDataModel.addFunctionUIDToWaitingSet(asynchronousFunctionCallUid);
        }
        this.functionsAddedSinceSave = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processIntoModel(@NonNull FunctionCall fcToAdd) {
        Frame latestFrame;
        TraceStateSnapshot latestSnapshot;
        block28: {
            int numProcessed;
            assert (this.parentTarget.getLightweightProcess().containsFunctionCall(fcToAdd));
            KapiSpec spec = fcToAdd.getFunctionSpec().getKapiSpec();
            if (spec != null) {
                this.updateModelAPIContents(spec);
            }
            latestSnapshot = this.primarySnapshot.getSnapshot();
            try {
                this.frames.setFunctionCallFrame(fcToAdd);
                int newIndex = this.primarySnapshot.moveToNextFunction();
                assert (newIndex == fcToAdd.getIndex());
                this.frames.calculateFrameEnd(fcToAdd, latestSnapshot);
                Set<AssetTableSpec> affectedAssetTables = TraceDataModel.collectAssetTablesForCachingMaxIDFromFunctionSpec(fcToAdd.getFunctionSpec());
                if (affectedAssetTables != null) {
                    this.cacheMaximumAssetIDs(affectedAssetTables);
                }
                fcToAdd.getFunctionSpec().processCounters(latestSnapshot, fcToAdd);
                Frame parentFrame = (Frame)NullUtils.neverNull((Object)fcToAdd.getParentFrame());
                for (AbstractOverrideAttachment overrideAttachment : fcToAdd.getFrameOverrides()) {
                    AbstractFrameOverride override = overrideAttachment.process(latestSnapshot);
                    parentFrame.getFrameOverrides().add(override);
                }
            }
            catch (OutOfMemoryError e) {
                CoreLogging.userMessageReportOnce(null, Level.SEVERE, (String)NullUtils.neverNull((Object)MemoryMonitor.CRITICAL_MEMORY_USER_MESSAGE));
                CoreLogging.warning(null, "Ran out of memory while processing the trace. Please consider increasing the heap size.");
                numProcessed = this.processedFunctions.incrementAndGet();
                assert (fcToAdd.getIndex() == numProcessed - 1);
                break block28;
            }
            catch (Throwable t) {
                try {
                    CoreLogging.userMessageReportOnce(null, Level.SEVERE, "One or more exceptions were thrown while processing function calls. Check the Console View for more information.");
                    CoreLogging.warning(this, t, "Caught exception while adding function call " + fcToAdd.getLabelText());
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    numProcessed = this.processedFunctions.incrementAndGet();
                    assert (fcToAdd.getIndex() == numProcessed - 1);
                    break block28;
                }
            }
            numProcessed = this.processedFunctions.incrementAndGet();
            if ($assertionsDisabled || fcToAdd.getIndex() == numProcessed - 1) break block28;
            throw new AssertionError();
        }
        if ((latestFrame = this.frames.getLatestFrame()).isTheChildrenListFinal()) {
            ArrayList<AutomatedTraceCommand> copiedList = new ArrayList<AutomatedTraceCommand>(this.automatedTraceCommandManager.getAutomatedTraceCommands());
            for (AutomatedTraceCommand atc : copiedList) {
                if (atc.getFrameNumber() - 1 > latestFrame.getId()) continue;
                switch (atc.getCommandType()) {
                    case FRAME_CAPTURE: {
                        if (this.containsVULKAN || this.containsGLES) break;
                        TraceAnalysisLogger.warning(latestSnapshot, null, "Automated Trace Command cannot capture a frame in a non-Vulkan/OpenGL ES trace.");
                        break;
                    }
                    case OVERDRAW_CAPTURE: {
                        if (this.containsGLES) break;
                        TraceAnalysisLogger.warning(latestSnapshot, null, "Automated Trace Command Overdraw capture is not supported in a non-OpenGL ES trace.");
                        break;
                    }
                    case FRAGMENT_COUNT_CAPTURE: {
                        if (this.containsGLES) break;
                        TraceAnalysisLogger.warning(latestSnapshot, null, "Automated Trace Command fragment count capture is not supported in a non-OpenGL ES trace.");
                        break;
                    }
                    case SHADER_MAP_CAPTURE: {
                        if (this.containsGLES) break;
                        TraceAnalysisLogger.warning(latestSnapshot, null, "Automated Trace Command Shadermap capture is not supported in a non-OpenGL ES trace.");
                        break;
                    }
                    case ALL_ATTACHMENTS_CAPTURE: {
                        if (this.containsGLES) break;
                        TraceAnalysisLogger.warning(latestSnapshot, null, "Automated Trace Command All Attachments capture is not supported in a non-OpenGL ES trace.");
                        break;
                    }
                    case PAUSE: 
                    case TERMINATE: {
                        break;
                    }
                    default: {
                        TraceAnalysisLogger.warning(latestSnapshot, null, (String)NullUtils.neverNull((Object)String.format("Unrecognised Automated Trace Command : %s.", atc.getCommandType().name())));
                    }
                }
                this.automatedTraceCommandManager.deleteAutomatedCommand(atc);
            }
        }
        TraceDataModel traceDataModel = this;
        synchronized (traceDataModel) {
            if (this.nextFunctionIsReattachFunction) {
                this.nextFunctionIsReattachFunction = false;
                this.addHostAttachedBookmark(fcToAdd);
            }
        }
    }

    private static Set<AssetTableSpec> collectAssetTablesForCachingMaxIDFromFunctionSpec(IFunctionOrAliasSpecExtended functionSpec) {
        if (!functionSpec.hasAssetProcessorMethod()) {
            return null;
        }
        HashSet<AssetTableSpec> affectedAssetTableSpecs = new HashSet<AssetTableSpec>();
        TraceDataModel.addAffectsAssetTableSpecsThatAffectMaxID(affectedAssetTableSpecs, functionSpec.getAsFunctionSpec().getAssetProcessing());
        if (affectedAssetTableSpecs.size() == 0) {
            return null;
        }
        return affectedAssetTableSpecs;
    }

    private static void addAffectsAssetTableSpecsThatAffectMaxID(@NonNull Set<AssetTableSpec> interestingTables, AssetProcessingSpec affectsAssetSpec) {
        if (affectsAssetSpec != null) {
            TraceDataModel.addAffectsAssetTableSpecsThatAffectMaxID(interestingTables, affectsAssetSpec.getWhenOrCreateOrUsing());
        }
    }

    private static void addAffectsAssetTableSpecsThatAffectMaxID(@NonNull Set<AssetTableSpec> interestingTables, List<AssetProcessingActionsGroupBaseSpec> actions) {
        for (AssetProcessingActionsGroupBaseSpec action : actions) {
            AssetProcessingActionCreateSpec createSpec;
            AssetTableSpec assetTableSpec;
            if (action instanceof AssetProcessingActionCreateSpec && (assetTableSpec = (createSpec = (AssetProcessingActionCreateSpec)action).getAssetTable()).isCacheMaxID()) {
                interestingTables.add(assetTableSpec);
            }
            if (!(action instanceof IAssetProcessingActionWithChildren)) continue;
            TraceDataModel.addAffectsAssetTableSpecsThatAffectMaxID(interestingTables, ((IAssetProcessingActionWithChildren)((Object)action)).getChildActions());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheMaximumAssetIDs(Set<AssetTableSpec> affectedAssetTables) {
        Map<AssetTableSpec, Long> map = this.maximumAssetIDCache;
        synchronized (map) {
            for (AssetTableSpec assetTableSpec : affectedAssetTables) {
                Long currentMaxID;
                AssetTable assetTable = this.primarySnapshot.getSnapshot().getAssetTableBySpec(assetTableSpec);
                Long tableMax = assetTable.getMaximumID();
                if (tableMax == null || (currentMaxID = this.maximumAssetIDCache.get(assetTableSpec)) != null && currentMaxID >= tableMax) continue;
                this.maximumAssetIDCache.put(assetTableSpec, tableMax);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getMaximumAssetID(AssetTableSpec assetTableSpec) {
        Map<AssetTableSpec, Long> map = this.maximumAssetIDCache;
        synchronized (map) {
            return this.maximumAssetIDCache.get(assetTableSpec);
        }
    }

    public @NonNull FunctionCall getCallItem(int dataIndex) throws IndexOutOfBoundsException {
        if (dataIndex == -1) {
            return this.dummyFunctionCall;
        }
        return this.parentTarget.getLightweightProcess().getFunctionCall(dataIndex);
    }

    public @NonNull FunctionCall getMostRecentCallItem() {
        int numProcessed = this.processedFunctions.get();
        return numProcessed == 0 ? this.dummyFunctionCall : this.getCallItem(numProcessed - 1);
    }

    @Deprecated
    public int internalCount() {
        return this.parentTarget.getLightweightProcess().getFunctionCallCount();
    }

    public int count() {
        return this.processedFunctions.get();
    }

    public @NonNull Counters getCounters() {
        return this.counters;
    }

    public @NonNull List<@NonNull FunctionCall> getCallItems(int firstIndex, int length) {
        return this.parentTarget.getLightweightProcess().getSubList(firstIndex, firstIndex + length);
    }

    public @NonNull PerFrameStatistics getStatistics() {
        return this.statistics;
    }

    public @NonNull TraceAnalysisModel getTraceAnalysisModel() {
        return this.primarySnapshot.getTraceAnalysisModel();
    }

    public void setProcessStarted() {
        this.processRunning = true;
    }

    public void setProcessEnded() {
        this.processRunning = false;
    }

    public void setInputComplete() {
        if (!this.completed) {
            this.completed = true;
            this.processRunning = false;
            for (IFunctionCallModelListener listener : this.listeners) {
                listener.onFunctionCallModelComplete(this);
            }
            this.automatedTraceCommandManager.clearCommands();
            if (!this.getParentProcessTarget().getParentTarget().isLiveTarget()) {
                this.clearModifiedSinceLastSave();
            }
        }
    }

    public @NonNull SynchronousTraceStateSnapshot createLatestSnapshot() {
        return new SynchronousTraceStateSnapshot(this, this.count() - 1);
    }

    public @NonNull Frames getFrames() {
        return this.frames;
    }

    public @NonNull List<@NonNull Integer> findContaining(@NonNull Pattern regex) {
        return this.findContaining(regex, 0, this.count(), ICoreProgressMonitor.NULL_MONITOR, false);
    }

    public @NonNull List<@NonNull Integer> findContaining(@NonNull Pattern regex, int startIndex, int lastIndexExclusive, @NonNull ICoreProgressMonitor monitor, boolean includeParameters) {
        ArrayList<@NonNull Integer> matchList = new ArrayList<Integer>();
        assert (regex != null);
        assert (startIndex >= 0);
        assert (startIndex <= lastIndexExclusive);
        assert (lastIndexExclusive <= this.count());
        int i = startIndex;
        while (i < lastIndexExclusive && !monitor.isCancelled()) {
            String fcName;
            String string = fcName = includeParameters ? this.getCallItem(i).getFullNameAndArguments() : this.getCallItem(i).getFunctionSpec().getName();
            if (regex.matcher(fcName).find()) {
                matchList.add(NullUtils.intValueOf((int)i));
            }
            monitor.incProgress(1);
            ++i;
        }
        return matchList;
    }

    public String getOriginalVersion() {
        return this.originalVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(@NonNull ICoreProgressMonitor monitor) {
        TraceDataModel traceDataModel = this;
        synchronized (traceDataModel) {
            this.closed = true;
        }
        for (IFunctionCallModelListener closeListener : this.listeners) {
            closeListener.onFunctionCallModelClose(this, monitor);
        }
        allModelsCache.remove(this.hashCode());
        this.snapshotByteStore.dispose();
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public SnapshotCache getSnapshotsCache() {
        return this.snapshotsCache;
    }

    public void setModelName(@NonNull String modelName) {
        this.modelName = modelName;
    }

    public synchronized int allocateNewContextGroupId() {
        return this.contextGroupIdCounter++;
    }

    public @NonNull FrameOverrides getCurrentActiveOverrides() {
        return this.currentActiveOverrides;
    }

    public @NonNull String getProcessName() {
        return this.processName;
    }

    @Override
    public String getCoreLoggingSourceKey() {
        return this.parentTarget.getCoreLoggingSourceKey();
    }

    public boolean processStartedBeforeTracing() {
        return this.processStartedBeforeTracing;
    }

    public @NonNull ProcessTarget getParentProcessTarget() {
        return this.parentTarget;
    }

    public boolean hasBeenModifiedSinceLastSave() {
        return this.functionsAddedSinceSave || this.bookmarksChangedSinceSave.get();
    }

    public void clearModifiedSinceLastSave() {
        this.functionsAddedSinceSave = false;
        this.bookmarksChangedSinceSave.set(false);
    }

    public int getProcessID() {
        return this.processID;
    }

    public @NonNull String getIdentifierString() {
        return String.valueOf(this.processName) + " (" + this.getIndexWithinParent() + ")";
    }

    private int getIndexWithinParent() {
        return this.parentTarget.getParentTarget().getModels().indexOf(this);
    }

    @Override
    public String getLabelText() {
        return this.getIdentifierString();
    }

    @Override
    public @NonNull String getLongLabelText() {
        return "Process " + this.getLabelIndex() + " (" + this.processName + ")";
    }

    @Override
    public @NonNull String getToolTipText() {
        return String.valueOf(this.getLongLabelText()) + " PID: " + this.processID;
    }

    @Override
    public int getLabelIndex() {
        return this.getIndexWithinParent();
    }

    public @NonNull FunctionCall createFunction(@NonNull FunctionCallDescriptor functionCallDescriptor) {
        assert (this.processID == functionCallDescriptor.getProcessId());
        return FunctionCall.create(++this.lastIndex, functionCallDescriptor, this);
    }

    @Override
    public @NonNull List<@NonNull Frame> getChildren() {
        return new ReadOnlySubList<Frame>(this.getFrames().getFramesList());
    }

    @Override
    public boolean isTheChildrenListFinal() {
        return this.completed;
    }

    public int getIndex() {
        if (this.index == -1) {
            this.index = this.getParentProcessTarget().getParentTarget().getModels().indexOf(this);
        }
        return this.index;
    }

    @Override
    public int compareTo(TraceDataModel o) {
        return Integer.compare(this.getIndex(), o.getIndex());
    }

    @Override
    public boolean hasDataForStatisticType(@NonNull IStatisticType type) {
        return this.statisticsCache.hasDataForStatisticType(type);
    }

    @Override
    public @NonNull Statistic getStatistic(@NonNull IStatisticType type) {
        return this.statisticsCache.getStat(type);
    }

    public @NonNull AutomatedTraceCommandManager getAutomatedTraceCommandManager() {
        return this.automatedTraceCommandManager;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isProcessRunning() {
        return this.processRunning;
    }

    public @NonNull BookmarkModel getBookmarkModel() {
        return this.bookmarkModel;
    }

    private void addHostAttachedBookmark(@NonNull FunctionCall functionCall) {
        if (this.bookmarkModel.getBookmark(functionCall) == null) {
            this.bookmarkModel.addBookmark(functionCall, "Host reattached");
        }
    }

    public synchronized void onTracingReattachedEvent() {
        this.nextFunctionIsReattachFunction = true;
        this.frames.onTracingReattachedEvent();
        this.hasEverBeenReattached = true;
    }

    public void onTracingDetachedEvent() {
    }

    public boolean hasEverBeenReattached() {
        return this.hasEverBeenReattached;
    }

    public @NonNull AsynchronousDataModel getAsynchronousDataModel() {
        return this.asynchronousDataModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull CompletableFuture<@NonNull GlShaderStats> getGlShaderStats(@NonNull GlShaderAsset shaderAsset, @NonNull GlShaderCompiler shaderCompiler) {
        Map<Object, Object> statsMap;
        assert (shaderAsset.getCreatedByFunction().getModel() == this);
        @Nullable SourceAsset.ISourceProvider sourceProvider = shaderAsset.getSourceProvider();
        if (sourceProvider == null) {
            return (CompletableFuture)NullUtils.neverNull(CompletableFuture.completedFuture(GlShaderStats.FAILED_TO_RUN_COMPILER_SHADER_STATS));
        }
        Map<SourceAsset.ISourceProvider, Map<GlShaderCompiler, GlShaderStats>> map = this.glShaderStatsCache;
        synchronized (map) {
            Map<GlShaderCompiler, GlShaderStats> compilerStatsMap = this.glShaderStatsCache.get(sourceProvider);
            if (compilerStatsMap != null) {
                GlShaderStats stats = compilerStatsMap.get(shaderCompiler);
                if (stats != null) {
                    return (CompletableFuture)NullUtils.neverNull(CompletableFuture.completedFuture(stats));
                }
                statsMap = compilerStatsMap;
            } else {
                statsMap = new HashMap(1);
                this.glShaderStatsCache.put(sourceProvider, statsMap);
            }
        }
        CompletableFuture<@NonNull GlShaderStats> future = shaderCompiler.compile(sourceProvider.getConcatenatedString(), shaderAsset.getType());
        return (CompletableFuture)NullUtils.neverNull((Object)future.handle((shaderStats, error) -> {
            assert (error == null);
            assert (shaderStats != null);
            Map<SourceAsset.ISourceProvider, Map<GlShaderCompiler, GlShaderStats>> map2 = this.glShaderStatsCache;
            synchronized (map2) {
                statsMap.put(shaderCompiler, shaderStats);
            }
            return shaderStats;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeReplaceMidstreamFreeAttachment(@NonNull AbstractFreeAttachment midstreamFreeAttachment) {
        assert (midstreamFreeAttachment.getParentFunctionCall().hasMidstreamTraceData());
        assert (midstreamFreeAttachment.getParentFunctionCall().getModel() == this);
        Map<AbstractFreeAttachment, Integer> map = this.writeReplacedMidstreamAttachmentsMap;
        synchronized (map) {
            Integer existingIndex = this.writeReplacedMidstreamAttachmentsMap.get(midstreamFreeAttachment);
            if (existingIndex != null) {
                return existingIndex;
            }
            this.writeReplacedMidstreamAttachments.add(midstreamFreeAttachment);
            int attachmentIndex = this.writeReplacedMidstreamAttachments.size() - 1;
            this.writeReplacedMidstreamAttachmentsMap.put(midstreamFreeAttachment, NullUtils.intValueOf((int)attachmentIndex));
            return attachmentIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull AbstractFreeAttachment readResolveMidstreamFreeAttachment(int attachmentIndex) {
        Map<AbstractFreeAttachment, Integer> map = this.writeReplacedMidstreamAttachmentsMap;
        synchronized (map) {
            return this.writeReplacedMidstreamAttachments.get(attachmentIndex);
        }
    }

    public String toString() {
        return "TraceDataModel [getModelName()=" + this.getModelName() + ", containsGLES()=" + this.containsGLES() + ", containsEGL()=" + this.containsEGL() + ", containsCL()=" + this.containsCL() + ", containsVULKAN()=" + this.containsVULKAN() + ", containsOnlyGLESAndEGL()=" + this.containsOnlyGLESAndEGL() + ", containsOnlyCL()=" + this.containsOnlyCL() + ", getMostRecentCallItem()=" + this.getMostRecentCallItem() + ", getOriginalVersion()=" + this.getOriginalVersion() + ", getProcessName()=" + this.getProcessName() + ", processStartedBeforeTracing()=" + this.processStartedBeforeTracing() + ", hasBeenModifiedSinceLastSave()=" + this.hasBeenModifiedSinceLastSave() + ", getProcessID()=" + this.getProcessID() + ", getIdentifierString()=" + this.getIdentifierString() + ", getLabelText()=" + this.getLabelText() + ", getLongLabelText()=" + this.getLongLabelText() + ", getToolTipText()=" + this.getToolTipText() + ", getLabelIndex()=" + this.getLabelIndex() + ", getChildren()=" + this.getChildren() + ", isTheChildrenListFinal()=" + this.isTheChildrenListFinal() + ", getIndex()=" + this.getIndex() + ", isCompleted()=" + this.isCompleted() + ", isProcessRunning()=" + this.isProcessRunning() + ", hasEverBeenReattached()=" + this.hasEverBeenReattached() + "]";
    }

    public static class DummyFunctionCall
    extends FunctionCall {
        private static final long serialVersionUID = -4010571912210960866L;
        private final @NonNull TraceDataModel model;

        public DummyFunctionCall(@NonNull TraceDataModel model) {
            super(0, new FunctionCallDescriptor(0, 0L, new Timestamp(0L), new Timestamp(0L), KapiSpec.getDefaultFunction("DummyFunctionCall"), 0, null, NullUtils.EMPTY_LIST, false, (List)NullUtils.neverNull(Arrays.asList(MgdProtosV2.FunctionCallFlagsEnumProto.FC_FLAG_HIDDEN_FUNCTION)), null, NullUtils.EMPTY_LIST, NullUtils.EMPTY_SET, NullUtils.EMPTY_LIST, null), model);
            this.model = model;
        }

        @Override
        public @Nullable Frame getParentFrame() {
            return this.model.getFrames().getFramesList().get(0);
        }
    }

    private static class SerializationProxy
    implements ISerializationProxy {
        private static final long serialVersionUID = 4706399610497183204L;
        private final int hashCode;

        SerializationProxy(TraceDataModel traceDataModel) {
            this.hashCode = traceDataModel.hashCode();
        }

        @Override
        public Object readResolve() {
            return TraceDataModel.findCachedModelByHashCode(this.hashCode);
        }
    }
}

