/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.data.TargetEventAttachment;
import com.arm.mgd.core.target.data.TargetEventDescriptor;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.util.CoreLogging;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TargetEvent {
    private final @NonNull TargetEventType eventType;
    private final @NonNull List<@NonNull TargetEventAttachment> attachments;

    public TargetEvent(AbstractTarget target, @NonNull TargetEventDescriptor targetEventDescriptor) {
        this.eventType = targetEventDescriptor.getEventType();
        this.attachments = targetEventDescriptor.getAttachments();
        if (this.eventType.shouldBeLogged()) {
            CoreLogging.info(target, "Target event: " + (Object)((Object)this.eventType) + ", " + this.attachments);
        }
    }

    public TargetEventType getEventType() {
        return this.eventType;
    }

    public List<@NonNull TargetEventAttachment> getAttachments() {
        return this.attachments;
    }

    public <T extends TargetEventAttachment> @Nullable T findAttachment(Class<T> clazz) {
        for (TargetEventAttachment attachment : this.attachments) {
            if (!clazz.isAssignableFrom(attachment.getClass())) continue;
            return (T)attachment;
        }
        return null;
    }

    public static enum TargetEventType {
        FRAME_CAPTURE_WAITING,
        FRAME_CAPTURE_STARTED,
        FRAME_CAPTURE_FINISHED,
        TRACING_SUSPENDED,
        TRACING_RESUMED,
        PROCESS_FINISHED,
        MODIFY_STATE_OVERDRAW_ENABLED,
        MODIFY_STATE_OVERDRAW_DISABLED,
        PROCESS_STARTED,
        DAEMON_INTERCEPTOR_VERSION_ERROR,
        END_FRAME_REPLAY,
        FILMSTRIP_MODE_ENABLED,
        FILMSTRIP_MODE_DISABLED,
        SEND_INPUT_BUFFERS_CHANGED_DEPRECATED,
        SEND_OUTPUT_BUFFERS_ENABLED,
        SEND_OUTPUT_BUFFERS_DISABLED,
        INTERCEPTOR_EXECUTION_STATE_UPDATE,
        MIDSTREAM_DATA,
        ASYNCHRONOUS_FUNCTION_CALL_DATA,
        AUTHORISATION_REQUEST,
        CONNECTION_REQUEST,
        DEVICE_INFO,
        INTERCEPTOR_CONFIGURATION,
        AUTHORISATION_FEATURE_USED;


        public boolean shouldBeLogged() {
            return !this.equals((Object)ASYNCHRONOUS_FUNCTION_CALL_DATA);
        }
    }
}

