/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.asset.SourceAsset;
import com.arm.mgd.core.target.data.ArgumentHierarchyBranch;
import com.arm.mgd.core.target.data.ArgumentHierarchyLeaf;
import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import com.arm.mgd.core.target.data.ObjectArrayArgumentAttachment;
import com.arm.mgd.kapi.gen.FormatSpec;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class StringsArgAttachment
extends ObjectArrayArgumentAttachment<String>
implements SourceAsset.ISourceProvider {
    private static final long serialVersionUID = 154326588749127408L;
    private static final @NonNull WeakHashMap<@NonNull List<@NonNull String>, @Nullable WeakReference<@NonNull List<@NonNull String>>> stringListCache = new WeakHashMap();

    public static @NonNull StringsArgAttachment create(List<String> stringsList) {
        assert (stringsList != null);
        assert (NullUtils.isCollectionNonNull(stringsList));
        return new StringsArgAttachment(stringsList);
    }

    public StringsArgAttachment(@NonNull List<@NonNull String> values) {
        super(values, stringListCache);
    }

    public StringsArgAttachment(@NonNull String value) {
        this((List)NullUtils.neverNull(Collections.singletonList(value)));
    }

    @Override
    public @NonNull String getConcatenatedString() {
        StringBuilder stringToReturn = new StringBuilder();
        for (String string : this) {
            stringToReturn.append(string);
        }
        return (String)NullUtils.neverNull((Object)stringToReturn.toString());
    }

    @Override
    public @NonNull String getDescriptiveText() {
        if (this.isNull()) {
            return "NULL";
        }
        return (String)NullUtils.neverNull((Object)String.format("\"%s\"", this.getConcatenatedString()));
    }

    @Override
    public @NonNull ArgumentHierarchyNode getArgumentHierarchy() {
        if (this.isNull()) {
            return ArgumentHierarchyLeaf.nullPointer(this.getArgumentName());
        }
        FormatSpec format = this.getArgumentSpec().getFormat();
        if (format != null && format.getScalar() != null) {
            assert (format.getScalar().getString() != null);
            assert (this.size() == 1);
            return new ArgumentHierarchyLeaf(this.getArgumentName(), (String)NullUtils.neverNull((Object)((String)this.get(0))), ArgumentHierarchyLeaf.LeafType.STRING);
        }
        ArrayList<@NonNull ArgumentHierarchyNode> elements = new ArrayList<ArgumentHierarchyNode>(this.size());
        for (String value : this) {
            elements.add(new ArgumentHierarchyLeaf(value, ArgumentHierarchyLeaf.LeafType.STRING));
        }
        return ArgumentHierarchyBranch.arrayHierarchy((String)NullUtils.neverNull((Object)this.getArgumentName()), elements);
    }
}

